package com.entitystream.monster.geo;
import com.entitystream.monster.db.*;
public class Line implements GeoType {
        
    private Point start;
    private Point end;
    
    public Line(Point start, Point end) {
        this.start=start;
        this.end=end;
       
    }

    public Point getFrom() {
        return start;
    }

    public Point getTo() {
        return end;
    }
   
   
    public Point[] getPoints() {
        return new Point[]{start,end};
    }
    
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point){
           Point point =  ((Point)geo);    
           return GeoType.calculateLineXAtY(this,point.getY())==point.getX();
        } else if (geo instanceof LineString){
             Point lastpoint=null;
             for (Point point :  ((LineString)geo).getPoints()){
                 if (lastpoint!=null){
                    if (!checkInside(new Line(lastpoint, point)))
                       return false;
                 }
                 lastpoint=point;
             }
             return true;
        } else if (geo instanceof Line){
             return GeoType.calculateLineIntersection(this, (Line)geo).valid();
        } else if (geo instanceof Polygon){
             Point lastpoint=null;
             for (Point point :  ((Polygon)geo).getPoints()){
                 if (lastpoint!=null){
                    if (!checkInside(new Line(lastpoint, point)))
                       return false;
                 }
                 lastpoint=point;
             }
             return true;
        }
        return false;
    }
    
    public String toString(){
        return start.toString() + " -> " + end.toString();
    }
}

