package com.entitystream.monster.geo;
import com.entitystream.monster.db.*;
public class LineString implements GeoType {
        
    private Point[] points;
  
    
    public LineString(Point[] points) {
        this.points=points;
       
    }
    
    public Line[] getLines(){
         Point lastpoint=null;
         Line[] lines = new Line[getPoints().length-1];
         int pos=-1;
         for (Point point :  getPoints()){
             if (lastpoint!=null)
                 lines[++pos]=new Line(lastpoint, point);
             lastpoint=point;
         }
         return lines;
    }

    public Point getFrom() {
        if (points.length>0)
           return points[0];
        else return null;
    }

    public Point getTo() {
        if (points.length>0)
           return points[points.length-1];
        else return null;
    }
    
    public Point[] getPoints() {
        return points;
    }
    
    public Line toLine(){
        return new Line(getFrom(), getTo());  
    }
    
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point){
           Point point =  ((Point)geo);
            for (Line line : getLines()){
                if (GeoType.calculateLineXAtY(line,point.getY())==point.getX())
                    return true;
            }
           return false;
        } else if (geo instanceof LineString){
            for (Line line : getLines()){
             for (Line line2 : ((LineString)geo).getLines()){
                 if (GeoType.calculateLineIntersection(line,line2).valid())
                  return true;
             }
            }
             return false;
        } else if (geo instanceof Line){
             for (Line line2 : getLines()){
                 if (GeoType.calculateLineIntersection((Line)geo,line2).valid())
                  return true;
             }
             return false;
        } else if (geo instanceof Polygon){
               Point lastpoint=null;
               for (Point point :  ((Polygon)geo).getPoints()){
                 if (lastpoint!=null){
                    if (!checkInside(new Line(lastpoint, point)))
                       return false;
                 }
                 lastpoint=point;
               }
               return true;
        }
        return false;
    }
}

