package com.entitystream.monster.geo;
import com.entitystream.monster.db.*;
public class Point implements GeoType{

    private double x;
    private double y;
    
    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point){
          Point point = (Point)geo;
          return point.equals(this);
        } else if (geo instanceof LineString){
             for (Point point :  ((LineString)geo).getPoints())
                 if (!checkInside(point))
                    return false;
             return true;
        } else if (geo instanceof Line){
             return (checkInside(((Line)geo).getFrom()) &&checkInside(((Line)geo).getTo()));
        } else if (geo instanceof Polygon){
             for (Point point :  ((Polygon)geo).getPoints())
                 if (!checkInside(point))
                    return false;
             return true;
        }
        return false;
    }
    
    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }
    
    public boolean valid(){
        return x!=Double.NEGATIVE_INFINITY && y!=Double.NEGATIVE_INFINITY && x!=Double.POSITIVE_INFINITY && y!=Double.POSITIVE_INFINITY;
    }
    
    public Point[] getPoints() {
        return new Point[]{new Point(x,y)};
    }
    
    public String toString(){
        return "["+x+","+y+"]";
    }

    public boolean equals(Point other){
        return (other.getX()==getX()) && (other.getY()==getY());
    }
}