package com.entitystream.monster.geo;
import java.util.List;
import java.util.LinkedList;
import java.util.Collections;
import java.util.Comparator;
import com.entitystream.monster.db.Document;

public class Polygon implements GeoType{

    private Point[] points;

    public Polygon(Point[] points) {
        this.points = points;
    }

    public Point[] getPoints() {
        return points;
    }
    
    public String toString(){
        StringBuilder sb=new StringBuilder();
        sb.append("Polygon");
		for (Point p : getPoints())
		   sb.append(" "+p.toString());
        return sb.toString();
        
    }

    public boolean checkInside(GeoType geo) {
        if (geo instanceof Point){
          Point point = (Point)geo;
          List<Line> lines = calculateLines();
          List<Line> intersectionLines = GeoType.filterIntersectingLines(lines, point.getY());
          List<Point> intersectionPoints = GeoType.calculateIntersectionPoints(intersectionLines,  point.getY());
          GeoType.sortPointsByX(intersectionPoints);
          return GeoType.calculateInside(intersectionPoints,  point);
        } else if (geo instanceof LineString){
             for (Point point :  ((LineString)geo).getPoints())
                 if (!checkInside(point))
                    return false;
             return true;
        } else if (geo instanceof Line){
             return (checkInside(((Line)geo).getFrom()) &&checkInside(((Line)geo).getTo()));
        } else if (geo instanceof Polygon){
             for (Point point :  ((Polygon)geo).getPoints())
                 if (!checkInside(point))
                    return false;
             return true;
        }
        return false;
    }


    private List<Line> calculateLines() {
       List<Line> results = new LinkedList<Line>();

    // get the polygon points
       Point[] points = getPoints();

    // form lines by connecting the points
       Point lastPoint = null;
       for (Point point : points) {
         if (lastPoint != null) {
            results.add(new Line(lastPoint, point));
         }
         lastPoint = point;
       }

       // close the polygon by connecting the last point 
       // to the first point
       if (!lastPoint.equals(points[0]))
           results.add(new Line(lastPoint, points[0]));

       return results;
  }







}

