/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.db;

import com.entitystream.monster.db.Document;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;

public class BaseNode {
    private String id;
    private Document props;
    private String tableName;
    private String keyName;
    private String keyValue;
    private boolean match;

    public BaseNode(String id, Document values, String tableName, String keyName, String keyValue, boolean match) {
        this.match = match;
        this.keyName = keyName;
        this.keyValue = keyValue;
        this.props = values;
        if (tableName != null) {
            this.tableName = tableName;
        } else if (values != null && values.get("Table") != null) {
            this.tableName = (String)values.get("Table");
        }
        this.id = id == null ? keyName + ":" + keyValue : id;
    }

    public BaseNode(String id, Document values, String tableName, boolean match) {
        this.match = match;
        this.id = id;
        this.props = values;
        if (tableName != null) {
            this.tableName = tableName;
        } else if (values != null && values.get("Table") != null) {
            this.tableName = (String)values.get("Table");
        }
    }

    public BaseNode(String id, String keyName, String keyValue) {
        this.match = false;
        this.id = id == null ? keyName + ":" + keyValue : id;
        this.props = new Document(keyName, keyValue);
    }

    private Object clone(Object val) {
        if (val instanceof String) {
            return new String((String)val);
        }
        if (val instanceof Long) {
            return new Long((Long)val);
        }
        if (val instanceof Integer) {
            return new Integer((Integer)val);
        }
        if (val instanceof Date) {
            return ((Date)val).clone();
        }
        if (val instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)val).toInstant(ZoneOffset.UTC));
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Boolean) {
            return (boolean)((Boolean)val);
        }
        if (val instanceof ArrayList) {
            ArrayList<Object> newone = new ArrayList<Object>();
            for (Object item : (ArrayList)val) {
                newone.add(this.clone(item));
            }
            return newone;
        }
        System.out.println(val.getClass().getName());
        return null;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        return this.keyName + ":" + this.keyValue;
    }

    public Document getProperties() {
        return this.props;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setProperty(String property, Object value) {
        this.props.put(property, value);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public Document getDocument() {
        Document out = new Document(this.props);
        out.append("Table", this.tableName);
        return out;
    }

    public void setProperties(Document vals) {
        this.props = vals;
    }

    public void setMatch(boolean m) {
        this.match = m;
    }

    public boolean match() {
        return this.match;
    }
}

