/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.db;

import com.entitystream.identiza.db.BaseNode;
import com.entitystream.identiza.db.BaseRelationship;
import com.entitystream.identiza.db.WorkTypes;
import com.entitystream.monster.db.Document;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CommitItem
implements WorkTypes {
    protected BaseNode baseNode = null;
    public HashSet<BaseRelationship> addRelCache;
    public HashSet<BaseRelationship> delRelCache;
    public int action;
    private boolean active = true;
    private Lock lock = new ReentrantLock();

    public static CommitItem add(BaseNode node) {
        CommitItem item = new CommitItem(node, 1);
        return item;
    }

    public static CommitItem delete(BaseNode node) {
        CommitItem item = new CommitItem(node, -1);
        return item;
    }

    private CommitItem(BaseNode nde, int type) {
        this.addRelCache = new HashSet();
        this.delRelCache = new HashSet();
        this.baseNode = nde;
        this.action = type;
    }

    public void addRelationship(BaseRelationship rel) {
        this.addRelCache.add(rel);
    }

    public void deleteRelationship(BaseRelationship rel) {
        this.delRelCache.add(rel);
    }

    public String getID() {
        if (this.baseNode != null) {
            return this.baseNode.getId();
        }
        return null;
    }

    public BaseNode getNode() {
        return this.baseNode;
    }

    public void suspend() {
        this.lock.lock();
        this.active = false;
    }

    public void activate() {
        this.lock.unlock();
        this.active = true;
    }

    public void setValues(Document values) {
        this.baseNode.setProperties(values);
    }

    public boolean isActive() {
        return this.active;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int act) {
        this.action = act;
    }
}

