/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.db;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.IRelationship;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.monster.db.Document;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface INode {
    public String getId();

    public Iterator<IRelationship> getRelationships(String var1, Date var2) throws Exception;

    public Iterator<IRelationship> getRelationships(Date var1) throws Exception;

    public Iterator<IRelationship> getRelationships(String var1, String var2, Date var3) throws Exception;

    public Object getProperty(String var1);

    public IRelationship createRelationshipTo(INode var1, String var2, Date var3, Map<String, Object> var4) throws Exception;

    public Map<String, Object> getPropertyValues() throws Exception;

    public void setDB(IDBContainer var1);

    public void setProperties(Document var1);

    public Document getDocument();

    public ArrayList<String> getProperties(List<String> var1);

    public String getTableName();

    public void setID(String var1);

    public String toJSON() throws Exception;

    public static Object[] getWords(Document node, List<PurposeColumnMap> map, WordList anon, Date when) throws Exception {
        ArrayList resmultirecs = new ArrayList();
        ArrayList resonerec = new ArrayList();
        StringBuilder allWords = new StringBuilder();
        int largest = 0;
        if (map != null) {
            for (PurposeColumnMap purposeColumnMap : map) {
                largest = Math.max(purposeColumnMap.getColumnOrder(), largest);
            }
            for (int t = 0; t < largest; ++t) {
                resonerec.add(new ArrayList());
            }
            for (PurposeColumnMap purposeColumnMap : map) {
                int o;
                String string = Document.objectToString(node.getProjection(purposeColumnMap.getTableColumn()));
                allWords.append(string + " ");
                ArrayList<String> resinner = new ArrayList<String>();
                if (string != null) {
                    String[] strs;
                    for (String str : strs = WordList.split(string)) {
                        if ((str = WordList.clean(str)).length() <= 0) continue;
                        if (anon == null) {
                            resinner.add(str);
                            continue;
                        }
                        if (!anon.isUsefulForComparison(str, 0)) continue;
                        resinner.add(str);
                    }
                }
                if ((o = purposeColumnMap.getColumnOrder()) > 1) {
                    --o;
                }
                resonerec.add(o, resinner);
            }
        }
        if (resmultirecs.size() > 0) {
            ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>();
            for (ArrayList arrayList : resmultirecs) {
                ret.add(INode.compressInitials(arrayList));
            }
            return new Object[]{ret, allWords.toString().trim()};
        }
        ArrayList<String> compress = new ArrayList<String>();
        for (ArrayList arrayList : resonerec) {
            compress.addAll(INode.compressInitials(arrayList));
        }
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        arrayList.add(compress);
        return new Object[]{arrayList, allWords.toString().trim()};
    }

    public static Object[] getWords(INode node, List<PurposeColumnMap> map, WordList anon, Date when) throws Exception {
        return INode.getWords(node.getDocument(), map, anon, when);
    }

    public static ArrayList<String> compressInitials(ArrayList<String> in) {
        String accumulate = "";
        ArrayList<String> out = new ArrayList<String>();
        if (in.size() > 1) {
            for (String word : in) {
                if (word.trim().length() == 1) {
                    accumulate = accumulate + word.trim();
                    continue;
                }
                if (accumulate.length() > 0) {
                    out.add(accumulate);
                    accumulate = "";
                }
                out.add(word);
            }
            if (accumulate.length() > 0) {
                out.add(accumulate);
            }
        } else {
            return in;
        }
        return out;
    }

    public static List<Document> serialize(List<Standardized> standards) {
        ArrayList<Document> list = new ArrayList<Document>();
        try {
            for (Standardized std : standards) {
                list.add(std.toDocument());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Standardized> deserialise(List<Document> bsonlist, Class<? extends Standardized> procClass) {
        ArrayList<Standardized> ret = new ArrayList<Standardized>();
        try {
            for (Document d : bsonlist) {
                Standardized std = StandardizedSerialized.fromDocument(d);
                ret.add(std);
            }
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public Object setProperty(String var1, Object var2);

    public boolean hasProperty(String var1);
}

