/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.db;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.IRelationship;
import com.entitystream.identiza.db.Relationship;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Node
implements Serializable,
INode {
    IDBContainer db;
    String id;
    Date when;
    Document baseDoc;
    private Logger logger = Logger.getLogger("Node");
    private String tableName;

    public Node(IDBContainer db, Document document) throws Exception {
        this.baseDoc = document;
        this.db = db;
        this.id = this.baseDoc != null && this.baseDoc.containsKey("_id") ? this.baseDoc.getString("_id") : null;
    }

    public Node(Document document) throws Exception {
        this.baseDoc = document;
        this.id = this.baseDoc.containsKey("_id") ? this.baseDoc.getString("_id") : null;
    }

    public Node(IDBContainer db, String id, Date when) throws Exception {
        this.baseDoc = db.getNode(id);
        this.db = db;
        this.id = id;
        this.when = when;
    }

    public Node(IDBContainer db, String id, Document baseDoc) throws Exception {
        this.baseDoc = baseDoc;
        this.db = db;
        this.id = id;
    }

    public Node(IDBContainer db, String id, Date when, Document baseDoc) throws Exception {
        this.baseDoc = baseDoc;
        this.db = db;
        this.id = id;
        this.when = when;
    }

    public Node(IDBContainer db, String id) {
        this.id = id;
        this.db = db;
        this.baseDoc = db.getNode(id);
    }

    public Node(ITable table, Map values) {
        String incPath = "";
        if (this.baseDoc == null) {
            this.baseDoc = new Document();
        }
        for (Object col : values.keySet()) {
            Document parent = this.baseDoc;
            String colname = "";
            if (col instanceof TableColumn) {
                colname = ((TableColumn)col).getColName();
            } else if (col instanceof String) {
                colname = (String)col;
            }
            String[] path = colname.split("\\.");
            for (int p = 0; p < path.length - 1; ++p) {
                String property = path[p];
                int inspos = property.indexOf("[");
                int instance = 0;
                if (inspos > -1) {
                    String instanceS = property.substring(inspos).replace("[", "").replace("]", "");
                    instance = Integer.parseInt(instanceS);
                    property = property.substring(0, inspos);
                }
                incPath = incPath + property;
                TableColumn pathCol = table.getColumn(incPath);
                if (parent instanceof ArrayList) {
                    if (pathCol.getDisplayType().equalsIgnoreCase("Structure")) {
                        ((ArrayList)((Object)parent)).add(new Document());
                    } else if (pathCol.getDisplayType().equalsIgnoreCase("List")) {
                        ((ArrayList)((Object)parent)).add(instance, new ArrayList());
                    }
                } else if (parent instanceof Document) {
                    if (pathCol.getDisplayType().equalsIgnoreCase("Structure")) {
                        parent.append(property, new Document());
                    } else if (pathCol.getDisplayType().equalsIgnoreCase("List")) {
                        parent.append(property, new ArrayList());
                    }
                }
                incPath = incPath + ".";
            }
            if (!(parent instanceof Document)) continue;
            parent.append(path[path.length - 1], values.get(col));
        }
    }

    @Override
    public boolean hasProperty(String arg0) {
        if (this.baseDoc != null) {
            return this.baseDoc.containsKey(arg0);
        }
        return false;
    }

    @Override
    public Object setProperty(String arg0, Object arg1) {
        if (this.baseDoc == null) {
            this.baseDoc = new Document();
        }
        Serializable parent = this.baseDoc;
        String incPath = "";
        if (arg0 == null) {
            return null;
        }
        String[] paths = arg0.split("\\.");
        for (int p = 0; p < paths.length - 1; ++p) {
            Serializable newParent;
            String pathItem = paths[p];
            String sPathItem = pathItem;
            if (sPathItem.indexOf("[") != -1) {
                sPathItem.substring(0, sPathItem.indexOf("["));
            }
            if ((newParent = ((Document)parent).get(sPathItem)) == null) {
                newParent = pathItem.contains("[") ? new ArrayList() : new Document();
            }
            if (parent instanceof Document) {
                if (!((Document)parent).containsKey(pathItem)) {
                    ((Document)parent).append(pathItem, newParent);
                }
            } else if (parent instanceof ArrayList) {
                String[] spl = pathItem.split("[");
                pathItem = spl[0];
                int instance = Integer.parseInt(spl[1].replace("]", ""));
                ((ArrayList)parent).add(instance, new Document(pathItem, newParent));
            }
            parent = newParent;
        }
        arg0 = arg0.substring(arg0.lastIndexOf(".") + 1);
        if (parent instanceof Document) {
            ((Document)parent).append(arg0, arg1);
        }
        return this.baseDoc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Iterator<IRelationship> getRelationships(String arg0, Date when) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        try {
            for (String lng : this.db.getNodeRelationships(this.id, arg0, when)) {
                Document reldoc = this.db.getRelProperties(lng, when);
                Relationship rel = new Relationship(this.db, reldoc, when);
                rels.add(rel);
            }
        }
        catch (Exception oe) {
            oe.printStackTrace();
        }
        return rels.iterator();
    }

    @Override
    public Iterator<IRelationship> getRelationships(Date when) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        try {
            for (String lng : this.db.getNodeRelationships(this.id, when)) {
                Document reldoc = this.db.getRelProperties(lng, when);
                Relationship rel = new Relationship(this.db, reldoc, when);
                rels.add(rel);
            }
        }
        catch (Exception oe) {
            oe.printStackTrace();
        }
        return rels.iterator();
    }

    @Override
    public Iterator<IRelationship> getRelationships(String reltype, String dir, Date when) throws Exception {
        ArrayList<String> frels;
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        if (this.id != null && (frels = this.db.getNodeRelationships(this.id, reltype, dir, when)) != null) {
            Iterator<String> iterator = frels.iterator();
            try {
                while (iterator.hasNext()) {
                    String lng = iterator.next();
                    Document reldoc = this.db.getRelProperties(lng, when);
                    Relationship rel = new Relationship(this.db, reldoc, when);
                    rels.add(rel);
                }
            }
            catch (IdentizaException oe) {
                oe.printStackTrace();
            }
        }
        return rels.iterator();
    }

    @Override
    public Object getProperty(String arg0) {
        return this.getProperty(this.baseDoc, arg0);
    }

    private Object getProperty(Document doc, String arg) {
        Object obj = this.getPropertyPath(doc, arg + "");
        if (obj != null) {
            arg = arg.substring(arg.lastIndexOf(".") + 1);
            if (obj instanceof Document) {
                return ((Document)obj).get(arg);
            }
            if (obj instanceof ArrayList) {
                ArrayList<Object> ret = new ArrayList<Object>();
                for (Object arrayItem : (ArrayList)obj) {
                    if (arrayItem instanceof Document) {
                        ret.add(((Document)arrayItem).get(arg));
                        continue;
                    }
                    if (arrayItem instanceof ArrayList) {
                        ret.addAll((ArrayList)arrayItem);
                        continue;
                    }
                    ret.add(arrayItem);
                }
                return ret;
            }
            return obj;
        }
        return null;
    }

    private Object getPropertyPath(Document doc, String arg) {
        if (arg == null) {
            return null;
        }
        int pos = arg.indexOf(".");
        if (pos > -1) {
            ArrayList<Object> parent = doc;
            String[] propList = arg.split("\\.");
            for (int p = 0; p < propList.length - 1; ++p) {
                String property = propList[p];
                int instance = 0;
                int inspos = property.indexOf("[");
                if (inspos > -1) {
                    String instanceS = property.substring(inspos).replace("[", "").replace("]", "");
                    instance = Integer.parseInt(instanceS);
                    property = property.substring(0, inspos);
                }
                if (parent instanceof Document) {
                    parent = ((Document)((Object)parent)).get(propList[p]);
                    continue;
                }
                if (!(parent instanceof ArrayList)) continue;
                ArrayList<Object> newparent = new ArrayList<Object>();
                for (Object arrayItem : (ArrayList)parent) {
                    if (!(arrayItem instanceof Document)) continue;
                    newparent.add(((Document)arrayItem).get(propList[p]));
                }
                parent = newparent;
            }
            return parent;
        }
        return doc;
    }

    @Override
    public IRelationship createRelationshipTo(INode arg0, String arg1, Date when, Map<String, Object> values) throws Exception {
        try {
            Document rel = this.db.createNodeRelationshipTo(this.id, this.getProperty("Table").toString(), arg0.getId(), arg0.getProperty("Table").toString(), arg1, values, when);
            return new Relationship(this.db, rel, when);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getPropertyValues() throws Exception {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String k : this.baseDoc.keyString()) {
            Node.flattenDoc(k, this.baseDoc.get(k), ret, "");
        }
        return ret;
    }

    public static Document expandDoc(Map<String, Object> flatdoc, ITable iTable) {
        Document temp = new Document();
        for (String key : flatdoc.keySet()) {
            Object value = flatdoc.get(key);
            if (key == null || value == null || value instanceof String && ((String)value).length() == 0) continue;
            String[] parts = key.split("\\.");
            Document parent = temp;
            String partInc = "";
            for (String part : parts) {
                Object newParent;
                partInc = partInc + part;
                TableColumn col = null;
                String colName = partInc.replaceAll("\\[[0-9]*?\\]", "");
                if (iTable != null) {
                    col = iTable.getColumn(colName);
                }
                String type = null;
                if (col != null) {
                    type = col.getDisplayType();
                }
                if (type == null || type.length() == 0) {
                    type = "text";
                }
                int levelinstance = 0;
                if (part.contains("[")) {
                    String[] partSplit = part.split("\\[");
                    part = partSplit[0];
                    levelinstance = Integer.parseInt(partSplit[1].replace("]", ""));
                }
                if (type.equalsIgnoreCase("Structure")) {
                    newParent = new Document();
                    if (parent instanceof Document) {
                        if (!parent.containsKey(part)) {
                            parent.append(part, newParent);
                        } else {
                            newParent = parent.get(part);
                        }
                    } else if (parent instanceof ArrayList) {
                        Document listparent;
                        Document listitem;
                        if (levelinstance > ((ArrayList)((Object)parent)).size() - 1) {
                            for (int expand = ((ArrayList)((Object)parent)).size() - 1; expand < levelinstance; ++expand) {
                                ((ArrayList)((Object)parent)).add(new Document());
                            }
                        }
                        if ((listitem = (Document)(listparent = (Document)((ArrayList)((Object)parent)).get(levelinstance)).get(part)) == null) {
                            listitem = new Document();
                        }
                        if (!listparent.containsKey(part)) {
                            listparent.append(part, newParent);
                        } else {
                            newParent = listitem;
                        }
                    }
                    parent = newParent;
                } else if (type.equalsIgnoreCase("List")) {
                    newParent = new ArrayList();
                    if (parent instanceof Document) {
                        if (!parent.containsKey(part)) {
                            parent.append(part, newParent);
                        } else {
                            newParent = parent.get(part);
                        }
                    } else if (parent instanceof ArrayList) {
                        if (levelinstance > ((ArrayList)((Object)parent)).size() - 1) {
                            for (int expand = ((ArrayList)((Object)parent)).size() - 1; expand < levelinstance - 1; ++expand) {
                                ((ArrayList)((Object)parent)).add(new Document());
                            }
                        }
                        ((ArrayList)((Object)parent)).set(levelinstance, new Document(part, newParent));
                    }
                    parent = newParent;
                } else if (parent instanceof Document) {
                    parent.append(part, value);
                } else if (parent instanceof ArrayList) {
                    Document instancearray = null;
                    if (((ArrayList)((Object)parent)).size() > levelinstance) {
                        instancearray = (Document)((ArrayList)((Object)parent)).get(levelinstance);
                    }
                    if (instancearray == null) {
                        instancearray = new Document();
                    }
                    if (instancearray instanceof Document) {
                        instancearray.append(part, value);
                    }
                }
                partInc = partInc + ".";
            }
        }
        return temp;
    }

    public static void flattenDoc(String path, Object obj, Map<String, Object> ret, String instanceText) {
        if (obj instanceof Document) {
            for (String k : ((Document)obj).keyString()) {
                if (path.length() > 0) {
                    Node.flattenDoc(path + "." + k + instanceText, ((Document)obj).get(k), ret, "");
                    continue;
                }
                Node.flattenDoc(k + instanceText, ((Document)obj).get(k), ret, "");
            }
        } else if (obj instanceof ArrayList) {
            int instance = 0;
            for (Object innerobj : (ArrayList)obj) {
                Node.flattenDoc(path, innerobj, ret, "[" + instance + "]");
                ++instance;
            }
        } else if (obj != null) {
            ret.put(path + instanceText, obj);
        }
    }

    public static void flattenDocToString(String path, Object obj, StringBuilder ret, String instanceText) {
        if (obj instanceof Document) {
            for (String k : ((Document)obj).keyString()) {
                if (path.length() > 0) {
                    Node.flattenDocToString(path + "." + k + instanceText, ((Document)obj).get(k), ret, "");
                    continue;
                }
                Node.flattenDocToString(k + instanceText, ((Document)obj).get(k), ret, "");
            }
        } else if (obj instanceof ArrayList) {
            int instance = 0;
            for (Object innerobj : (ArrayList)obj) {
                Node.flattenDocToString(path, innerobj, ret, "[" + instance + "]");
                ++instance;
            }
        } else {
            ret.append(obj + " ");
        }
    }

    @Override
    public void setDB(IDBContainer db2) {
        this.db = db2;
    }

    @Override
    public void setProperties(Document vals) {
        this.baseDoc.putAll((Map)vals);
    }

    @Override
    public Document getDocument() {
        return this.baseDoc;
    }

    @Override
    public ArrayList<String> getProperties(List<String> cols) {
        ArrayList<StringBuilder> fullvals = new ArrayList<StringBuilder>();
        for (String colname : cols) {
            String lastParent = "";
            String parent = "";
            parent = colname.indexOf(".") > -1 ? colname.substring(0, colname.lastIndexOf(".")) : colname;
            Object value = this.getProperty(colname);
            if (parent.equalsIgnoreCase(lastParent) || lastParent.length() == 0) {
                if (value != null) {
                    if (value instanceof ArrayList) {
                        for (int p = 0; p < ((ArrayList)value).size(); ++p) {
                            String s = Document.objectToString(((ArrayList)value).get(p)) + " ";
                            if (fullvals.size() - 1 < p || fullvals.get(p) == null) {
                                fullvals.add(p, new StringBuilder(s));
                                continue;
                            }
                            ((StringBuilder)fullvals.get(p)).append(s);
                        }
                    } else {
                        String s = Document.objectToString(value) + " ";
                        if (fullvals.size() - 1 < 0 || fullvals.get(0) == null) {
                            fullvals.add(0, new StringBuilder(s));
                        } else {
                            ((StringBuilder)fullvals.get(0)).append(s);
                        }
                    }
                }
            } else {
                for (StringBuilder fullval : fullvals) {
                    if (value instanceof ArrayList) {
                        for (int p = 0; p < ((ArrayList)value).size(); ++p) {
                            String s = Document.objectToString(((ArrayList)value).get(p)) + " ";
                            fullval.append(s);
                        }
                        continue;
                    }
                    String s = Document.objectToString(value) + " ";
                    fullval.append(s);
                }
            }
            lastParent = parent;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (StringBuilder fullval : fullvals) {
            ret.add(fullval.toString().trim());
        }
        return ret;
    }

    public static boolean applyInheritanceFrom(INode iNode2, INode iNode, HashSet<IPurpose> hashSet, ISchemaMeta schDoc) {
        boolean hasChanged = false;
        for (IPurpose purpose : hashSet) {
            int targetAlgo = purpose.getTargetAlgo();
            if (targetAlgo == -1) continue;
            Date tlu = iNode.getDocument().getDate("lastUpdated");
            Date lu = iNode2.getDocument().getDate("lastUpdated");
            block5: for (PurposeColumn pc : schDoc.getPurposeColumns(purpose.getPurposeName(), iNode2.getTableName())) {
                for (PurposeColumnMap pcm : schDoc.getPurposeColumnMaps(purpose.getPurposeName(), pc.getColumn(), iNode2.getTableName())) {
                    boolean done = false;
                    for (PurposeColumnMap pcmExt : schDoc.getPurposeColumnMaps(purpose.getPurposeName(), pc.getColumn(), iNode.getTableName())) {
                        if (!pcmExt.getPurposeColumn().equalsIgnoreCase(pcm.getPurposeColumn()) || !pcmExt.getPurposeName().equalsIgnoreCase(pcm.getPurposeName()) || !pcm.getTableName().equalsIgnoreCase(iNode2.getTableName())) continue;
                        try {
                            Object targetValue = iNode.getProperty(pcmExt.getTableColumn());
                            Object currentValue = iNode2.getProperty(pcm.getTableColumn());
                            if (lu == null || tlu == null || tlu.after(lu) || targetAlgo == 1) {
                                iNode.setProperty(pcmExt.getTableColumn(), currentValue);
                                hasChanged = true;
                                done = true;
                                break;
                            }
                            if (targetAlgo == 2 && targetValue != null && Document.objectToString(currentValue).length() > Document.objectToString(targetValue).length()) {
                                iNode.setProperty(pcmExt.getTableColumn(), currentValue);
                                hasChanged = true;
                                done = true;
                                break;
                            }
                            if (targetAlgo != 0) continue;
                            iNode.setProperty(pcmExt.getTableColumn(), currentValue);
                            hasChanged = true;
                            done = true;
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!done) continue;
                    continue block5;
                }
            }
        }
        try {
            if (hasChanged) {
                iNode.setProperty("lastUpdated", new Date());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasChanged;
    }

    @Override
    public String getTableName() {
        if (this.tableName == null && this.baseDoc.containsKey("Table")) {
            this.tableName = this.baseDoc.getString("Table");
        }
        return this.tableName;
    }

    @Override
    public void setID(String id) {
        this.id = id;
        if (this.baseDoc != null) {
            this.baseDoc.put("ROWID", id);
        }
    }

    @Override
    public String toJSON() throws Exception {
        return this.baseDoc.toJson();
    }
}

