/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.db;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.IRelationship;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Relationship
implements Serializable,
IRelationship {
    private String id;
    private Date when;
    private Document properties;
    private List<INode> nodes;

    public Relationship(IDBContainer db, Document doc, Date when) throws Exception {
        if (doc == null) {
            throw new IdentizaException("Invalid Node");
        }
        this.id = doc.getString("_id");
        if (this.id == null) {
            throw new IdentizaException("Invalid Node");
        }
        this.properties = doc;
        this.when = when;
        this.nodes = new ArrayList<INode>();
        this.nodes.add(new Node(db, db.getNode(this.properties.getString("fromCol"))));
        this.nodes.add(new Node(db, db.getNode(this.properties.getString("toCol"))));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<INode> getNodes() {
        return this.nodes;
    }

    @Override
    public INode getOtherNode(INode node) {
        for (INode thisNode : this.getNodes()) {
            if (thisNode.equals(node)) continue;
            return thisNode;
        }
        return null;
    }

    @Override
    public void setLastUpdate(Date date) {
        this.when = date;
    }

    @Override
    public String getType() throws Exception {
        return this.properties.getString("reltype");
    }

    @Override
    public Document getProperties() {
        return this.properties;
    }

    @Override
    public INode getEndNode() {
        if (this.nodes.size() > 0) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    @Override
    public void setProperties(Document values) {
        this.properties.putAll((Map)values);
    }
}

