/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.db.path;

import com.entitystream.identiza.db.DBWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dijkstra {
    private DBWorker db;
    private Set<String> settledNodes;
    private Set<String> unSettledNodes;
    private Map<String, String> predecessors;
    private Map<String, Integer> distance;
    private List<String> validTables;

    public Dijkstra(DBWorker db, List<String> validTables) {
        this.db = db;
        this.validTables = validTables;
    }

    public void execute(String source, Date when) {
        this.settledNodes = new HashSet<String>();
        this.unSettledNodes = new HashSet<String>();
        this.distance = new HashMap<String, Integer>();
        this.predecessors = new HashMap<String, String>();
        this.distance.put(source, 0);
        this.unSettledNodes.add(source);
        while (this.unSettledNodes.size() > 0) {
            String node = this.getMinimum(this.unSettledNodes);
            this.settledNodes.add(node);
            this.unSettledNodes.remove(node);
            this.findMinimalDistances(node, when);
        }
    }

    private void findMinimalDistances(String node, Date when) {
        List<String> adjacentNodes = this.getNeighbors(node, when);
        for (String target : adjacentNodes) {
            if (this.getShortestDistance(target) <= this.getShortestDistance(node) + this.getDistance(node, target, when)) continue;
            this.distance.put(target, this.getShortestDistance(node) + this.getDistance(node, target, when));
            this.predecessors.put(target, node);
            this.unSettledNodes.add(target);
        }
    }

    private int getDistance(String node, String target, Date when) {
        for (String edge : this.db.getNodeRelationships(node, when)) {
            if (this.db.getRelOtherNode(edge, node, new Date()) != target) continue;
            return 0;
        }
        throw new RuntimeException("Should not happen");
    }

    private List<String> getNeighbors(String node, Date when) {
        ArrayList<String> neighbors = new ArrayList<String>();
        for (String edge : this.db.getNodeRelationships(node, when)) {
            String table;
            String dest = this.db.getRelOtherNode(edge, node, new Date());
            if (!this.db.hasNodeProperty(dest, "Table") || !this.validTables.contains(table = (String)this.db.getNodeProperty(dest, "Table")) || this.isSettled(dest)) continue;
            neighbors.add(dest);
        }
        return neighbors;
    }

    private String getMinimum(Set<String> Stringes) {
        String minimum = null;
        for (String String2 : Stringes) {
            if (minimum == null) {
                minimum = String2;
                continue;
            }
            if (this.getShortestDistance(String2) >= this.getShortestDistance(minimum)) continue;
            minimum = String2;
        }
        return minimum;
    }

    private boolean isSettled(String String2) {
        return this.settledNodes.contains(String2);
    }

    private int getShortestDistance(String destination) {
        Integer d = this.distance.get(destination);
        if (d == null) {
            return Integer.MAX_VALUE;
        }
        return d;
    }

    public LinkedList<String> getPath(String target) {
        LinkedList<String> path = new LinkedList<String>();
        String step = target;
        if (this.predecessors.get(step) == null) {
            return null;
        }
        path.add(step);
        while (this.predecessors.get(step) != null) {
            step = this.predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }
}

