/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.extract;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MagentoReader {
    Iterator<Element> catElems = null;
    Iterator<Element> prodElems = null;

    public MagentoReader(File filename) throws IOException {
        Document doc = Jsoup.parse((File)filename, (String)"UTF-8");
        this.catElems = doc.body().select(".nav-item > a > span").iterator();
        this.prodElems = doc.body().select(".item").iterator();
    }

    public MagentoReader(String url) throws IOException {
        Document doc = Jsoup.connect((String)url).get();
        this.catElems = doc.body().select(".nav-item > a").iterator();
        this.prodElems = doc.body().select(".item").iterator();
    }

    public static void main(String[] args) {
        try {
            MagentoReader mr = new MagentoReader("https://www.lovebrewing.co.uk/wine/wine-kits/");
            ArrayList<JsonObject> cats = new ArrayList<JsonObject>();
            JsonObject category = mr.readCategory();
            while (category != null) {
                System.out.println(category);
                category = mr.readCategory();
                cats.add(category);
            }
            ArrayList<JsonObject> prods = new ArrayList<JsonObject>();
            for (JsonObject cat : cats) {
                String link = cat.get("Link").getAsString();
                MagentoReader mr2 = new MagentoReader(link);
                JsonObject product = mr2.readProduct();
                while (product != null) {
                    System.out.println(product);
                    product = mr.readCategory();
                    if (product == null) continue;
                    product.addProperty("Category", cat.get("Name").getAsString());
                    prods.add(product);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JsonObject readCategory() {
        if (this.catElems.hasNext()) {
            Element element = this.catElems.next();
            JsonObject jo = new JsonObject();
            jo.addProperty("Link", element.attr("href"));
            jo.addProperty("Name", element.select("span").first().text());
            return jo;
        }
        return null;
    }

    private JsonObject readProduct() {
        if (this.prodElems.hasNext()) {
            Element element = this.prodElems.next();
            JsonObject jo = new JsonObject();
            jo.addProperty("Name", element.select(".product-name > a").text());
            Element img = element.select(".product-image-wrapper > a > img").first();
            jo.addProperty("Image", img.attr("src"));
            jo.addProperty("ImageAltText", img.attr("alt"));
            jo.addProperty("ID", img.attr("id"));
            JsonArray priceArray = new JsonArray();
            jo.add("Prices", (JsonElement)priceArray);
            Elements prices = element.select(".price-box");
            for (Element price : prices) {
                JsonObject pr = new JsonObject();
                String label = price.select(".price-label").text();
                if (label == null || label.length() == 0) {
                    label = "Regular";
                }
                pr.addProperty("Name", label);
                pr.addProperty("Price", price.select(".price").text());
                priceArray.add((JsonElement)pr);
            }
            return jo;
        }
        return null;
    }
}

