/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.extract;

import au.com.bytecode.opencsv.CSVReader;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.storage.RecordValues;
import com.entitystream.identiza.metadata.IdentizaSettings;
import com.entitystream.monster.db.Document;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.EmptyFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TizaReader
implements Serializable {
    private transient XPath xPath = XPathFactory.newInstance().newXPath();
    protected static Logger logger = Logger.getLogger("com.entitystream.identiza.TizaReader");
    public static final int CSV = 0;
    public static final int JDBC = 1;
    public static final int OBJECTSTREAM = 2;
    public static final int EXCEL = 3;
    public static final int XML = 4;
    public static final int MONGO = 5;
    public static final int EDGAR = 6;
    protected int TYPE = -1;
    private String display;
    char _delimiter;
    char _quote;
    String filename;
    String encoding;
    transient CSVReader csv;
    transient ObjectInputStream objectStream;
    private transient ResultSet rs;
    transient Connection dbConnection = null;
    String sql = null;
    List<String> cols = new ArrayList<String>();
    private String driver;
    private String connection;
    private String username;
    private String password;
    Boolean valid = true;
    private transient Sheet sheet;
    private transient Workbook workbook;
    private int rowcount = -1;
    private int sheetno;
    private String rootNode = "lei:LEIRecord";
    boolean execRunning = false;
    private boolean started = false;
    private transient ExecutorService exec = Executors.newSingleThreadExecutor();
    protected LinkedBlockingQueue<Map<String, Object>> recordQueue = new LinkedBlockingQueue(10000);
    private ArrayList<String> errors = new ArrayList();
    protected int status;
    private Iterable<JsonObject> docs;
    private Iterator<JsonObject> docIterator;
    private String shortFile;
    private JsonObject metaDoc;
    private int XLSfirstRowNum = 0;
    private int XLSlastRowNum;
    private int XLSfirstColNum = 0;
    private int XLSlastColNum;

    public ArrayList<String> getStatus() {
        return this.errors;
    }

    public boolean isValid() {
        return this.status == 1;
    }

    public static TizaReader createXLSReader(String filename, int sheetno, String metadata) throws IOException {
        return new TizaReader(filename, sheetno, metadata);
    }

    public static TizaReader createOBJECTReader(String filename) throws IOException {
        return new TizaReader(filename);
    }

    public static TizaReader createCSVReader(String filename, String quote, String delimiter, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        return new TizaReader(filename, quote, delimiter, encoding);
    }

    public static TizaReader createJDBCReader(String driver, String connection, String user, String passwd, String sql) throws SQLException {
        return new TizaReader(driver, connection, user, passwd, sql);
    }

    public static TizaReader createXMLReader(String absolutePath, String rootNode) throws IOException {
        return new TizaReader(absolutePath, rootNode);
    }

    public static TizaReader createMongoReader(Iterable<JsonObject> docs) throws IOException {
        return new TizaReader(docs);
    }

    public static TizaReader createZIPReader(Properties properties, String groupName) throws IOException, SQLException {
        List<String> filePaths = TizaReader.getZIPFile(properties.getProperty("extractPattern"), properties, groupName);
        String fileType = properties.getProperty("fileType");
        Iterator<String> iterator = filePaths.iterator();
        if (iterator.hasNext()) {
            String filePath = iterator.next();
            if (filePath != null) {
                if (filePath.toUpperCase().endsWith("XLS")) {
                    return TizaReader.createXLSReader(filePath, Integer.parseInt(properties.getProperty("sheetno", "0")), "{}");
                }
                if (filePath.toUpperCase().endsWith("CSV")) {
                    return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
                }
                if (filePath.toUpperCase().endsWith("XML")) {
                    return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
                }
                if (fileType.equalsIgnoreCase("ZIP")) {
                    return TizaReader.createZIPReader(properties, groupName);
                }
                if (fileType.equalsIgnoreCase("CSV")) {
                    return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
                }
                if (fileType.equalsIgnoreCase("XML")) {
                    return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
                }
                logger.severe("File can not be processed, I simply cant tell what type it is");
                return new TizaReader("File can not be processed, I simply cant tell what type it is");
            }
            return new TizaReader("Could get a file from the zip");
        }
        return null;
    }

    private static List<String> getZIPFile(String extractPattern, Properties properties, String groupName) throws IOException {
        return TizaReader.unzip(properties.getProperty("filename"), IdentizaSettings.getUserTempPath() + "/", extractPattern);
    }

    public static List<String> unzip(String zipFilePath, String destDirectory, String filter) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        if (zipFilePath.toUpperCase().endsWith("TAR.GZ")) {
            GzipCompressorInputStream gzipIn = new GzipCompressorInputStream((InputStream)new FileInputStream(zipFilePath));
            TarArchiveInputStream zipIn = new TarArchiveInputStream((InputStream)gzipIn);
            TarArchiveEntry entry = (TarArchiveEntry)zipIn.getNextEntry();
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    try {
                        if (filter == null || filePath.matches(filter)) {
                            logger.info("Extracting " + filePath + " from zip file " + zipFilePath);
                            ret.add(TizaReader.extractFile((InputStream)zipIn, filePath));
                        }
                    }
                    catch (PatternSyntaxException w) {
                        logger.severe("Couldnt tell if we needed this file as the pattern is throwing an error " + w.toString());
                    }
                } else {
                    File dir = new File(filePath);
                    dir.mkdir();
                }
                entry = (TarArchiveEntry)zipIn.getNextEntry();
            }
            zipIn.close();
        } else if (zipFilePath.toUpperCase().endsWith(".GZ")) {
            GZIPInputStream gzipIn = new GZIPInputStream(new FileInputStream(zipFilePath));
            logger.info("Extracting gz file " + zipFilePath);
            ret.add(TizaReader.extractFile(gzipIn, zipFilePath.replaceAll(".gz", "")));
        } else {
            ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    try {
                        if (filter == null || filePath.matches(filter)) {
                            logger.info("Extracting " + filePath + " from zip file " + zipFilePath);
                            ret.add(TizaReader.extractFile(zipIn, filePath));
                        }
                    }
                    catch (PatternSyntaxException w) {
                        logger.severe("Couldnt tell if we needed this file as the pattern is throwing an error " + w.toString());
                    }
                } else {
                    File dir = new File(filePath);
                    dir.mkdir();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            zipIn.close();
        }
        return ret;
    }

    private static String extractFile(InputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[30000];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
        return filePath;
    }

    public static TizaReader createHTTPReader(String fileName, Properties properties, String groupName) throws IOException, SQLException {
        try {
            String filePath;
            logger.info("Downloading a file from a site " + fileName);
            Document headers = new Document();
            if (properties.getProperty("httpheaders") != null) {
                headers = Document.parse(properties.getProperty("httpheaders"));
            }
            if ((filePath = TizaReader.getHTTPFile(fileName, properties.getProperty("httpusername"), properties.getProperty("httppassword"), headers)) != null) {
                properties.setProperty("filename", filePath);
                String fileType = properties.getProperty("fileType");
                if (filePath.toUpperCase().endsWith("ZIP")) {
                    return TizaReader.createZIPReader(properties, groupName);
                }
                if (filePath.toUpperCase().endsWith("CSV")) {
                    return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
                }
                if (filePath.toUpperCase().endsWith("XML")) {
                    return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
                }
                if (fileType.equalsIgnoreCase("ZIP")) {
                    return TizaReader.createZIPReader(properties, groupName);
                }
                if (fileType.equalsIgnoreCase("CSV")) {
                    return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
                }
                if (fileType.equalsIgnoreCase("XML")) {
                    return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
                }
                return new TizaReader("File can not be processed " + fileType);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new TizaReader("An error occurred getting the file from the HTTP server");
    }

    public static String decodeDates(String url, Date d) {
        SimpleDateFormat sdf;
        String bit;
        HashMap<String, String> substitutions;
        if (url.indexOf("$") > -1) {
            substitutions = new HashMap<String, String>();
            for (int i = 0; i < url.length(); ++i) {
                if (url.charAt(i) != '$' || url.indexOf(";", i + 1) <= -1) continue;
                bit = url.substring(i + 1, url.indexOf(";", i + 1));
                sdf = new SimpleDateFormat(bit);
                substitutions.put("\\$" + bit + "\\;", sdf.format(d));
            }
            for (String find : substitutions.keySet()) {
                url = url.replaceAll("" + find, (String)substitutions.get(find));
            }
        }
        if (url.indexOf("{") > -1) {
            substitutions = new HashMap();
            for (int i = 0; i < url.length(); ++i) {
                if (url.charAt(i) != '{' || url.indexOf("}", i + 1) <= -1) continue;
                bit = url.substring(i + 1, url.indexOf("}", i + 1));
                sdf = new SimpleDateFormat(bit);
                substitutions.put("\\{" + bit + "\\}", sdf.format(d));
            }
            for (String find : substitutions.keySet()) {
                url = url.replaceAll("" + find, (String)substitutions.get(find));
            }
        }
        return url;
    }

    public static String getHTTPFile(String url, String username, String password, Document headers) throws URISyntaxException, ClientProtocolException, IOException {
        String target = "download" + url.hashCode();
        target = IdentizaSettings.getUserTempPath() + "/" + target;
        File targetFile = new File(target);
        if (targetFile.exists() && targetFile.length() > 0L) {
            logger.info("Target file was already available locally and it seems ok - aborting download (" + target + ")");
        } else {
            HttpResponse resp;
            DefaultHttpClient httpClient = null;
            if (username != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
                httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            } else {
                httpClient = new DefaultHttpClient();
            }
            HttpGet http = new HttpGet();
            http.setURI(new URI(url));
            if (headers != null) {
                for (Object hd : headers.keySet()) {
                    http.setHeader((String)hd, (String)headers.get(hd));
                }
            }
            if ((resp = httpClient.execute((HttpUriRequest)http)).getStatusLine().getStatusCode() != 200) {
                logger.severe("HTTP get Expected 200 but got " + resp.getStatusLine().getStatusCode() + ", for " + url);
                return null;
            }
            HttpEntity entity = resp.getEntity();
            InputStream is = entity.getContent();
            byte[] b = new byte[30000];
            FileOutputStream fs = new FileOutputStream(target);
            int r = 0;
            while ((r = is.read(b)) != -1) {
                fs.write(b, 0, r);
            }
            fs.close();
            is.close();
        }
        return target;
    }

    public static TizaReader createReader(String url, Properties properties, String groupName) throws IOException, SQLException {
        if (url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://")) {
            return TizaReader.createHTTPReader(url, properties, groupName);
        }
        if (url.toLowerCase().startsWith("ftp://") || url.toLowerCase().startsWith("ftps://")) {
            return TizaReader.createFTPReader(url, properties, groupName);
        }
        return TizaReader.createFileReader(url, properties, groupName);
    }

    public static TizaReader createFileReader(String filePath, Properties properties, String groupName) throws IOException, SQLException {
        String fileType = properties.getProperty("fileType");
        if (filePath == null) {
            return null;
        }
        if (filePath.endsWith("zip")) {
            return TizaReader.createZIPReader(properties, groupName);
        }
        if (filePath.endsWith("csv")) {
            return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
        }
        if (filePath.endsWith("xml")) {
            return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
        }
        if (fileType.equalsIgnoreCase("ZIP")) {
            return TizaReader.createZIPReader(properties, groupName);
        }
        if (fileType.equalsIgnoreCase("CSV")) {
            return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
        }
        if (fileType.equalsIgnoreCase("XML")) {
            return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
        }
        return new TizaReader("File can not be processed");
    }

    public static TizaReader createFTPReader(String fileName, Properties properties, String groupName) throws IOException, SQLException {
        String filePath = TizaReader.getFTPFile(properties.getProperty("extractPattern"), fileName, properties.getProperty("ftpusername"), properties.getProperty("ftppassword"));
        String fileType = properties.getProperty("fileType");
        if (filePath == null) {
            return null;
        }
        if (filePath.endsWith("zip")) {
            return TizaReader.createZIPReader(properties, groupName);
        }
        if (filePath.endsWith("csv")) {
            return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
        }
        if (filePath.endsWith("xml")) {
            return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
        }
        if (fileType.equalsIgnoreCase("ZIP")) {
            return TizaReader.createZIPReader(properties, groupName);
        }
        if (fileType.equalsIgnoreCase("CSV")) {
            return TizaReader.createCSVReader(filePath, properties.getProperty("quote"), properties.getProperty("delimiter"), properties.getProperty("encoding"));
        }
        if (fileType.equalsIgnoreCase("XML")) {
            return TizaReader.createXMLReader(filePath, properties.getProperty("rootNode"));
        }
        return new TizaReader("File can not be processed");
    }

    public static String getFTPFile(String extractPattern, String fileName, String username, String password) {
        String target = "download" + fileName.hashCode();
        target = IdentizaSettings.getUserTempPath() + "/" + target;
        File targetFile = new File(target);
        if (targetFile.exists() && targetFile.length() > 0L) {
            logger.info("Target file was already available locally and it seems ok - aborting download (" + target + ")");
        } else {
            try {
                URL url = new URL(fileName);
                FTPClient ftp = new FTPClient();
                int port = 21;
                if (url.getPort() != -1) {
                    port = url.getPort();
                }
                ftp.connect(url.getHost(), port);
                if (username != null && password != null) {
                    ftp.login(username, password);
                }
                FileOutputStream targetFileStream = new FileOutputStream(targetFile);
                ftp.retrieveFile(url.getFile(), (OutputStream)targetFileStream);
                ((OutputStream)targetFileStream).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return targetFile.getAbsolutePath();
    }

    private TizaReader(String filename, int sheetno, String metadata) throws IOException {
        this.filename = filename.replaceAll("\\\\", "/");
        this.TYPE = 3;
        this.display = filename;
        this.sheetno = sheetno;
        this.metaDoc = metadata != null ? (JsonObject)new JsonParser().parse(metadata) : new JsonObject();
        this.openExcel();
        this.status = 1;
        this.errors.clear();
    }

    private TizaReader(String xmlfilename, String rootNode) throws IOException {
        this.TYPE = 4;
        this.display = xmlfilename;
        this.filename = xmlfilename;
        this.rootNode = rootNode;
        this.status = 1;
        this.errors.clear();
    }

    private TizaReader(String filename) throws IOException {
        this.filename = filename.replaceAll("\\\\", "/");
        FileInputStream stream = new FileInputStream(this.filename);
        this.objectStream = new ObjectInputStream(stream);
        this.TYPE = 2;
        this.display = filename;
        this.status = 1;
        this.errors.clear();
    }

    private TizaReader(String filename, String quote, String delimiter, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        String[] quoteBits;
        int pos;
        logger.info("TizaReader init'd");
        this.encoding = encoding;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.filename = filename.replaceAll("\\\\", "/");
        if (delimiter.equals("\\t")) {
            delimiter = "\t";
        }
        if (delimiter.length() > 0) {
            this._delimiter = delimiter.charAt(delimiter.length() - 1);
        }
        if ((pos = 0) < (quoteBits = quote.split("x")).length) {
            this._quote = quoteBits[pos].equalsIgnoreCase("\"") || quoteBits[pos].equalsIgnoreCase("'") ? quoteBits[pos].charAt(0) : (char)Integer.parseInt(quoteBits[pos].replaceAll("%", ""), 16);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        this.csv = new CSVReader((Reader)reader, this._delimiter, this._quote);
        this.TYPE = 0;
        this.display = filename;
        this.status = 1;
        this.errors.clear();
        this.cols = this.getHeadings();
        try {
            this.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected TizaReader() {
        logger.info("TizaReader init'd");
    }

    private TizaReader(String driver, String connection, String user, String passwd, String sql) throws SQLException {
        logger.info("TizaReader init'd");
        this.sql = sql;
        this.driver = driver;
        this.username = user;
        this.password = passwd;
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception x) {
            logger.severe("Unable to load the driver class!");
            this.errors.add("Unable to load the driver class for the database");
            this.status = -1;
            this.valid = false;
            return;
        }
        try {
            this.dbConnection = DriverManager.getConnection(connection, user, passwd);
        }
        catch (SQLException x) {
            logger.severe("Couldn't get connection!");
            this.errors.add("I couldnt get a conection to the database");
            this.status = -1;
            this.valid = false;
            return;
        }
        Statement statement = this.dbConnection.createStatement();
        this.rs = statement.executeQuery(sql);
        int Col_Count = this.rs.getMetaData().getColumnCount();
        for (int Index2 = 1; Index2 <= Col_Count; ++Index2) {
            this.cols.add(this.rs.getMetaData().getColumnName(Index2));
        }
        this.TYPE = 1;
        this.display = sql;
    }

    private TizaReader(Iterable<JsonObject> docs) {
        this.TYPE = 5;
        this.display = "Reprocessing records";
        this.docs = docs;
    }

    public void setColumns(List<String> headings) {
        this.cols = headings;
    }

    public int getType() {
        return this.TYPE;
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        out.writeObject(new Character(this._delimiter));
        out.writeObject(new Character(this._quote));
        out.writeObject(this.cols);
        out.writeObject(this.display);
        out.writeObject(this.driver);
        out.writeObject(this.encoding);
        out.writeObject(this.filename);
        out.writeObject(this.password);
        out.writeObject(this.sql);
        out.writeObject(new Integer(this.TYPE));
        out.writeObject(this.username);
        out.writeObject(new Boolean(this.valid));
        out.writeObject(this.rootNode);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        try {
            this._delimiter = ((Character)in.readObject()).charValue();
            this._quote = ((Character)in.readObject()).charValue();
            this.cols = (ArrayList)in.readObject();
            this.display = (String)in.readObject();
            this.driver = (String)in.readObject();
            this.encoding = (String)in.readObject();
            this.filename = (String)in.readObject();
            this.password = (String)in.readObject();
            this.sql = (String)in.readObject();
            this.TYPE = (Integer)in.readObject();
            this.username = (String)in.readObject();
            this.valid = (Boolean)in.readObject();
            this.rootNode = (String)in.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() throws SQLException, IOException {
        if (this.valid.booleanValue()) {
            if (this.TYPE == 0) {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(this.filename));
                this.csv = new CSVReader((Reader)reader, this._delimiter, this._quote);
            } else if (this.TYPE == 3) {
                this.openExcel();
            } else if (this.TYPE == 1) {
                Statement statement = this.dbConnection.createStatement();
                this.rs = statement.executeQuery(this.sql);
            } else if (this.TYPE == 2) {
                this.filename = this.filename.replaceAll("\\\\", "/");
                FileInputStream stream = new FileInputStream(this.filename);
                this.objectStream = new ObjectInputStream(stream);
            } else if (this.TYPE == 4) {
                this.execRunning = false;
                if (this.exec != null) {
                    this.exec.shutdownNow();
                }
                this.exec = Executors.newSingleThreadExecutor();
                if (this.recordQueue != null) {
                    this.recordQueue.clear();
                } else {
                    this.recordQueue = new LinkedBlockingQueue(2000);
                }
                this.startXML();
            } else if (this.TYPE == 5) {
                this.docIterator = this.docs.iterator();
            }
        }
    }

    public TizaReader copy() throws SQLException, IOException {
        if (this.TYPE == 0) {
            return new TizaReader(this.filename, "" + this._quote, "" + this._delimiter, this.encoding);
        }
        if (this.TYPE == 3) {
            return new TizaReader(this.filename, this.sheetno, this.metaDoc.toString());
        }
        if (this.TYPE == 1) {
            return new TizaReader(this.driver, this.connection, this.username, this.password, this.sql);
        }
        if (this.TYPE == 2) {
            return new TizaReader(this.filename);
        }
        if (this.TYPE == 4) {
            return new TizaReader(this.filename, this.rootNode);
        }
        if (this.TYPE == 5) {
            return new TizaReader(this.docs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> readNext() throws Exception {
        Map<Object, Object> retval = null;
        Boolean bl = this.valid;
        synchronized (bl) {
            if (this.valid.booleanValue()) {
                if (this.TYPE == 0) {
                    String[] v = this.csv.readNext();
                    if (v != null) {
                        retval = new HashMap();
                        int pos = 0;
                        for (String column : this.cols) {
                            if (pos <= v.length - 1) {
                                String value = v[pos].trim();
                                retval.put(column, value);
                                ++pos;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (this.TYPE == 3) {
                    String[] v = this.readExcelRow();
                    if (v != null) {
                        retval = new HashMap();
                        int pos = 0;
                        for (String column : this.cols) {
                            if (pos <= v.length - 1) {
                                String value = v[pos];
                                retval.put(column, value);
                                ++pos;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (this.TYPE == 5) {
                    if (this.docIterator.hasNext()) {
                        retval = new HashMap();
                        JsonObject d = this.docIterator.next();
                        Node.flattenDoc("", d, retval, "");
                    }
                } else if (this.TYPE == 4) {
                    retval = this.readXMLRow();
                } else if (this.TYPE == 1) {
                    this.rs.next();
                    if (!this.rs.isLast()) {
                        retval = new HashMap();
                        for (int c = 0; c < this.rs.getMetaData().getColumnCount(); ++c) {
                            retval.put(this.rs.getMetaData().getColumnName(c), this.rs.getObject(c));
                        }
                    }
                } else if (this.TYPE == 2) {
                    RecordValues rv = null;
                    try {
                        rv = (RecordValues)this.objectStream.readObject();
                        retval = rv.toHashMap();
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                }
            }
        }
        return retval;
    }

    private List<String> getXMLCols(boolean forMetadata) {
        HashSet<String> columns = new HashSet<String>();
        this.startXML();
        if (this.cols == null || this.cols.size() == 0) {
            try {
                boolean nonStop = true;
                int lastcolcount = 0;
                int c = 0;
                while (nonStop && this.execRunning) {
                    Map<String, Object> rec = this.recordQueue.poll();
                    if (rec == null) continue;
                    for (String col : rec.keySet()) {
                        columns.add(col.replaceAll("\\[[0-9]*?\\]", ""));
                    }
                    if (++c % 1000 != 0 && this.execRunning) continue;
                    if (columns.size() == lastcolcount) {
                        nonStop = false;
                    }
                    lastcolcount = columns.size();
                }
                this.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap metadata = new HashMap();
        for (String col : columns) {
            StringBuilder incrementalParts = new StringBuilder();
            String[] colparts = col.split("\\.");
            for (int pos = 0; pos < colparts.length - 1; ++pos) {
                String colpart = colparts[pos];
                String nextpart = colparts[pos + 1];
                incrementalParts.append(colpart + ".");
                if (metadata.containsKey(incrementalParts.toString())) {
                    ((Set)metadata.get(incrementalParts.toString())).add(nextpart);
                    continue;
                }
                HashSet<String> set = new HashSet<String>();
                set.add(nextpart);
                metadata.put(incrementalParts.toString(), set);
            }
        }
        for (String key : metadata.keySet()) {
            if (key.equalsIgnoreCase(".")) continue;
            String type = "Group";
            if (((Set)metadata.get(key)).size() == 1) {
                type = "List";
            }
            if (key.endsWith(".")) {
                key = key.substring(0, key.length() - 1);
            }
            columns.add(key + " (" + type + ")");
        }
        this.cols.addAll(columns);
        Collections.sort(this.cols);
        return this.cols;
    }

    public void startXML() {
        if (!this.execRunning && !this.started) {
            this.execRunning = true;
            this.started = true;
            this.recordQueue.clear();
            SAXHandler handler = new SAXHandler(this.rootNode);
            this.exec.submit(new BackgroundSAXTask(handler));
        }
    }

    private Map<String, Object> readXMLRow() throws InterruptedException {
        this.startXML();
        Map<String, Object> record = null;
        if (this.recordQueue != null) {
            while (record == null) {
                record = this.recordQueue.poll();
                if (this.execRunning) continue;
                break;
            }
        }
        return record;
    }

    public String getDisplay() {
        if (this.display == null) {
            return "Starting job";
        }
        return this.display;
    }

    public List<String> getHeadings() {
        if (this.valid.booleanValue()) {
            try {
                if (this.TYPE == 0) {
                    this.reset();
                    String[] cs = this.csv.readNext();
                    this.cols = new ArrayList<String>();
                    for (String c : cs) {
                        this.cols.add(c.trim().replaceAll("\\.", "_"));
                    }
                    return this.cols;
                }
                if (this.TYPE == 3) {
                    return this.cols;
                }
                if (this.TYPE == 1) {
                    return this.cols;
                }
                if (this.TYPE == 2) {
                    return this.cols;
                }
                if (this.TYPE == 4) {
                    this.cols = this.getXMLCols(true);
                    return this.cols;
                }
                if (this.TYPE == 5) {
                    throw new IdentizaException("Please dont call get headings on a collection, its stupid");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void close() {
        try {
            if (this.TYPE == 0) {
                this.csv.close();
            } else if (this.TYPE == 3) {
                this.closeExcel();
            } else if (this.TYPE == 1) {
                this.rs.close();
            } else if (this.TYPE == 2) {
                this.objectStream.close();
            } else if (this.TYPE == 4) {
                this.recordQueue = null;
                this.exec = null;
                this.execRunning = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openExcel() {
        try {
            logger.info("Opening excel sheet " + this.filename + " please increase all power in the building");
            this.shortFile = this.filename.indexOf("/") > -1 ? this.filename.substring(this.filename.lastIndexOf("/")) : this.filename;
            File xlfile = new File(this.filename);
            if (xlfile.exists()) {
                this.workbook = WorkbookFactory.create((File)xlfile, null, (boolean)true);
                Row row = null;
                if (this.metaDoc != null && this.metaDoc.get("sheetName") != null) {
                    String sheetName = this.metaDoc.get("sheetName").getAsString();
                    if (sheetName == null) {
                        sheetName = "sheet1";
                    }
                    this.sheet = this.workbook.getSheet(sheetName);
                    this.XLSlastRowNum = this.metaDoc.get("endRow").getAsInt();
                    this.XLSfirstRowNum = this.metaDoc.get("startRow").getAsInt();
                    this.XLSlastColNum = this.metaDoc.get("endCol").getAsInt();
                    this.XLSfirstColNum = this.metaDoc.get("startCol").getAsInt();
                    row = this.sheet.getRow(this.XLSfirstRowNum);
                } else {
                    this.sheet = this.workbook.getSheetAt(this.sheetno);
                    this.XLSfirstRowNum = 0;
                    this.XLSfirstColNum = 0;
                    this.XLSlastRowNum = this.sheet.getLastRowNum();
                    row = this.sheet.getRow(this.XLSfirstRowNum);
                    this.XLSlastColNum = row.getLastCellNum();
                }
                this.cols = new ArrayList<String>();
                this.cols.add("ROW");
                for (int c = this.XLSfirstColNum; c < this.XLSlastColNum; ++c) {
                    Cell cell = row.getCell(c);
                    if (cell != null) {
                        this.cols.add(this.getCellAsString(cell));
                        continue;
                    }
                    this.cols.add(null);
                }
                this.rowcount = this.XLSfirstRowNum - 1;
            } else {
                logger.severe(this.filename + " does not exist");
            }
        }
        catch (EmptyFileException efe) {
            logger.severe(this.filename + " is empty");
            this.valid = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.valid = false;
        }
    }

    private String[] readExcelRow() {
        ++this.rowcount;
        if (this.rowcount <= this.XLSlastRowNum) {
            String[] values;
            block5: {
                Row row = null;
                values = null;
                try {
                    row = this.sheet.getRow(this.rowcount);
                    if (row != null) {
                        values = new String[Math.max(this.cols.size() + 1, row.getLastCellNum())];
                        values[0] = "[" + this.shortFile + "]" + this.sheet.getSheetName() + "!" + row.getRowNum();
                        for (int c = this.XLSfirstColNum; c < this.XLSlastColNum; ++c) {
                            Cell cell = row.getCell(c);
                            values[c + 1] = cell != null ? this.getCellAsString(cell) : null;
                        }
                        break block5;
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return values;
        }
        return null;
    }

    private String getCellAsString(Cell cell) {
        switch (cell.getCellType()) {
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateFormat.getInstance().format(cell.getDateCellValue());
                }
                String d = Double.toString(cell.getNumericCellValue());
                if (d.endsWith(".0")) {
                    d = d.replaceAll("\\.0$", "");
                }
                return d;
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
        }
        return cell.toString();
    }

    private void closeExcel() {
        try {
            this.workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void testJDBC(String[] args) {
        Connection dbConnection2;
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver").newInstance();
        }
        catch (Exception x) {
            logger.severe("Unable to load the driver class!");
            return;
        }
        try {
            dbConnection2 = DriverManager.getConnection("jdbc:hsqldb:hsql:/localhost/test", "sa", null);
        }
        catch (SQLException x) {
            logger.severe("Couldn't get connection!");
            return;
        }
        try {
            Statement statement = dbConnection2.createStatement();
            System.out.println(statement.execute("create table public.public.DEMODATA (acctid varchar(100), name varchar(255), stline1 varchar(255), stline2 varchar(255), city varchar(255), statecode varchar(255), postcode varchar(255))"));
            System.out.println(statement.execute("commit"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.status = 0;
        this.execRunning = false;
    }

    public static void main(String[] args) {
        try {
            for (String s : TizaReader.unzip("/private/tmp/tmp/b9efc25b-2fe0-4dd2-bb51-2f5b401ff05e.tar.gz", "/private/tmp/tmp/b9efc25b-2fe0-4dd2-bb51-2f5b401ff05e.tar", null)) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    class SAXHandler
    extends DefaultHandler {
        String content;
        String rootNode;
        Stack<String> path = new Stack();
        boolean inRoot = false;
        Map<String, Object> record = new HashMap<String, Object>();
        Map<String, Integer> pathCountList = new HashMap<String, Integer>();
        Integer pathCount = 0;
        public int count;

        public SAXHandler(String rootNode) {
            this.rootNode = rootNode;
            this.content = "";
            this.count = 0;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXParseException {
            if (!TizaReader.this.execRunning) {
                throw new SAXParseException("XML Reader Aborted prematurely", null);
            }
            if (this.rootNode == null) {
                this.rootNode = "";
            }
            String sqName = qName.replaceAll(".*?:", "");
            if (!this.inRoot && (this.rootNode.equalsIgnoreCase(qName) || this.rootNode.equalsIgnoreCase(sqName))) {
                this.inRoot = true;
                this.path = new Stack();
            } else if (this.inRoot) {
                String parentPath;
                String lookuppath = parentPath = "";
                if (!this.path.isEmpty()) {
                    parentPath = this.path.peek();
                    lookuppath = parentPath + "." + sqName;
                }
                this.pathCount = this.pathCountList.get(lookuppath);
                if (this.pathCount == null || lookuppath.length() == 0) {
                    this.pathCount = 0;
                } else {
                    Integer n = this.pathCount;
                    Integer n2 = this.pathCount = Integer.valueOf(this.pathCount + 1);
                }
                this.pathCountList.put(lookuppath, this.pathCount);
                String delim = "";
                if (parentPath.length() > 0) {
                    delim = ".";
                }
                String thispath = parentPath + delim + sqName + "[" + this.pathCount + "]";
                this.path.push(thispath);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXParseException {
            if (!TizaReader.this.execRunning) {
                throw new SAXParseException("XML Reader Aborted prematurely", null);
            }
            if (this.inRoot) {
                String thispath = "";
                if (!this.path.isEmpty()) {
                    thispath = this.path.pop();
                }
                if (this.content.length() > 0) {
                    this.record.put(thispath, this.content);
                }
                String sqName = qName.replaceAll(".*?:", "");
                if (this.rootNode.equalsIgnoreCase(qName) || this.rootNode.equalsIgnoreCase(sqName)) {
                    ++this.count;
                    while (!TizaReader.this.recordQueue.offer(this.record)) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    this.record = new HashMap<String, Object>();
                    this.pathCountList = new HashMap<String, Integer>();
                    this.inRoot = false;
                }
            }
            this.content = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXParseException {
            if (!TizaReader.this.execRunning) {
                throw new SAXParseException("XML Reader Aborted prematurely", null);
            }
            this.content = this.content + String.copyValueOf(ch, start, length).trim();
        }
    }

    class BackgroundSAXTask
    implements Runnable {
        private SAXHandler handler;
        private SAXParser parser;

        public BackgroundSAXTask(SAXHandler handler) {
            try {
                SAXParserFactory parserFactor = SAXParserFactory.newInstance();
                this.parser = parserFactor.newSAXParser();
                this.handler = handler;
            }
            catch (ParserConfigurationException | SAXParseException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                this.parser.parse((InputStream)new FileInputStream(TizaReader.this.filename), (DefaultHandler)this.handler);
                TizaReader.this.execRunning = false;
            }
            catch (SAXException e) {
                TizaReader.this.execRunning = false;
                TizaReader.this.recordQueue.clear();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

