/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.db.WorkTypes;
import com.entitystream.identiza.entity.resolve.match.MatchRecord;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRule;
import com.entitystream.identiza.entity.resolve.match.MatchRuleInterface;
import com.entitystream.identiza.entity.resolve.match.Matchable;
import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinition;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.monster.db.Document;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public class Indexable
implements Matchable {
    protected Map<String, List<MatchProcDefinition>> indexProcDefs = new HashMap<String, List<MatchProcDefinition>>();
    protected Map<String, Map<String, MatchProcInterface>> matchProcs = new HashMap<String, Map<String, MatchProcInterface>>();
    protected List<IRule> rules;
    protected ConcurrentHashMap<String, MatchRuleInterface> cacheRules = new ConcurrentHashMap();
    protected Map<String, Collection<String>> purposeTableColumns = new HashMap<String, Collection<String>>();
    protected ISchemaMeta schDoc;
    protected Map<String, Document> indexCatalogCache = new ConcurrentHashMap<String, Document>();
    protected LinkedBlockingQueue<Document> publishQueue = new LinkedBlockingQueue();
    public final List<IIndex> matchIndexes = new ArrayList<IIndex>();

    public MatchRecordInterface calculateScore(Document base, Document comparitor, boolean forSearch) throws Exception {
        MatchRecord result = null;
        for (int i = 0; i < this.rules.size(); ++i) {
            IRule rule = this.rules.get(new Integer(i));
            MatchRuleInterface mr = this.getMatchRule(rule.getHashKey(), rule.getOrder());
            if (!forSearch && !mr.canRun(base, comparitor)) continue;
            MatchRecord resultnew = mr.score(base, comparitor, forSearch, false, !forSearch);
            if (result == null || resultnew != null && resultnew.getScore() > result.getScore()) {
                result = resultnew;
            }
            if (result.getScore() >= rule.getHighScore() && !forSearch) break;
        }
        return result;
    }

    public static Document addXRef(Document survivedRec, Document deletedRec) throws Exception {
        if (survivedRec.get("_id") != deletedRec.get("_id")) {
            List<Document> deletedXref = Indexable.getXref(deletedRec);
            List<Document> survivedXref = Indexable.getXref(survivedRec);
            survivedXref.add(deletedRec);
            for (Document xd : deletedXref) {
                xd.remove("XREF");
                survivedXref.add(xd);
            }
            survivedRec.append("XREF", survivedXref);
        }
        return survivedRec;
    }

    public static List<Document> getXref(Document baseNode) throws Exception {
        ArrayList xref = (ArrayList)baseNode.get("XREF");
        if (xref == null) {
            xref = new ArrayList();
        }
        return xref;
    }

    public static Document addHistoryRecord(Document existingDoc, Document newValues, String action, String username) throws Exception {
        if (existingDoc == null) {
            return newValues;
        }
        Document newDoc = new Document();
        newDoc.putAll((Map)newValues);
        Document currentDoc = new Document();
        currentDoc.putAll((Map)existingDoc);
        currentDoc.remove("tokens");
        currentDoc.remove("standardised");
        ArrayList<Document> histValues = (ArrayList<Document>)currentDoc.get("history");
        if (histValues == null) {
            histValues = new ArrayList<Document>();
        } else {
            currentDoc.remove("history");
        }
        currentDoc.append("action", action);
        currentDoc.append("updatedBy", username);
        histValues.add(0, currentDoc);
        if (newDoc.containsKey("history")) {
            histValues.addAll((List)newDoc.get("history"));
            newDoc.remove("history");
        }
        newDoc.append("history", histValues);
        newDoc.put("action", "CURRENT");
        newDoc.put("updatedBy", username);
        return newDoc;
    }

    public Document calcGoldenRec(Document original, Document mergedrec, String tableName) {
        return Indexable.calcGoldenRec(original, mergedrec, tableName, this.schDoc);
    }

    public static Document calcGoldenRec(Document original, Document mergedrec, String tableName, ISchemaMeta schDoc) {
        Document res = new Document();
        try {
            Date recLUD = original.getDate("lastUpdated");
            if (!mergedrec.containsKey("lastUpdated")) {
                mergedrec.put("lastUpdated", schDoc.getTable(tableName).createDateFormatter().format(LocalDate.now()));
            }
            Date searchLUD = mergedrec.getDate("lastUpdated");
            boolean hasLastUpd = recLUD != null;
            boolean recLast = false;
            if (hasLastUpd) {
                recLast = recLUD.after(searchLUD);
            }
            if (recLast) {
                res.putAll((Map)original);
            } else {
                res.putAll((Map)mergedrec);
            }
            for (ITableColumn iTableColumn : schDoc.getColumns(tableName)) {
                Object exist = original.get(iTableColumn.getColName());
                if (exist != null) {
                    res.put(iTableColumn.getColName(), exist);
                    if (iTableColumn.isPrimaryKey()) continue;
                }
                String oldValue = Document.objectToString(original.get(iTableColumn.getColName()));
                String newValue = Document.objectToString(mergedrec.get(iTableColumn.getColName()));
                if (iTableColumn.getAction().equals("latest") && newValue != null && newValue.trim().length() > 0) {
                    if (recLast) continue;
                    res.put(iTableColumn.getColName(), newValue);
                    continue;
                }
                if (iTableColumn.getAction().equals("overrite") && newValue != null && newValue.trim().length() > 0) {
                    res.put(iTableColumn.getColName(), newValue);
                    continue;
                }
                if (iTableColumn.getAction().equals("longest") && newValue != null && newValue.trim().length() > oldValue.length()) {
                    res.put(iTableColumn.getColName(), newValue);
                    continue;
                }
                if (iTableColumn.getAction().equals("shortest") && newValue != null && newValue.trim().length() < oldValue.length()) {
                    res.put(iTableColumn.getColName(), newValue);
                    continue;
                }
                if (iTableColumn.getAction().equals("sum")) {
                    try {
                        double d1 = Double.parseDouble(oldValue);
                        double d2 = Double.parseDouble(newValue);
                        res.put(iTableColumn.getColName(), "" + (d1 + d2));
                    }
                    catch (Exception e) {
                        if (newValue == null) continue;
                        if (oldValue == null || oldValue.isEmpty()) {
                            res.put(iTableColumn.getColName(), newValue);
                            continue;
                        }
                        res.put(iTableColumn.getColName(), oldValue.trim() + " " + newValue);
                    }
                    continue;
                }
                if (!iTableColumn.getAction().equals("first") || oldValue != null || newValue == null || newValue.trim().length() <= 0) continue;
                res.put(iTableColumn.getColName(), newValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    protected MatchRuleInterface getMatchRule(String hashKey, int index) {
        MatchRuleInterface rule = this.cacheRules.get(hashKey);
        if (rule == null) {
            rule = new MatchRule(this.schDoc, this.rules.get(index));
            this.cacheRules.put(hashKey, rule);
        }
        return rule;
    }

    public void initialize(ISchemaMeta iSchemaMeta) {
        this.schDoc = iSchemaMeta;
        this.rules = iSchemaMeta.getRules(null);
        this.matchProcs = new HashMap<String, Map<String, MatchProcInterface>>();
        this.purposeTableColumns = new HashMap<String, Collection<String>>();
        this.indexProcDefs = new HashMap<String, List<MatchProcDefinition>>();
        this.matchIndexes.clear();
        for (IIndex ind : this.schDoc.getIndexes()) {
            if (!ind.isMatch()) continue;
            this.matchIndexes.add(ind);
            break;
        }
    }

    protected boolean isPrefixPattern(Object input) {
        return input instanceof Pattern && (((Pattern)input).pattern().startsWith("^") || ((Pattern)input).pattern().startsWith("\\A") || ((Pattern)input).pattern().matches("^\\w.*"));
    }

    protected boolean isPattern(Object input) {
        try {
            if (input instanceof Pattern) {
                return true;
            }
            if (input instanceof String) {
                String s = (String)input;
                return Pattern.compile("\\/|\\^|\\?|\\*").matcher(s).find();
            }
            return false;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    protected LinkedHashSet<Object> processKey(ArrayList<Collection> alternates, int startpos, Object keySoFar, String indexMethod) {
        LinkedHashSet<Object> allKeys = new LinkedHashSet<Object>();
        if (alternates.size() > 0) {
            for (Object comb1 : alternates.get(startpos)) {
                Object newKey = "";
                boolean mustStop = false;
                if (indexMethod.equalsIgnoreCase("IndexLookup")) {
                    newKey = ((String)keySoFar).length() > 0 ? keySoFar + "|" + Document.objectToString(comb1) : Document.objectToString(comb1);
                } else if (indexMethod.equalsIgnoreCase("IndexRangeScan")) {
                    if (this.isPrefixPattern(comb1)) {
                        String[] prefixElements;
                        String prefix = ((Pattern)comb1).pattern();
                        for (String pfe : prefixElements = prefix.split("\\A|^|\\/|\\.|\\?|\\*")) {
                            if (pfe.equalsIgnoreCase("\\A") || pfe.equalsIgnoreCase("^")) continue;
                            prefix = pfe;
                            break;
                        }
                        comb1 = prefix;
                        mustStop = true;
                    }
                    newKey = ((String)keySoFar).length() > 0 ? keySoFar + "|" + Document.objectToString(comb1) : Document.objectToString(comb1);
                } else if (indexMethod.equalsIgnoreCase("IndexScan")) {
                    if (this.isPattern(comb1)) {
                        comb1 = Pattern.compile(keySoFar + "|" + ((Pattern)comb1).pattern());
                        newKey = comb1;
                        mustStop = true;
                    } else {
                        newKey = ((String)keySoFar).length() > 0 ? keySoFar + "|" + Document.objectToString(comb1) : Document.objectToString(comb1);
                    }
                }
                if (!(newKey instanceof String) || ((String)newKey).length() != 0) {
                    if (!mustStop && startpos < alternates.size() - 1) {
                        allKeys.addAll(this.processKey(alternates, startpos + 1, newKey, indexMethod));
                    } else {
                        allKeys.add(newKey);
                    }
                }
                if (!mustStop) continue;
                break;
            }
        }
        return allKeys;
    }

    protected Collection<String> getMatchKeyCombinations(ArrayList<HashSet<String>> proctokens, int startpos, String keySoFar, int deep) {
        HashSet<String> allKeys = new HashSet<String>();
        if (deep > 10) {
            return allKeys;
        }
        if (proctokens.size() > 0) {
            for (String comb1 : proctokens.get(startpos)) {
                if (comb1 == null) {
                    comb1 = "";
                }
                String newKey = "";
                newKey = keySoFar.length() > 0 ? keySoFar + comb1 : comb1;
                if (startpos < proctokens.size() - 1) {
                    allKeys.addAll(this.getMatchKeyCombinations(proctokens, startpos + 1, newKey, deep + 1));
                    continue;
                }
                allKeys.add(newKey);
            }
        }
        return allKeys;
    }

    protected List<MatchProcDefinition> getCacheDefs(String indexName) {
        if (!this.indexProcDefs.containsKey(indexName)) {
            if (this.indexCatalogCache.get(indexName) != null) {
                Document options = this.indexCatalogCache.get(indexName).getAsDocument("Options");
                String matchProcsJson = options.getString("matchProcs");
                Type listType = new TypeToken<List<MatchProcDefinition>>(){}.getType();
                List defs = (List)new Gson().fromJson(matchProcsJson, listType);
                this.indexProcDefs.put(indexName, defs);
            } else {
                return Collections.EMPTY_LIST;
            }
        }
        return this.indexProcDefs.get(indexName);
    }

    protected Collection<String> getCachePurposeColumns(String purposeName, String tableName) {
        IPurpose purp;
        String key = purposeName + ":" + tableName;
        if (!this.purposeTableColumns.containsKey(key) && (purp = this.schDoc.getPurpose(purposeName)) != null) {
            this.purposeTableColumns.put(key, purp.getTableColumns(tableName));
        }
        return this.purposeTableColumns.get(key);
    }

    public Collection<String> getMatchKeys(String value, IIndex index) {
        if (index == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HashSet<String>> proctokens = new ArrayList<HashSet<String>>();
        List<MatchProcDefinition> defs = this.getCacheDefs(index.getIndexName());
        for (MatchProcDefinitionInterface matchProcDefinitionInterface : defs) {
            MatchProcInterface proc = this.getProc(index, matchProcDefinitionInterface);
            if (proc == null) continue;
            HashSet<String> keys = new HashSet<String>();
            Collection<String> keySet = proc.getKeys(value, true, true);
            if (keySet != null && keySet.size() > 0) {
                keys.addAll(keySet);
            }
            proctokens.add(keys);
        }
        ArrayList<String> newkeys = new ArrayList();
        newkeys = this.getMatchKeyCombinations(proctokens, 0, "", 0);
        return newkeys;
    }

    public Collection<String> getMatchKeys(Document values, ITable table, IIndex index, boolean isSearch) {
        if (table == null || index == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HashSet<String>> proctokens = new ArrayList<HashSet<String>>();
        List<MatchProcDefinition> defs = this.getCacheDefs(index.getIndexName());
        for (MatchProcDefinitionInterface matchProcDefinitionInterface : defs) {
            Collection<String> cols;
            MatchProcInterface proc = this.getProc(index, matchProcDefinitionInterface);
            if (proc == null || (cols = this.getCachePurposeColumns(matchProcDefinitionInterface.getPurposeName(), table.getTableName())) == null) continue;
            List<String> thisvals = values.getProperties(cols);
            HashSet<String> keys = new HashSet<String>();
            for (String fullval : thisvals) {
                Collection<String> keySet = proc.getKeys(fullval, true, isSearch);
                if (keySet != null && keySet.size() > 0) {
                    keys.addAll(keySet);
                }
                proctokens.add(keys);
            }
        }
        ArrayList<String> newkeys = new ArrayList();
        newkeys = this.getMatchKeyCombinations(proctokens, 0, "", 0);
        return newkeys;
    }

    private MatchProcInterface getProc(IIndex index, MatchProcDefinitionInterface procn) {
        if (this.matchProcs.get(index.getIndexName()) == null) {
            this.matchProcs.put(index.getIndexName(), new HashMap());
        }
        if (this.matchProcs.get(index.getIndexName()).get(procn.getProcName()) == null) {
            try {
                MatchProcInterface proc = procn.build();
                this.matchProcs.get(index.getIndexName()).put(procn.getProcName(), proc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.matchProcs.get(index.getIndexName()).get(procn.getProcName());
    }

    protected Document applyInheritanceFrom(Document sourceRec, Document targetRec) {
        boolean hasChanged = false;
        for (IPurpose purpose : this.schDoc.getPurposes()) {
            int targetAlgo = purpose.getTargetAlgo();
            if (targetAlgo == -1) continue;
            Date tlu = targetRec.getDate("lastUpdated");
            Date lu = sourceRec.getDate("lastUpdated");
            for (PurposeColumn pc : purpose.getPurposeColumns()) {
                for (PurposeColumnMap pcm : this.schDoc.getPurposeColumnMaps(purpose.getPurposeName(), pc.getColumn(), sourceRec.getString("Table"))) {
                    for (PurposeColumnMap pcmExt : this.schDoc.getPurposeColumnMaps(purpose.getPurposeName(), pc.getColumn(), targetRec.getString("Table"))) {
                        if (pcmExt.getColumnOrder() != pcm.getColumnOrder()) continue;
                        try {
                            Object targetValue = targetRec.get(pcmExt.getTableColumn());
                            Object currentValue = sourceRec.get(pcm.getTableColumn());
                            if (lu == null || tlu == null || tlu.after(lu) || targetAlgo == 1) {
                                targetRec.append(pcm.getTableColumn(), targetValue);
                                hasChanged = true;
                                continue;
                            }
                            if (targetAlgo == 2 && targetValue != null && Document.objectToString(targetValue).length() > Document.objectToString(currentValue).length()) {
                                targetRec.append(pcm.getTableColumn(), targetValue);
                                hasChanged = true;
                                continue;
                            }
                            if (targetAlgo != 0) continue;
                            targetRec.append(pcm.getTableColumn(), targetValue);
                            hasChanged = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        try {
            if (hasChanged) {
                targetRec.append("lastUpdated", new Date());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetRec;
    }

    protected static Response doREST(String url, String method, Entity payload, Document replacements, Document headers) {
        Client client = ClientBuilder.newClient();
        Response res = null;
        try {
            if (replacements != null) {
                for (String ID : replacements.keyString()) {
                    if (replacements.get(ID) instanceof String) {
                        url = url.replaceAll("\\{" + ID + "\\}", replacements.getString(ID));
                        continue;
                    }
                    if (replacements.get(ID) instanceof Long) {
                        url = url.replaceAll("\\{" + ID + "\\}", "" + replacements.getLong(ID));
                        continue;
                    }
                    if (!(replacements.get(ID) instanceof Integer)) continue;
                    url = url.replaceAll("\\{" + ID + "\\}", "" + replacements.getInteger(ID));
                }
            }
            Logger.getGlobal().log(Level.INFO, url);
            Invocation.Builder call = client.target(url).request(new String[]{"application/json"});
            if (headers != null) {
                for (Object hk : headers.keySet()) {
                    call.header((String)hk, headers.get(hk));
                }
            }
            if (method != null && method.equalsIgnoreCase("GET")) {
                res = call.get();
            }
            if (method != null && method.equalsIgnoreCase("POST")) {
                res = call.post(payload);
            }
            if (method != null && method.equalsIgnoreCase("PUT")) {
                res = call.put(payload);
            }
            if (method != null && method.equalsIgnoreCase("DELETE")) {
                res = call.delete();
            }
            if (res != null) {
                Logger.getLogger("MatchSchema").info(method + ":" + url + "=" + res.getStatus());
            } else {
                Logger.getLogger("MatchSchema").info(method + ":" + url + " returned null");
            }
        }
        catch (Exception e) {
            Logger.getLogger("MatchSchema").info(method + ":" + url + " returned error: " + e.getClass().getSimpleName());
            Logger.getLogger("MatchSchema").log(Level.SEVERE, e.toString());
            return null;
        }
        return res;
    }

    protected void send(Document mr) throws Exception {
        ITable table = this.schDoc.getTable(mr.getString("Table"));
        if (table.isInternal()) {
            new MatchItem(mr, 8).compute();
        }
    }

    @Override
    public boolean match(Document node) {
        return false;
    }

    @Override
    public boolean mergeSort(Document mr) {
        return false;
    }

    @Override
    public boolean eid(Document mr) {
        return false;
    }

    @Override
    public boolean link(Document mr) {
        return false;
    }

    @Override
    public boolean merge(Document mr) {
        return false;
    }

    @Override
    public boolean addTask(Document mr) {
        return false;
    }

    @Override
    public void resolveTask(Document mr) {
    }

    @Override
    public void invoke(String type, Document data) {
    }

    public class MatchItem
    implements WorkTypes {
        private static final long serialVersionUID = 1L;
        protected Document baseNode = null;
        public int action;

        public MatchItem(Document mr, int type) {
            this.action = type;
            this.baseNode = mr;
        }

        public void compute() {
            if (this.action == 2) {
                Indexable.this.match(this.baseNode);
            } else if (this.action == 4) {
                Indexable.this.mergeSort(this.baseNode);
            } else if (this.action == 6) {
                Indexable.this.addTask(this.baseNode);
            } else if (this.action == 5) {
                Indexable.this.link(this.baseNode);
            } else if (this.action == 7) {
                Indexable.this.eid(this.baseNode);
            }
        }

        public Document getMatchRecord() {
            return this.baseNode;
        }
    }
}

