/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.RecordValue;
import com.entitystream.identiza.entity.resolve.storage.RecordValues;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MatchCriteria
implements Serializable {
    private HashMap<String, String> colsvals = new HashMap();
    private String tableName;
    private String freeText;

    public MatchCriteria(String item) throws Exception {
        if (item != null) {
            if (item.contains(":") && !item.contains("_search:")) {
                String[] bits;
                item.replaceAll(":", "").replaceAll("=", ": ");
                this.tableName = item.substring(0, item.indexOf("("));
                int end = item.length();
                if (item.indexOf(")") > -1) {
                    end = item.indexOf(")");
                }
                String rest = item.substring(item.indexOf("(") + 1, end);
                for (String bit : bits = rest.split(";")) {
                    if (bit.indexOf(":") == -1) continue;
                    String column = bit.substring(0, bit.indexOf(":")).trim();
                    String value = bit.substring(bit.indexOf(":") + 1).trim();
                    this.addCriteria(column, value);
                }
            } else if (item.contains("_search:")) {
                this.tableName = item.substring(0, item.indexOf("_search:") - 1);
                this.freeText = item.substring(item.indexOf("_search:") + 8).trim();
                if (this.freeText.endsWith(")")) {
                    this.freeText = this.freeText.substring(0, this.freeText.length() - 1);
                }
            } else {
                this.tableName = item;
            }
        }
    }

    public MatchCriteria(RecordValues recordValues, String tableName, MatchSchemaInterface schema) throws Exception {
        this.tableName = tableName;
        for (RecordValue rv : recordValues.getValues()) {
            this.addCriteria(rv.getKey(), rv.getValue());
        }
    }

    public MatchCriteria(RecordInterface record, MatchSchemaInterface schema) throws Exception {
        this.tableName = record.getTableName();
        ConcurrentHashMap<String, Object> vals = record.getValues();
        for (String key : vals.keySet()) {
            this.addCriteria(key, vals.get(key).toString());
        }
    }

    public String toString() {
        String res = this.tableName + "(";
        for (String col : this.colsvals.keySet()) {
            res = res + col + ":" + this.colsvals.get(col) + ";";
        }
        if (this.hasFreeText()) {
            res = res + "\"" + this.freeText + "\"";
        }
        if (res.endsWith(";")) {
            res = res.substring(0, res.length() - 1);
        }
        res = res + ")";
        return res;
    }

    public boolean hasData() {
        return this.colsvals.size() > 0;
    }

    public void addCriteria(String tableColumn, String val) {
        this.colsvals.put(tableColumn, val);
    }

    public MatchCriteria addFreeText(String val) {
        this.freeText = val;
        return this;
    }

    public String getFreeText() {
        if (this.freeText != null) {
            return this.freeText.trim();
        }
        return null;
    }

    public String getValue(String colname) {
        for (String col : this.colsvals.keySet()) {
            if (!col.equalsIgnoreCase(colname)) continue;
            return this.colsvals.get(col);
        }
        return null;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int size() {
        return this.colsvals.size();
    }

    public void reset() {
        this.colsvals = new HashMap();
    }

    public boolean hasFreeText() {
        return this.freeText != null && this.freeText.length() > 0;
    }

    public HashMap<String, String> getValues() {
        return this.colsvals;
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> vals = new HashMap<String, Object>();
        for (String col : this.colsvals.keySet()) {
            vals.put(col, this.colsvals.get(col));
        }
        return vals;
    }
}

