/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.entity.resolve.match.Indexable;
import com.entitystream.identiza.entity.resolve.match.MatchIndexInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MatchIndex
extends Indexable
implements Serializable,
MatchIndexInterface {
    private String domainName;
    private HashMap<String, MatchProcInterface> matchProcs = new HashMap();
    private Logger logger = Logger.getLogger("com.entitystream.identiza");
    private IDBContainer db3;
    private MatchSchemaInterface matchSchema = null;
    private boolean isSearch = true;
    private boolean isMatch = true;
    public String REF_TOKEN = null;
    private boolean isTextIndex = false;
    private String instance;
    Collection<MatchProcDefinitionInterface> matchprocDefns;
    private int keyThreshold;
    private boolean isExactIndex;
    private ArrayList<String> matchProcKeys = new ArrayList();
    private String purposeName;
    Map<String, List<String>> cachedMappedColumnNames = new HashMap<String, List<String>>();

    public MatchIndex(IIndex index, MatchSchemaInterface schema) {
        this.domainName = index.getIndexName();
        this.isExactIndex = index.isExactIndex();
        this.isMatch = index.isMatch();
        this.isSearch = index.isSearch();
        this.keyThreshold = index.getKeyThreshold();
        this.matchSchema = schema;
        this.matchprocDefns = this.matchSchema.getSchDoc().getMatchProcs(this.domainName, this.instance, this.matchSchema.getGroupName());
        this.setPurposeName(index.getPurposeName());
        try {
            if (this.logger == null) {
                this.logger = Logger.getLogger("com.entitystream.identiza");
            }
            if (this.matchprocDefns.size() > 0) {
                for (MatchProcDefinitionInterface def : this.matchprocDefns) {
                    String defname = def.getProcName() + "";
                    MatchBase matchP = null;
                    String name = def.getClassName();
                    if (!name.contains(".")) {
                        name = "com.entitystream.identiza.entity.resolve.types." + name;
                    }
                    Class<?> clazz = Class.forName(name);
                    Constructor<?> cons = clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
                    matchP = (MatchBase)cons.newInstance(null, def.getMinWidth(), def.getMaxWidth());
                    matchP.init(null);
                    matchP.setRuleSet(def.getRuleSet());
                    matchP.setMandatory(def.getIsMandatory());
                    this.matchProcKeys.add(defname);
                    this.matchProcs.put(defname, matchP);
                    if (!matchP.isTextIndex()) continue;
                    this.isTextIndex = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.severe("Match Index could not be initialised, see previous error " + e.toString());
        }
    }

    @Override
    public boolean isTextIndex() {
        return this.isTextIndex;
    }

    @Override
    public void setDomainName(String columnName) {
        this.domainName = columnName;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public void setIsMatch(boolean ismatch) {
        this.isMatch = ismatch;
    }

    @Override
    public void setIsSearch(boolean issearch) {
        this.isSearch = issearch;
    }

    @Override
    public boolean isSearch() {
        return this.isSearch;
    }

    @Override
    public boolean isMatch() {
        return this.isMatch;
    }

    @Override
    public int getKeyThresholdDep() {
        return this.keyThreshold;
    }

    @Override
    public MatchProcInterface getMatchProc(String name) {
        return this.matchProcs.get(name);
    }

    @Override
    public ArrayList<String> getMatchProcs() {
        return this.matchProcKeys;
    }

    @Override
    public List<String> getMappedColumnNames(String table) {
        List<String> indexCols = this.cachedMappedColumnNames.get(table);
        if (indexCols != null && indexCols.size() != 0) {
            return indexCols;
        }
        indexCols = new ArrayList<String>();
        for (MatchProcDefinitionInterface procname : this.matchprocDefns) {
            for (String _col : this.matchSchema.getSchDoc().getTableColumnMaps(procname.getPurposeName(), table)) {
                if (_col == null || indexCols.contains(_col)) continue;
                indexCols.add(_col);
            }
        }
        this.cachedMappedColumnNames.put(table, indexCols);
        return indexCols;
    }

    @Override
    public List<String> getMappedColumnNames(String table, String procName) {
        List<String> indexCols = this.cachedMappedColumnNames.get(table + ":" + procName);
        if (indexCols != null && indexCols.size() != 0) {
            return indexCols;
        }
        indexCols = new ArrayList<String>();
        for (MatchProcDefinitionInterface procname : this.matchprocDefns) {
            if (!procName.equalsIgnoreCase(procname.getProcName())) continue;
            for (PurposeColumnMap _pcm : this.matchSchema.getSchDoc().getTablePurposeColumnMaps(table)) {
                if (_pcm == null || !(_pcm.getPurposeName() + "_" + _pcm.getPurposeColumn()).equalsIgnoreCase(procName) || indexCols.contains(_pcm.getTableColumn())) continue;
                indexCols.add(_pcm.getTableColumn());
            }
        }
        this.cachedMappedColumnNames.put(table, indexCols);
        return indexCols;
    }

    @Override
    public void setIsText(boolean isContent) {
        this.isTextIndex = isContent;
    }

    @Override
    public void setKeyThreshold(int thresh) {
        this.keyThreshold = thresh;
    }

    @Override
    public boolean isExactIndex() {
        return this.isExactIndex;
    }

    @Override
    public void setExactIndex(boolean isExactIndex) {
        this.isExactIndex = isExactIndex;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public void setInstance(String instance) {
        this.instance = instance;
    }

    private IDBContainer getDB() throws Exception {
        if (this.db3 == null) {
            this.db3 = this.matchSchema.getDb();
        }
        return this.db3;
    }

    @Override
    public int getKeyThreshold() {
        return this.keyThreshold;
    }

    @Override
    public void setPurposeName(String purposeName) {
        this.purposeName = purposeName;
    }

    @Override
    public String getPurposeName() {
        return this.purposeName;
    }
}

