/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.Result;
import com.entitystream.identiza.entity.resolve.storage.Task;
import com.entitystream.monster.db.Document;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Serializable;
import java.util.Date;

public class MatchRecord
implements Serializable,
MatchRecordInterface {
    private String record = null;
    private String baserecord = null;
    private String recordTableName;
    private String baserecordTableName;
    private String recordkey;
    private String baserecordkey;
    private double score;
    private IRule rule;
    private String action;
    private String actionText;
    private String baserecordsystem;
    private String recordsystem;
    private Date when;
    private Document recordDoc;
    private Document baseRecordDoc;
    private long baserecordEID;
    private long recordEID;
    private int type;
    private String taskID;

    public static MatchRecordInterface fromTask(MatchSchemaInterface schema, Task task) {
        try {
            Result[] nodes = task.getNodes();
            MatchRecord matchRecord = new MatchRecord();
            int count = 0;
            if (nodes != null) {
                for (Result node : nodes) {
                    String rowid = node.getID();
                    RecordInterface r = schema.getMatchTable(node.getTable()).getRecord(rowid);
                    if (count == 0) {
                        matchRecord.setRecord(r);
                    } else {
                        matchRecord.setBaseRecord(r);
                    }
                    ++count;
                }
            }
            matchRecord.setAction(task.getAction());
            matchRecord.setActionText(task.getType());
            matchRecord.setScore(task.getScore());
            matchRecord.setWhen(task.getCreated());
            matchRecord.taskID = task.getId();
            return matchRecord;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public MatchRecord(RecordInterface record, RecordInterface baserecord, double score, IRule rule, String action, String actionText) {
        String eids;
        if (record != null) {
            if (record.getBaseNode() != null) {
                this.record = record.getBaseNode().getId();
                this.recordDoc = record.getBaseNode().getDocument();
            }
            if (record.getPkey() == null) {
                System.out.println("Base node primary key null");
            }
            try {
                this.recordkey = record.getPkey();
                this.recordTableName = record.getTableName();
                this.setRecordsystem(record.getSystemName());
                eids = record.getValue(record.getEIDField());
                if (eids != null) {
                    this.setRecordEID(Long.parseLong(eids));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (baserecord != null) {
            if (baserecord.getBaseNode() != null) {
                this.baseRecordDoc = baserecord.getBaseNode().getDocument();
                this.baserecord = baserecord.getBaseNode().getId();
            } else {
                this.baserecord = null;
            }
            try {
                this.baserecordkey = baserecord.getPkey();
                this.baserecordTableName = baserecord.getTableName();
                this.setBaserecordsystem(baserecord.getSystemName());
                eids = baserecord.getValue(baserecord.getEIDField());
                if (eids != null) {
                    this.setBaseRecordEID(Long.parseLong(eids));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.score = Math.min(score, 100.0);
        this.rule = rule;
        this.action = action;
        this.actionText = actionText;
        this.setWhen(new Date());
        this.type = this.type;
    }

    public MatchRecord(Document record, Document baserecord, double score, IRule rule, String action, String actionText, String key, String baseKey) {
        if (record != null) {
            if (record != null) {
                this.record = record.getString("_id");
                this.recordDoc = record;
            }
            try {
                this.recordkey = key;
                this.recordTableName = record.getString("Table");
                this.setRecordEID(record.getLong("EID"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (baserecord != null) {
            if (baserecord != null) {
                this.baserecord = baserecord.getString("_id");
                this.baseRecordDoc = baserecord;
            }
            try {
                this.baserecordkey = baseKey;
                this.baserecordTableName = baserecord.getString("Table");
                this.setBaseRecordEID(baserecord.getLong("EID"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.score = Math.max(score, 0.0);
        this.rule = rule;
        this.action = action;
        this.actionText = actionText;
        this.setWhen(new Date());
    }

    private MatchRecord() {
    }

    private void setRecordEID(long value) {
        this.recordEID = value;
    }

    private void setBaseRecordEID(long value) {
        this.baserecordEID = value;
    }

    @Override
    public String getRecordID() {
        return this.record;
    }

    @Override
    public Node getBaseNode() throws Exception {
        return new Node(this.baseRecordDoc);
    }

    @Override
    public INode getNode() throws Exception {
        return new Node(this.recordDoc);
    }

    @Override
    public RecordInterface getRecord(MatchSchemaInterface schema) throws Exception {
        try {
            RecordInterface ret = RecordInterface.build(schema).assignNode(new Node(this.recordDoc));
            ret.load();
            return ret;
        }
        catch (IdentizaException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setRecord(RecordInterface record) {
        this.record = record.getBaseNode().getId();
        this.recordkey = record.getPkey();
        this.recordTableName = record.getTableName();
        this.recordDoc = record.getBaseNode().getDocument();
        try {
            String eids = record.getValue(record.getEIDField());
            if (eids != null) {
                this.recordEID = Long.parseLong(eids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getBaseRecordID() {
        return this.baserecord;
    }

    @Override
    public RecordInterface getBaseRecord(MatchSchemaInterface schema) throws Exception {
        try {
            RecordInterface ret = RecordInterface.build(schema).assignNode(new Node(this.baseRecordDoc));
            ret.load();
            return ret;
        }
        catch (IdentizaException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setBaseRecord(RecordInterface record) {
        this.baserecord = record.getBaseNode().getId();
        this.baserecordkey = record.getPkey();
        this.baserecordTableName = record.getTableName();
        this.baseRecordDoc = record.getBaseNode().getDocument();
        try {
            String eids = record.getValue(record.getEIDField());
            if (eids != null) {
                this.baserecordEID = Long.parseLong(eids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public IRule getRule() {
        return this.rule;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getActionText() {
        if (this.actionText != null && this.actionText.length() > 0) {
            return this.actionText;
        }
        return "Link";
    }

    @Override
    public void setActionText(String actionText) {
        this.actionText = actionText;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getBaseRecordTableName() {
        return this.baserecordTableName;
    }

    @Override
    public String getRecordTableName() {
        return this.recordTableName;
    }

    @Override
    public String getBaseRecordKey() {
        return this.baserecordkey;
    }

    @Override
    public String getRecordKey() {
        return this.recordkey;
    }

    @Override
    public String getAcceptance() {
        if (this.rule != null && this.score >= this.rule.getLowScore()) {
            if (this.rule == null && this.score == 100.0) {
                return "Auto-Match";
            }
            if (this.score >= this.rule.getHighScore()) {
                return "Auto-Match";
            }
            if (this.score >= this.rule.getLowScore()) {
                return "User-Review";
            }
        }
        return "Reject";
    }

    @Override
    public String getBaserecordsystem() {
        return this.baserecordsystem;
    }

    @Override
    public void setBaserecordsystem(String baserecordsystem) {
        this.baserecordsystem = baserecordsystem;
    }

    @Override
    public String getRecordsystem() {
        return this.recordsystem;
    }

    @Override
    public void setRecordsystem(String recordsystem) {
        this.recordsystem = recordsystem;
    }

    @Override
    public Date getWhen() {
        return this.when;
    }

    @Override
    public void setWhen(Date when) {
        this.when = when;
    }

    @Override
    public long getBaseRecordEID() {
        return this.baserecordEID;
    }

    @Override
    public long getRecordEID() {
        return this.recordEID;
    }

    @Override
    public JsonObject toJSON() {
        JsonParser parser = new JsonParser();
        JsonObject json = new JsonObject();
        json.addProperty("score", (Number)this.getScore());
        json.addProperty("acceptance", this.getAcceptance());
        json.addProperty("action", this.getAction());
        json.addProperty("actionText", this.getActionText());
        if (this.rule != null) {
            json.add("rule", (JsonElement)this.getRule().toJSON());
        }
        JsonArray array = new JsonArray();
        array.add(parser.parse(this.recordDoc.toJson()));
        array.add(parser.parse(this.baseRecordDoc.toJson()));
        json.add("records", (JsonElement)array);
        return json;
    }

    @Override
    public Document toDocument() {
        Document json = new Document();
        json.append("score", this.getScore());
        json.append("acceptance", this.getAcceptance());
        json.append("action", this.getAction());
        json.append("actionText", this.getActionText());
        if (this.getRule() != null) {
            json.append("rule", this.getRule().toJSON());
        }
        return json;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getTaskId() {
        return this.taskID;
    }
}

