/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.entity.resolve.match.MatchRecord;
import com.entitystream.identiza.entity.resolve.match.MatchRuleInterface;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.RulePurpose;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MatchRule
implements Serializable,
MatchRuleInterface {
    private Logger logger = Logger.getLogger("com.identiza");
    private IRule rule;
    private Map<String, IPurpose> ps;
    private ArrayList<RulePurpose> rulePurposes;
    private Map<String, Boolean> isTableInternal;
    private Map<String, String> tablekeys;
    private Map<String, List<PurposeColumnMap>> ppurposeColumnMaps;
    private String schemaName;

    public MatchRule(ISchemaMeta schDoc, IRule rule) {
        this.rule = rule;
        this.ppurposeColumnMaps = new HashMap<String, List<PurposeColumnMap>>();
        this.ps = new HashMap<String, IPurpose>();
        this.schemaName = schDoc.getName();
        this.isTableInternal = new HashMap<String, Boolean>();
        this.tablekeys = new HashMap<String, String>();
        for (ITable base : schDoc.getTables()) {
            this.isTableInternal.put(base.getTableName(), !base.isTarget());
            this.tablekeys.put(base.getTableName(), base.getKeyField());
        }
        if (rule == null) {
            this.logger.severe("Rule is not valid, I cant create the match service for it");
        } else {
            this.rulePurposes = rule.getRulePurpose();
            for (RulePurpose rp : this.rulePurposes) {
                this.logger.fine("Running " + rp.getPurposeName());
                String basePurpose = rp.getPurposeName();
                IPurpose purpose = schDoc.getPurpose(basePurpose);
                this.ps.put(basePurpose, purpose);
                for (PurposeColumn pc : purpose.getPurposeColumns()) {
                    for (ITable t : schDoc.getTables()) {
                        List<PurposeColumnMap> map1 = schDoc.getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), t.getTableName());
                        this.ppurposeColumnMaps.put(basePurpose + ":" + pc.getColumn() + ":" + t.getTableName(), map1);
                    }
                }
            }
        }
    }

    private boolean canRun(String base, String comparitor) {
        Boolean ruleCanRun = false;
        if (!this.isTableInternal.get(base).booleanValue() || !this.isTableInternal.get(comparitor).booleanValue()) {
            if (!this.isTableInternal.get(base).booleanValue() && !this.isTableInternal.get(comparitor).booleanValue()) {
                if (!base.equals(comparitor)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        ruleCanRun = !this.rule.isMatchSameSystem() ? (base.equalsIgnoreCase(comparitor) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(true);
        return ruleCanRun;
    }

    @Override
    public boolean canRun(RecordInterface base, RecordInterface comparitor) {
        return this.canRun(base.getTableName(), comparitor.getTableName());
    }

    @Override
    public boolean canRun(Document base, Document comparitor) {
        return this.canRun(base.getString("Table"), comparitor.getString("Table"));
    }

    @Override
    public MatchRecord score(Document base, Document comparitor, boolean forSearch, boolean asContent, boolean matchScoring) {
        long starttime = System.currentTimeMillis();
        double hiScore = -1.0;
        MatchRecord hiScoreMr = null;
        if (this.rule.isActive()) {
            double score = 0.0;
            double weightsum = 0.0;
            boolean match = true;
            for (RulePurpose rp : this.rulePurposes) {
                IPurpose p = this.ps.get(rp.getPurposeName());
                if (p == null) continue;
                try {
                    double nextscore = this.calculateScore(p, base, comparitor, forSearch, asContent, matchScoring);
                    if (forSearch && nextscore == 0.0) {
                        nextscore = -1.0;
                    }
                    if (nextscore == -1.0 && (!rp.isMandatory() || forSearch) && (!rp.isMandatory() || !forSearch || !matchScoring)) continue;
                    double _acceptweight = 1.0;
                    double _rejectweight = 1.0;
                    if (rp.isNegate()) {
                        nextscore = 100.0 - nextscore;
                    }
                    if (!forSearch || forSearch && matchScoring) {
                        _acceptweight = rp.getAcceptWeight();
                        _rejectweight = rp.getRejectWeight();
                    }
                    double _weight = 1.0;
                    score += Math.max(nextscore, 0.0) * _acceptweight;
                    _weight = nextscore > 0.0 ? _acceptweight : _rejectweight;
                    weightsum += _weight;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.logger.fine(weightsum + " match " + match + " score " + score);
            score = weightsum != 0.0 ? (score /= weightsum) : 0.0;
            if (score > hiScore) {
                this.logger.fine(score + "% Rule #" + this.rule.getHashKey() + " score between " + base.getString("_id") + " and " + comparitor.getString("_id") + " = " + score + " timed: " + (System.currentTimeMillis() - starttime));
                hiScore = score;
                String action = this.rule.getAction();
                String actionText = this.rule.getActionText();
                String table1 = base.getString("Table");
                String table2 = comparitor.getString("Table");
                if (!table1.equalsIgnoreCase(table2) && !action.equalsIgnoreCase("LINK")) {
                    action = "EID";
                }
                hiScoreMr = new MatchRecord(comparitor, base, score, this.rule, action, actionText, comparitor.getString(this.tablekeys.get(table2)), comparitor.getString(this.tablekeys.get(table1)));
            }
        }
        return hiScoreMr;
    }

    public static List<Standardized> deserialise(List<Document> bsonlist) {
        ArrayList<Standardized> ret = new ArrayList<Standardized>();
        try {
            for (Document d : bsonlist) {
                Standardized std = StandardizedSerialized.fromDocument(d);
                ret.add(std);
            }
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    private List<Standardized> getStandardised(Document baseNode, String purposeColumnName) throws Exception {
        List<Standardized> standardsarray = null;
        try {
            List stdvals;
            Document stds;
            if (baseNode != null && (stds = baseNode.getAsDocument("standardized")) != null && (stdvals = (List)stds.get(purposeColumnName)) != null) {
                standardsarray = MatchRule.deserialise(stdvals);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return standardsarray;
    }

    private double calculateScore(IPurpose p, Document basein, Document comparitorin, boolean forSearch, boolean asContent, boolean matchScoring) throws Exception {
        double bestscore = -1.0;
        double weightsum = 0.0;
        List<PurposeColumn> pcs = p.getPurposeColumns();
        if (pcs.size() > 0) {
            double totalscore = 0.0;
            int numcols = 0;
            for (PurposeColumn pc : pcs) {
                MatchProcInterface proc = pc.createMatchProc();
                List<Standardized> baseStdList = this.getStandardised(basein, pc.getColumn());
                List<Standardized> compStdList = this.getStandardised(comparitorin, pc.getColumn());
                if (baseStdList != null && compStdList != null) {
                    for (Standardized baseStd : baseStdList) {
                        for (Standardized compStd : compStdList) {
                            double score;
                            if (baseStd.getComparitorWords().length <= 0 || compStd.getComparitorWords().length <= 0 || !((score = proc.calculateComparisonScore(baseStd, compStd, forSearch, asContent)) > bestscore)) continue;
                            bestscore = score;
                        }
                    }
                }
                totalscore += bestscore;
                ++numcols;
            }
            bestscore = numcols > 0 ? totalscore / (double)numcols : 0.0;
            Logger.getLogger("com.identiza").fine(p.getPurposeName() + " score: " + bestscore);
        } else {
            Logger.getLogger("com.identiza").fine(p.getPurposeName() + " was ignored");
        }
        return bestscore;
    }
}

