/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.entity.resolve.match.MatchIndexInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRecord;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRuleInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.monster.db.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface MatchSchemaInterface {
    public ITable getTable(String var1);

    public MatchTableInterface getMatchTable(String var1) throws Exception;

    public Collection<IPurpose> getPurposes();

    public IPurpose getPurpose(String var1, String var2);

    public ISchemaMeta getSchDoc();

    public List<String> getTableNames(String var1);

    public String getProjectName();

    public String getGroupName();

    public int getThreads();

    public int getCommitSize();

    public boolean equals(String var1, String var2);

    public IDBContainer getDb() throws Exception;

    public String getNodeName();

    public ArrayList<MatchIndexInterface> getMatchIndexes();

    public void setSchDoc(ISchemaMeta var1);

    public MatchRuleInterface getMatchRule(String var1, int var2);

    public void clearRules();

    public static Map<String, MatchRecordInterface> matchScore(String key, RecordInterface comparitor, RecordInterface base, boolean forSearch, boolean asContent, boolean matchScoring) throws Exception {
        long stime = System.currentTimeMillis();
        HashMap<String, MatchRecordInterface> results = new HashMap<String, MatchRecordInterface>();
        String endKey = key.substring(key.lastIndexOf(":") + 1);
        boolean foundOnKey = false;
        MatchRecordInterface match = null;
        if (forSearch) {
            if (base.getPkey() != null && base.getPkey().equalsIgnoreCase(endKey)) {
                match = new MatchRecord(comparitor, null, 100.0, null, "Primary Key Match", "");
                foundOnKey = true;
            }
            if (base.getValue("EID") != null && base.getValue("EID").equalsIgnoreCase(comparitor.getValue("EID"))) {
                match = new MatchRecord(comparitor, null, 100.0, null, "Primary Key Match", "");
                foundOnKey = true;
            }
            for (Document xref : comparitor.getXref()) {
                if (!xref.getString(comparitor.getKeyField()).equalsIgnoreCase(endKey) && !xref.getString("EID").equalsIgnoreCase(base.getValue("EID"))) continue;
                foundOnKey = true;
                match = new MatchRecord(comparitor, null, 100.0, null, "XREF Match", "");
                break;
            }
            if (asContent) {
                foundOnKey = true;
                match = new MatchRecord(comparitor, null, 100.0, null, "TAG Match", "");
            }
        }
        if (!foundOnKey) {
            match = base.calculateScore(comparitor, forSearch, true, asContent, matchScoring);
            if (comparitor.isHistory() && match != null && match.getScore() < 100.0) {
                int count = 0;
                for (RecordInterface comparitorHist : comparitor.getHistoryRecords()) {
                    MatchRecordInterface match2 = base.calculateScore(comparitorHist, forSearch, true, asContent, matchScoring);
                    if (match2 != null && match2.getScore() > match.getScore()) {
                        match = match2;
                    }
                    if (++count <= 5) continue;
                    break;
                }
            }
        }
        if (match != null) {
            double _width = -1.0;
            if (!forSearch) {
                _width = match.getRule().getLowScore();
            }
            if (match.getScore() >= _width && match.getScore() >= 0.0) {
                results.put(match.getRecordTableName() + ":" + match.getRecordKey(), match);
            }
        }
        return results;
    }

    public void addMessages(String var1, String var2, String var3, String var4, boolean var5);

    public MatchRecordInterface calculateScore(RecordInterface var1, RecordInterface var2, boolean var3, boolean var4, boolean var5, boolean var6) throws Exception;

    public RecordInterface standardise(RecordInterface var1);

    public void setDb(IDBContainer var1);

    public void setThreads(int var1);

    public void setCommitSize(int var1);

    public void setNodeName(String var1);
}

