/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.entity.resolve.match.MatchIndex;
import com.entitystream.identiza.entity.resolve.match.MatchIndexInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRecord;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRule;
import com.entitystream.identiza.entity.resolve.match.MatchRuleInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTable;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.RulePurpose;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.monster.db.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ejb.Lock;
import javax.ejb.LockType;

public class MatchSchemaSimpleImpl
implements MatchSchemaInterface {
    private String nodeName = null;
    private ArrayList<MatchIndexInterface> matchIndexes;
    private String projectName;
    private Logger logger = Logger.getLogger("com.entitystream.identiza");
    List<IRule> rules = new ArrayList<IRule>();
    HashMap<String, IPurpose> ps = new HashMap();
    private ISchemaMeta schMeta;
    private IDBContainer db;
    private ConcurrentHashMap<String, MatchRule> cacheRules = new ConcurrentHashMap();
    private String groupName;
    private int threads;
    private int commitSize;

    public static MatchSchemaInterface build(ISchemaMeta meta) throws Exception {
        MatchSchemaSimpleImpl schema = new MatchSchemaSimpleImpl(meta);
        return schema;
    }

    private MatchSchemaSimpleImpl(ISchemaMeta meta) throws Exception {
        String schemaName = meta.getName();
        this.schMeta = meta;
        this.projectName = schemaName;
        this.logger.fine("Starting " + schemaName);
        this.create();
    }

    public MatchSchemaSimpleImpl(String schemaName, String projectName, String groupName) throws Exception {
        this.projectName = projectName;
        this.logger.fine("Starting " + schemaName + ":" + projectName);
        this.create();
    }

    private void create() {
        ISchemaMeta schDoc = this.getSchDoc();
        if (!this.projectName.equalsIgnoreCase("INTERNAL")) {
            if (schDoc != null) {
                this.logger.fine("Started Project : " + this.projectName);
                this.rules = this.getSchDoc().getRules(null);
                List<IPurpose> _ps = this.getSchDoc().getPurposes();
                for (IPurpose purpose : _ps) {
                    this.ps.put(purpose.getPurposeName(), purpose);
                }
                this.matchIndexes = new ArrayList();
                List<IIndex> temp = this.getSchDoc().getIndexes();
                if (temp.size() > 0) {
                    for (IIndex index : temp) {
                        MatchIndex matI = new MatchIndex(index, this);
                        if (matI.getDomainName() == null) continue;
                        this.matchIndexes.add(matI);
                        this.logger.fine("Recalled index " + matI.getDomainName() + "/" + matI.getInstance() + " with " + matI.getMatchProcs().size() + " procs : " + matI.getMatchProcs().toString());
                    }
                }
            } else {
                this.logger.severe("Not Started " + this.projectName);
            }
        }
    }

    @Override
    public MatchRecordInterface calculateScore(RecordInterface base, RecordInterface comparitor, boolean forSearch, boolean googleSearch, boolean asContent, boolean matchScoring) throws Exception {
        MatchRecord result = null;
        for (int i = 0; i < this.rules.size(); ++i) {
            IRule rule = this.rules.get(new Integer(i));
            MatchRuleInterface mr = this.getMatchRule(rule.getHashKey(), rule.getOrder());
            if (!forSearch && !mr.canRun(base, comparitor)) continue;
            MatchRecord resultnew = mr.score(base.getBaseNode().getDocument(), comparitor.getBaseNode().getDocument(), forSearch, asContent, matchScoring);
            if (result == null || resultnew.getScore() > result.getScore()) {
                result = resultnew;
            }
            if (result.getScore() >= rule.getHighScore() && !forSearch) break;
        }
        return result;
    }

    @Override
    public ITable getTable(String tableName) {
        return this.schMeta.getTable(tableName);
    }

    @Override
    public MatchTableInterface getMatchTable(String name) throws Exception {
        if (name != null) {
            name = name.trim();
        }
        MatchTable tab = new MatchTable();
        ITable mtable = this.getSchDoc().getTable(name);
        if (mtable != null) {
            tab.initialise(mtable, (MatchSchemaInterface)this);
            return tab;
        }
        return null;
    }

    @Override
    public Collection<IPurpose> getPurposes() {
        return this.getSchDoc().getPurposes();
    }

    @Override
    public IPurpose getPurpose(String purposeName, String groupName) {
        return this.getSchDoc().getPurpose(purposeName);
    }

    @Override
    public ISchemaMeta getSchDoc() {
        return this.schMeta;
    }

    @Override
    public List<String> getTableNames(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (ITable t : this.getSchDoc().getTables()) {
            list.add(t.getTableName());
        }
        return list;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public int getThreads() {
        return 0;
    }

    @Override
    public int getCommitSize() {
        return 0;
    }

    @Override
    public void setThreads(int t) {
        this.threads = t;
    }

    @Override
    public void setCommitSize(int cs) {
        this.commitSize = cs;
    }

    @Override
    public boolean equals(String projectName2, String groupName2) {
        return this.projectName.equalsIgnoreCase(projectName2) && this.groupName.equalsIgnoreCase(groupName2);
    }

    @Override
    public ArrayList<MatchIndexInterface> getMatchIndexes() {
        return this.matchIndexes;
    }

    @Override
    public void setSchDoc(ISchemaMeta schDoc) {
        this.schMeta = schDoc;
    }

    public String updateRule(Document doc) {
        try {
            RuleFactory.invalidate();
            return this.getDb().updateRule(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "[]";
        }
    }

    public String findRule(String rulePurpose, String query) {
        try {
            return Document.stringify(this.getDb().findRule(rulePurpose, query));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "[]";
        }
    }

    public List<Document> getMessages(Date since) {
        try {
            return this.getDb().getMessages(since);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Document>();
        }
    }

    @Override
    @Lock(value=LockType.READ)
    public MatchRuleInterface getMatchRule(String hashKey, int index) {
        MatchRule rule = this.cacheRules.get(hashKey);
        if (rule == null) {
            rule = new MatchRule(this.getSchDoc(), this.rules.get(index));
            this.cacheRules.put(hashKey, rule);
        }
        return rule;
    }

    @Override
    @Lock(value=LockType.READ)
    public void clearRules() {
        this.logger.info("Match Rules are cleared");
        this.cacheRules.clear();
    }

    @Override
    public void addMessages(String jobID, String action, String taskTitle, String messageText, boolean status) {
        try {
            Document d = action.indexOf("{") > -1 ? Document.parse(action) : new Document("action", action);
            d.append("ROWID", jobID).append("status", status).append("lastUpdated", new Date()).append("title", taskTitle).append("content", messageText);
            this.getDb().addMessage(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setDb(IDBContainer db) {
        this.db = db;
    }

    @Override
    public IDBContainer getDb() throws Exception {
        return this.db;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public RecordInterface standardise(RecordInterface RecordInterface2) {
        for (int i = 0; i < this.rules.size(); ++i) {
            IRule rule = this.rules.get(new Integer(i));
            if (rule == null) {
                this.logger.severe("Rule " + i + " is not valid or the rules are not contiguous for this table and starting at 1");
                continue;
            }
            if (!rule.isActive()) continue;
            ArrayList<RulePurpose> rulePurposes = rule.getRulePurpose();
            for (RulePurpose rp : rulePurposes) {
                String purposeName = rp.getPurposeName();
                try {
                    RecordInterface2 = this.getSchDoc().getPurpose(purposeName).standardize(RecordInterface2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return RecordInterface2;
    }
}

