/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.match;

import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchIndexInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.Result;
import com.entitystream.monster.db.Document;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class MatchTable
implements MatchTableInterface,
Serializable {
    private static final long serialVersionUID = -1033487478846380426L;
    private String tableName;
    private List<IRule> rules = null;
    private ConcurrentHashMap<String, Object> defaultVals = null;
    private static Logger logger = Logger.getLogger("com.entitystream.identiza");
    private MatchSchemaInterface matchSchema;
    private ITable table;
    public String REF_RELATED_BY_VERB = null;
    private boolean isHistory = false;
    private String keyField;
    private List<String> labelFields;
    private List<String> tags;
    private transient ExecutorService threadPool;
    private ObjectOutputStream matchStream;
    private int matchFileSize;
    private ObjectOutputStream putStream;
    private int putFileSize;
    private HashSet<String> sequenceCols;
    private String iconField;
    private String EIDField;
    private String systemField;
    private String sensitivityField;
    private boolean isInternal;
    private String lastUpdatedCol;
    private Collection<MatchTableInterface> targetTables;

    @Override
    public boolean isHistory() {
        return this.isHistory;
    }

    @Override
    public void initialise(ITable table, MatchSchemaInterface msc) throws Exception {
        this.matchSchema = msc;
        this.tableName = table.getTableName();
        this.table = table;
        if (table == null) {
            return;
        }
        this.isHistory = table.isHistory();
        this.tags = table.getTags();
        this.isInternal = table.isInternal();
        this.lastUpdatedCol = table.getLastUpdatedCol();
        this.defaultVals = new ConcurrentHashMap();
        for (ITableColumn iTableColumn : table.getColumns()) {
            if (iTableColumn.getDefaultValue() == null || iTableColumn.getDefaultValue().equalsIgnoreCase("NULL")) continue;
            this.defaultVals.put(iTableColumn.getColName(), iTableColumn.getDefaultValue());
        }
        this.sequenceCols = new HashSet();
        for (ITableColumn iTableColumn : table.getColumns()) {
            if (!iTableColumn.isSequence() && !iTableColumn.getColName().equalsIgnoreCase(this.getEIDField())) continue;
            this.sequenceCols.add(iTableColumn.getColName());
        }
        this.rules = msc.getSchDoc().getRules(this.tableName);
    }

    @Override
    public void initialise(String tablename, MatchSchemaInterface msc) throws Exception {
        this.matchSchema = msc;
        this.tableName = tablename;
        this.table = msc.getTable(tablename);
        if (this.table == null) {
            return;
        }
        this.isHistory = this.table.isHistory();
        this.tags = this.table.getTags();
        this.isInternal = this.table.isInternal();
        this.lastUpdatedCol = this.table.getLastUpdatedCol();
        this.defaultVals = new ConcurrentHashMap();
        for (ITableColumn iTableColumn : this.table.getColumns()) {
            if (iTableColumn.getDefaultValue() == null || iTableColumn.getDefaultValue().equalsIgnoreCase("NULL")) continue;
            this.defaultVals.put(iTableColumn.getColName(), iTableColumn.getDefaultValue());
        }
        this.sequenceCols = new HashSet();
        for (ITableColumn iTableColumn : this.table.getColumns()) {
            if (!iTableColumn.isSequence() && !iTableColumn.getColName().equalsIgnoreCase(this.getEIDField())) continue;
            this.sequenceCols.add(iTableColumn.getColName());
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public Collection<MatchTableInterface> getTargetTables() throws Exception {
        this.targetTables = null;
        if (this.targetTables == null) {
            this.targetTables = new HashSet<MatchTableInterface>();
            if (!this.getMetaTable().isTarget()) {
                for (String tableName : this.matchSchema.getTableNames("")) {
                    if (tableName.equalsIgnoreCase(this.tableName)) continue;
                    MatchTableInterface mt = this.matchSchema.getMatchTable(tableName);
                    ITable t = this.matchSchema.getTable(tableName);
                    if (!t.isTarget()) continue;
                    for (IPurpose pt : this.getPurposesForTable()) {
                        for (IPurpose pot : mt.getPurposesForTable()) {
                            if (!pt.getPurposeName().equalsIgnoreCase(pot.getPurposeName())) continue;
                            block3: for (PurposeColumn potc : pot.getPurposeColumns()) {
                                for (PurposeColumnMap potcm : this.matchSchema.getSchDoc().getPurposeColumnMaps(potc)) {
                                    if (!potcm.getTableName().equalsIgnoreCase(tableName) || t.getColumn(potcm.getTableColumn()).getLabelPos() <= 0) continue;
                                    this.targetTables.add(mt);
                                    continue block3;
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.targetTables;
    }

    @Override
    public RecordInterface putRecord(RecordInterface rec, boolean keyChanged, boolean updateMergeCount, String username) throws Exception {
        rec = rec.save(keyChanged, username);
        for (MatchTableInterface mt : this.getTargetTables()) {
            RecordInterface newRecord = mt.newRecord(rec.getPkey());
            newRecord.setValue("Table", mt.getTableName());
            newRecord.setValue(mt.getKeyField(), rec.getPkey());
            newRecord.setValue(newRecord.getEIDField(), rec.getValues().get(rec.getEIDField()));
            newRecord.applyInheritanceFrom(rec);
            String label = newRecord.display();
            if (label == null || label.length() <= 0) continue;
            newRecord = newRecord.save(true, username);
        }
        return rec;
    }

    @Override
    public RecordInterface getRecord(String id) {
        try {
            Node rec = new Node(this.matchSchema.getDb(), id);
            String recTable = (String)rec.getProperty("Table");
            ITable _table = this.table;
            if (recTable != null && !recTable.equalsIgnoreCase(this.tableName)) {
                _table = this.matchSchema.getTable(recTable);
            }
            if (rec.hasProperty(_table.getKeyField())) {
                String pkey = (String)rec.getProperty(_table.getKeyField());
                RecordInterface res = Record.build(this.matchSchema).assignNode(new Node(this.getDB(), id));
                if (res.isValid()) {
                    return res;
                }
                return null;
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public RecordInterface getRecord(INode node) throws Exception {
        RecordInterface rec = Record.build(this.matchSchema).assignNode(node);
        rec.load();
        return rec;
    }

    @Override
    public Record getRecord(String table, String pkey) {
        try {
            if (pkey.indexOf(":") > 1) {
                table = pkey.substring(0, pkey.lastIndexOf(":"));
                pkey = pkey.substring(pkey.lastIndexOf(":") + 1);
            }
            if (table == null) {
                table = this.tableName;
            }
            Record res = new Record(table, pkey, this.matchSchema);
            res.load();
            if (res.isValid()) {
                return res;
            }
            return null;
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            return null;
        }
    }

    @Override
    public String getKeyField() {
        if (this.table != null) {
            if (this.keyField == null) {
                this.keyField = this.table.getKeyField();
            }
            if (this.keyField == null && this.table.getColumns().size() > 0) {
                logger.severe("TABLE (" + this.table.getTableName() + ") MUST HAVE AT LEAST ONE PRIMARY KEY!");
                return this.table.getColumns().get(0).getColName();
            }
        }
        return this.keyField;
    }

    @Override
    public String getSystemField() {
        if (this.systemField == null && this.table != null) {
            this.systemField = this.table.getSystemField();
        }
        return this.systemField;
    }

    @Override
    public String getSensitivityField() {
        if (this.sensitivityField == null && this.table != null) {
            this.sensitivityField = this.table.getSensitivityField();
        }
        return this.sensitivityField;
    }

    @Override
    public List<IPurpose> getPurposesForTable() {
        return this.matchSchema.getSchDoc().getPurposes(this.getTableName());
    }

    @Override
    public IDBContainer getDB() throws Exception {
        if (this.matchSchema != null) {
            return this.matchSchema.getDb();
        }
        return null;
    }

    @Override
    public ArrayList<String> getFields() {
        HashMap<String, TableColumn> cols = new HashMap<String, TableColumn>();
        List<TableColumn> fqr = this.matchSchema.getSchDoc().getColumns(this.tableName);
        if (fqr.size() > 0) {
            for (TableColumn def : fqr) {
                cols.put(def.getColName(), def);
            }
        }
        ArrayList<String> list = new ArrayList<String>(cols.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public List<String> getLabelFields() {
        if (this.labelFields == null) {
            this.labelFields = this.table.findLabelFields();
        }
        return this.labelFields;
    }

    @Override
    public Record newRecord(String pkey) throws Exception {
        return new Record(this.tableName, pkey, this.matchSchema);
    }

    @Override
    public boolean hasRecord(String pkey) throws Exception {
        return this.matchSchema.getDb().getSingleNode(this.tableName, this.getKeyField(), pkey).getString("_id") != null;
    }

    @Override
    public ConcurrentHashMap<String, Object> getDefaults() {
        if (this.defaultVals == null && this.table != null) {
            this.defaultVals = this.table.createDefaults();
        }
        return this.defaultVals;
    }

    @Override
    public ITable getMetaTable() {
        return this.table;
    }

    @Override
    public List<IRule> getRules() {
        return this.rules;
    }

    @Override
    public void setRules(ArrayList<IRule> rules) {
        this.rules = rules;
    }

    @Override
    public ArrayList<Result> getMergedRecords() throws Exception {
        HashMap<String, String> matchC = new HashMap<String, String>();
        matchC.put("XREF", "*");
        Iterator<Document> it = this.getDB().search(matchC, this.tableName).iterator();
        ArrayList<Result> ret = new ArrayList<Result>();
        try {
            while (it.hasNext()) {
                Node node = new Node(this.getDB(), it.next());
                Result result = new Result(Record.build(this.matchSchema).assignNode(node));
                if (result.getPkey() == null) continue;
                ret.add(result);
            }
        }
        catch (Exception oe) {
            oe.printStackTrace();
        }
        return ret;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    private ExecutorService getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newFixedThreadPool(this.matchSchema.getThreads());
        }
        return this.threadPool;
    }

    @Override
    public Collection<String> getSequenceColumns() {
        return this.sequenceCols;
    }

    @Override
    public List<TableColumn> getColumns() {
        if (this.table != null) {
            return this.table.getColumns();
        }
        return new ArrayList<TableColumn>();
    }

    @Override
    public String getIconField() {
        if (this.iconField != null) {
            for (ITableColumn iTableColumn : this.table.getColumns()) {
                if (!iTableColumn.isIcon()) continue;
                this.iconField = iTableColumn.getColName();
                break;
            }
        }
        return this.iconField;
    }

    @Override
    public String getEIDField() {
        this.EIDField = "EID";
        return this.EIDField;
    }

    @Override
    public String getDefaultIcon() {
        if (this.table != null) {
            return this.table.getIcon();
        }
        return "Document.png";
    }

    @Override
    public ArrayList<ITableColumn> getIndexColumns() {
        ArrayList<ITableColumn> ret = new ArrayList<ITableColumn>();
        if (this.matchSchema != null) {
            for (MatchIndexInterface index : this.matchSchema.getMatchIndexes()) {
                for (String col : index.getMappedColumnNames(this.tableName)) {
                    TableColumn tc = this.table.getColumn(col);
                    if (tc == null || ret.contains(tc)) continue;
                    ret.add(tc);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public String getLastUpdatedCol() {
        return this.lastUpdatedCol;
    }
}

