/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.metadata;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.SchemaMeta;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class Purpose
implements Serializable,
IPurpose {
    private String purposeName;
    private List<PurposeColumn> purposeColumns = new ArrayList<PurposeColumn>();
    private int targetAlgo;
    private String purposeType;
    private String schemaName;
    private transient ISchemaMeta schDoc;

    @Override
    public ISchemaMeta getSchDoc() {
        return this.schDoc;
    }

    public Purpose() {
    }

    public Purpose(String schemaName, String purposeName, List<PurposeColumn> purposeColumns) {
        this.purposeName = purposeName;
        this.schemaName = schemaName;
        this.purposeColumns = purposeColumns;
    }

    @Override
    public double calculateScore(RecordInterface basein, RecordInterface comparitorin, boolean forSearch, boolean asContent, boolean matchScoring) throws Exception {
        double bestscore = -1.0;
        double weightsum = 0.0;
        if (this.purposeColumns.size() > 0) {
            double totalscore = 0.0;
            int numcols = 0;
            for (PurposeColumn pc : this.purposeColumns) {
                List<PurposeColumnMap> map1 = this.getSchDoc().getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), basein.getTableName());
                List<PurposeColumnMap> map2 = this.getSchDoc().getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), comparitorin.getTableName());
                if (map1 != null && map2 != null && map1.size() > 0 && map2.size() > 0) {
                    MatchProcInterface proc = pc.createMatchProc();
                    List<Standardized> baseStdList = basein.getStandardised(pc.getColumn(), proc, map1, pc.popRuleSet().getRuleAnon());
                    List<Standardized> compStdList = comparitorin.getStandardised(pc.getColumn(), proc, map2, pc.popRuleSet().getRuleAnon());
                    for (Standardized baseStd : baseStdList) {
                        for (Standardized compStd : compStdList) {
                            double score;
                            if (baseStd.getComparitorWords().length <= 0 || compStd.getComparitorWords().length <= 0 || !((score = proc.calculateComparisonScore(baseStd, compStd, forSearch, asContent)) > bestscore)) continue;
                            bestscore = score;
                        }
                    }
                }
                totalscore += bestscore;
                ++numcols;
            }
            bestscore = numcols > 0 ? totalscore / (double)numcols : 0.0;
            Logger.getLogger("com.identiza").fine(this.purposeName + " score: " + bestscore);
        } else {
            Logger.getLogger("com.identiza").fine(this.purposeName + " was ignored");
        }
        return bestscore;
    }

    @Override
    public RecordInterface standardize(RecordInterface basein) throws Exception {
        Document std = (Document)basein.getBaseNode().getDocument().get("standardized");
        if (std == null) {
            std = new Document();
            basein.getBaseNode().getDocument().append("standardized", std);
        }
        if (this.purposeColumns.size() > 0) {
            for (PurposeColumn pc : this.purposeColumns) {
                List<PurposeColumnMap> map1 = this.getSchDoc().getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), basein.getTableName());
                if (map1 == null || map1.size() <= 0) continue;
                MatchProcInterface proc = pc.createMatchProc();
                List<Standardized> baseStdList = basein.getStandardised(pc.getColumn(), proc, map1, pc.popRuleSet().getRuleAnon());
                if (baseStdList.size() <= 0) continue;
                std.append(pc.getColumn(), INode.serialize(baseStdList));
            }
        } else {
            Logger.getLogger("com.identiza").fine(this.purposeName + " was ignored");
        }
        return basein;
    }

    @Override
    public String getPurposeName() {
        return this.purposeName;
    }

    @Override
    public void setPurposeName(String purposeName) {
        this.purposeName = purposeName;
    }

    @Override
    public void addPurposeColumn(PurposeColumn pc) {
        int pos = -1;
        for (int p = 0; p < this.purposeColumns.size(); ++p) {
            PurposeColumn _pc = this.purposeColumns.get(p);
            if (!_pc.getColumn().equalsIgnoreCase(pc.getColumn()) || !_pc.getPurposeName().equalsIgnoreCase(pc.getPurposeName())) continue;
            pos = p;
            break;
        }
        if (pos == -1) {
            this.purposeColumns.add(pc);
        } else {
            this.purposeColumns.set(pos, pc);
        }
    }

    @Override
    public List<PurposeColumn> getPurposeColumns() {
        return this.purposeColumns;
    }

    @Override
    public void setPurposeColumns(List<PurposeColumn> pc) {
        this.purposeColumns = pc;
    }

    @Override
    public int getTargetAlgo() {
        return this.targetAlgo;
    }

    @Override
    public void setTargetAlgo(int algo) {
        this.targetAlgo = algo;
    }

    @Override
    public String getPurposeType() {
        if (this.purposeType == null || this.purposeType.length() == 0) {
            this.purposeType = "None";
        }
        return this.purposeType;
    }

    @Override
    public void setPurposeType(String purposeType) {
        if (purposeType == null || purposeType.length() == 0) {
            purposeType = "None";
        }
        this.purposeType = purposeType;
    }

    @Override
    public void convertTargetAlgo(String algo) {
        if (algo == null || algo.equalsIgnoreCase("dont")) {
            this.targetAlgo = -1;
        } else if (algo.equalsIgnoreCase("latest")) {
            this.targetAlgo = 0;
        } else if (algo.equalsIgnoreCase("any")) {
            this.targetAlgo = 1;
        } else if (algo.equalsIgnoreCase("longest")) {
            this.targetAlgo = 2;
        }
    }

    @Override
    public Collection<String> getTableColumns(String tableName) {
        HashSet<String> ret = new HashSet<String>();
        for (PurposeColumnMap pcm : this.getSchDoc().getPurposeColumnMaps(this.purposeName, null, tableName)) {
            ret.add(pcm.getTableColumn());
        }
        return ret;
    }

    @Override
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void deletePurposeColumn(String purposeColumnName) {
        ArrayList<PurposeColumn> npc = new ArrayList<PurposeColumn>();
        for (PurposeColumn pc : this.purposeColumns) {
            if (pc.getColumn().equalsIgnoreCase(purposeColumnName)) continue;
            npc.add(pc);
        }
        this.purposeColumns = npc;
    }

    @Override
    public void setSchDoc(SchemaMeta schemaMeta) {
        this.schDoc = schemaMeta;
    }
}

