/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.metadata;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.identiza.wordlist.RuleSet;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public class PurposeColumn
implements Serializable {
    private String purposeName;
    private String column;
    private int gradientType;
    private RuleSet ruleSet;
    private String matchClass;
    private String challengeType;
    private MatchProcInterface purposeClass;
    private int minWidth;
    private int maxWidth;
    private boolean mandatory = true;
    private String ruleFunction;

    public String getPurposeName() {
        return this.purposeName;
    }

    public void setPurposeName(String name) {
        this.purposeName = name;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
        if (this.purposeClass != null) {
            this.purposeClass.setRuleFunction(this.ruleFunction);
        }
    }

    public String getMatchClass() {
        return this.matchClass;
    }

    public void setMatchClass(String classname) {
        if (classname == null || classname.equalsIgnoreCase("null")) {
            classname = "MatchString";
        }
        this.matchClass = classname;
        this.pushRuleSet(RuleFactory.getInstance(this.matchClass));
        try {
            this.purposeClass = this.getRealClass(classname);
            if (this.purposeClass != null) {
                this.purposeClass.setGradient(this.getGradientType());
                this.purposeClass.setRuleSet(this.ruleSet);
                this.purposeClass.init(this.ruleFunction);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private MatchProcInterface getRealClass(String origname) throws Exception {
        String name = origname;
        if (!origname.contains(".")) {
            name = "com.entitystream.identiza.entity.resolve.types." + name;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            Constructor<?> cons = clazz.getConstructor(String.class);
            MatchBase _purposeClass = (MatchBase)cons.newInstance(this.ruleFunction);
            return _purposeClass;
        }
        return null;
    }

    public int getGradientType() {
        return this.gradientType;
    }

    public void setGradientType(int g) {
        this.gradientType = g;
    }

    public MatchProcInterface createMatchProc() {
        if (this.purposeClass == null) {
            this.setMatchClass(this.getMatchClass());
        }
        return this.purposeClass;
    }

    public void setMinWidth(int width) {
        this.minWidth = width;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    public int getMaxWidth() {
        if (this.maxWidth > 0) {
            return this.maxWidth;
        }
        return 3;
    }

    public int getMinWidth() {
        if (this.minWidth > 0) {
            return this.minWidth;
        }
        return 1;
    }

    public void pushRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public RuleSet popRuleSet() {
        return this.ruleSet;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String getChallengeType() {
        return this.challengeType;
    }

    public void setChallengeType(String challengeType) {
        this.challengeType = challengeType;
    }

    public String getRuleFunction() {
        return this.ruleFunction;
    }

    public void setRuleFunction(String rf) {
        this.ruleFunction = rf;
    }
}

