/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.metadata;

import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.RulePurpose;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;

public class Rule
implements Serializable,
IRule {
    private int order;
    private String action;
    private double highScore;
    private double lowScore;
    private ArrayList<RulePurpose> rulePurpose;
    private String actionText;
    private boolean active;
    private int systemMatchType;
    private boolean canMatchSameSystem = true;

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getActionText() {
        return this.actionText;
    }

    @Override
    public void setActionText(String actionText) {
        this.actionText = actionText;
    }

    public Rule() {
        this.rulePurpose = new ArrayList();
    }

    public Rule(int order, String action, double lowScore, double highScore, String actionText, boolean active, String systemMatchType, boolean canMatchSameSystem) {
        this.order = order;
        this.action = action;
        this.highScore = highScore;
        this.lowScore = lowScore;
        this.actionText = actionText;
        this.active = active;
        this.convertSystemMatchType(systemMatchType);
        this.canMatchSameSystem = canMatchSameSystem;
        this.rulePurpose = new ArrayList();
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public ArrayList<RulePurpose> getRulePurpose() {
        return this.rulePurpose;
    }

    @Override
    public void setRulePurpose(ArrayList<RulePurpose> rulePurpose) {
        this.rulePurpose = rulePurpose;
    }

    @Override
    public double getHighScore() {
        return this.highScore;
    }

    @Override
    public double getLowScore() {
        return this.lowScore;
    }

    @Override
    public void setLowScore(Double double1) {
        this.lowScore = double1;
    }

    @Override
    public void setHighScore(Double double1) {
        this.highScore = double1;
    }

    @Override
    public int getSystemMatchType() {
        return this.systemMatchType;
    }

    @Override
    public void convertSystemMatchType(String systemMatchType) {
        this.systemMatchType = 0;
        if (systemMatchType != null && systemMatchType.length() > 0) {
            if (systemMatchType.equalsIgnoreCase("ALL")) {
                this.systemMatchType = 0;
            } else if (systemMatchType.equalsIgnoreCase("INTERNALTOINTERNAL")) {
                this.systemMatchType = 121;
            } else if (systemMatchType.equalsIgnoreCase("INTERNALTOEXTERNAL")) {
                this.systemMatchType = 122;
            }
            if (systemMatchType.equalsIgnoreCase("EXTERNALTOEXTERNAL")) {
                this.systemMatchType = 222;
            }
        }
    }

    @Override
    public void setSystemMatchType(int smt) {
        this.systemMatchType = smt;
    }

    @Override
    public boolean isMatchSameSystem() {
        return this.canMatchSameSystem;
    }

    @Override
    public void setMatchSameSystem(boolean b) {
        this.canMatchSameSystem = b;
    }

    @Override
    public String getHashKey() {
        StringBuilder ret = new StringBuilder();
        for (RulePurpose rp : this.rulePurpose) {
            ret.append(rp.getPurposeName() + rp.isMandatory() + ":");
        }
        return ret.toString();
    }

    @Override
    public JsonObject toJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("canMatchSameSystem", Boolean.valueOf(this.isMatchSameSystem()));
        json.addProperty("systemMatchType", (Number)this.getSystemMatchType());
        json.addProperty("lowScore", (Number)this.getLowScore());
        json.addProperty("highScore", (Number)this.getHighScore());
        json.addProperty("actionText", this.getActionText());
        return json;
    }
}

