/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.metadata;

import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.Index;
import com.entitystream.identiza.entity.resolve.metadata.Purpose;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.Rule;
import com.entitystream.identiza.entity.resolve.metadata.RulePurpose;
import com.entitystream.identiza.entity.resolve.metadata.Table;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinition;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface;
import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.monster.db.Document;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SchemaMeta
implements Serializable,
ISchemaMeta {
    int commitSize = 10000;
    Logger logger = Logger.getLogger("ISchemaMeta");
    private String DBStore;
    private String defaultDBAddress;
    private int cacheSize;
    private Integer threads;
    private String projectName;
    private boolean autoMatch = false;
    private Map<String, ITable> tables = new HashMap<String, ITable>();
    private Map<String, List<PurposeColumnMap>> pcms = new HashMap<String, List<PurposeColumnMap>>();
    Map<String, IPurpose> purposes = new HashMap<String, IPurpose>();
    Map<String, IIndex> indexes = new HashMap<String, IIndex>();
    List<IRule> rules = new ArrayList<IRule>();

    public static SchemaMeta createSchemaMeta(Document connection) {
        try {
            SchemaMeta sch = new SchemaMeta(connection);
            if (connection.containsKey("projectName")) {
                sch.projectName = connection.getString("ProjectName");
            }
            if (connection.containsKey("dbStore")) {
                sch.DBStore = connection.getString("dbStore");
            }
            if (connection.containsKey("commitSize")) {
                sch.commitSize = connection.getInteger("commitSize");
            }
            if (connection.containsKey("cacheSize")) {
                sch.cacheSize = connection.getInteger("cacheSize");
            }
            if (connection.containsKey("threads")) {
                sch.threads = connection.getInteger("threads");
            }
            if (connection.containsKey("defaultDBAddress")) {
                sch.defaultDBAddress = connection.getString("defaultDBAddress");
            }
            if (connection.containsKey("autoMatch")) {
                sch.autoMatch = connection.getBoolean("autoMatch", false);
            }
            sch.getTables();
            sch.getRules(null);
            sch.getPurposes();
            sch.getIndexes();
            return sch;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document toDocument() {
        Document doc = new Document();
        doc.append("ProjectName", this.projectName);
        doc.append("commitSize", this.commitSize);
        doc.append("dbStore", this.DBStore);
        doc.append("threads", this.threads);
        doc.append("cacheSize", this.cacheSize);
        doc.append("defaultDBAddress", this.defaultDBAddress);
        doc.append("Rules", this.getRules(null));
        doc.append("Purposes", this.getPurposesDocument());
        doc.append("Indexes", this.getIndexes());
        doc.append("Tables", this.getTablesDocument());
        doc.append("autoMatch", this.isAutoMatch());
        return doc;
    }

    @Override
    public boolean isAutoMatch() {
        return this.autoMatch;
    }

    @Override
    public void setAutoMatch(boolean autoM) {
        this.autoMatch = autoM;
    }

    public List<Document> getTablesDocument() {
        ArrayList<Document> ret = new ArrayList<Document>();
        for (ITable t : this.getTables()) {
            ret.add(t.toDocument());
        }
        return ret;
    }

    public List<Document> getPurposesDocument() {
        Gson gson = new Gson();
        ArrayList<Document> ret = new ArrayList<Document>();
        for (IPurpose p : this.purposes.values()) {
            Document pdoc = Document.parse(gson.toJson((Object)p, Purpose.class));
            pdoc.remove("purposeColumns");
            ArrayList<Document> myCols = new ArrayList<Document>();
            for (PurposeColumn pc : p.getPurposeColumns()) {
                Document pcdoc = Document.parse(gson.toJson((Object)pc, PurposeColumn.class));
                ArrayList<Document> myMaps = new ArrayList<Document>();
                pcdoc.append("purposeColumnMaps", myMaps);
                for (List<PurposeColumnMap> pcml : this.pcms.values()) {
                    for (PurposeColumnMap pcm : pcml) {
                        if (pcm.getPurposeColumn() == null || pcm.getPurposeName() == null || !pcm.getPurposeName().equalsIgnoreCase(p.getPurposeName()) || !pcm.getPurposeColumn().equalsIgnoreCase(pc.getColumn())) continue;
                        myMaps.add(Document.parse(gson.toJson((Object)pcm, PurposeColumnMap.class)));
                    }
                }
                myCols.add(pcdoc);
            }
            pdoc.append("purposeColumns", myCols);
            ret.add(pdoc);
        }
        return ret;
    }

    private SchemaMeta(Document connection) throws Exception {
        List tabs;
        this.commitSize = connection.getInteger("commitSize", 1000);
        this.threads = connection.getInteger("threads", 1);
        this.cacheSize = connection.getInteger("cacheSize", 10000);
        this.projectName = connection.getString("SchemaName");
        this.autoMatch = connection.getBoolean("autoMatch", false);
        if (connection.get("Tables") != null && connection.get("Tables") instanceof List && (tabs = (List)connection.get("Tables")) != null) {
            for (Document d : tabs) {
                Table table = (Table)Document.toObject(d, Table.class);
                table.init();
                this.tables.put(table.getTableName(), table);
                this.tables.put(table.getTableName(), table);
            }
        }
        if (connection.get("Rules") != null && connection.get("Rules") instanceof List) {
            List rules = (List)connection.get("Rules");
            for (Object o : rules) {
                Rule rule = null;
                rule = o instanceof Rule ? (Rule)o : (Rule)Document.toObject((Document)o, Rule.class);
                this.rules.add(rule);
            }
        }
        if (connection.get("Purposes") != null && connection.get("Purposes") instanceof List) {
            List purps = (List)connection.get("Purposes");
            for (Document p : purps) {
                Purpose purp = (Purpose)Document.toObject(p, Purpose.class);
                purp.setSchemaName(this.projectName);
                this.purposes.put(purp.getPurposeName(), purp);
            }
        }
        if (connection.get("Indexes") != null && connection.get("Indexes") instanceof List) {
            List indexes = (List)connection.get("Indexes");
            for (Object o : indexes) {
                if (o instanceof Document) {
                    Document i = (Document)o;
                    if (!i.containsKey("indexName")) continue;
                    Index index = (Index)Document.toObject(i, Index.class);
                    this.indexes.put(index.getIndexName(), index);
                    continue;
                }
                Index index = (Index)o;
                this.indexes.put(index.getIndexName(), index);
            }
        }
        if (connection.containsKey("Purposes") && connection.get("Purposes") instanceof List) {
            for (Document purpose : (List)connection.get("Purposes")) {
                for (Document purposeColumn : (List)purpose.get("purposeColumns")) {
                    String matchClass = purposeColumn.getString("matchClass");
                    if (purposeColumn.get("purposeColumnMaps") == null) continue;
                    for (Document purposeColumnMap : (List)purposeColumn.get("purposeColumnMaps")) {
                        PurposeColumnMap pcm = PurposeColumnMap.fromDocument(purposeColumnMap);
                        String key = pcm.getPurposeName() + ":" + pcm.getPurposeColumn() + ":" + pcm.getTableName();
                        if (!this.pcms.containsKey(key)) {
                            this.pcms.put(key, new ArrayList());
                        }
                        this.pcms.get(key).add(pcm);
                    }
                }
            }
        }
    }

    @Override
    public int getCommitSize() {
        return this.commitSize;
    }

    @Override
    public Collection<ITable> getTables() {
        return this.tables.values();
    }

    @Override
    public ITable getTable(String tablename) {
        if (this.tables.containsKey(tablename)) {
            return this.tables.get(tablename);
        }
        return null;
    }

    @Override
    public List<IPurpose> getPurposes() {
        ArrayList<IPurpose> ret = new ArrayList<IPurpose>();
        for (IPurpose p : this.purposes.values()) {
            p.setSchDoc(this);
            ret.add(p);
        }
        return ret;
    }

    @Override
    public List<IRule> getRules(String tableName) {
        if (tableName == null) {
            return this.rules;
        }
        ArrayList<IRule> ret = new ArrayList<IRule>();
        for (IRule r : this.rules) {
            for (RulePurpose rp : r.getRulePurpose()) {
                if (this.getPurposeColumns(rp.getPurposeName(), tableName) == null) continue;
                ret.add(r);
            }
        }
        return ret;
    }

    @Override
    public List<IIndex> getIndexes() {
        return new ArrayList<IIndex>(this.indexes.values());
    }

    @Override
    public String getDBStore() {
        return this.DBStore;
    }

    @Override
    public String getDefaultDBAddress() {
        return this.defaultDBAddress;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public List<TableColumn> getColumns(String tableName) {
        ITable t = this.getTable(tableName);
        if (t != null) {
            return t.getColumns();
        }
        return new ArrayList<TableColumn>();
    }

    @Override
    public void updatePurpose(IPurpose p) {
        if (!this.purposes.containsKey(p.getPurposeName())) {
            this.purposes.put(p.getPurposeName(), p);
        } else {
            IPurpose oldp = this.purposes.get(p.getPurposeName());
            for (PurposeColumn newpc : p.getPurposeColumns()) {
                boolean foundpc = false;
                for (PurposeColumn oldpc : oldp.getPurposeColumns()) {
                    if (!oldpc.getColumn().equalsIgnoreCase(newpc.getColumn())) continue;
                    foundpc = true;
                    for (PurposeColumnMap pcm : this.getPurposeColumnMaps(newpc)) {
                        boolean found = false;
                        if (pcm.getTableColumn() != null) {
                            for (PurposeColumnMap oldpcm : this.getPurposeColumnMaps(oldpc)) {
                                if (oldpcm.getTableColumn() == null || !oldpcm.getTableColumn().equalsIgnoreCase(pcm.getTableColumn()) || !oldpcm.getTableName().equalsIgnoreCase(pcm.getTableName())) continue;
                                found = true;
                            }
                        }
                        if (found) continue;
                        this.addPurposeColumnMap(pcm);
                    }
                }
                if (foundpc) continue;
                oldp.addPurposeColumn(newpc);
            }
        }
    }

    @Override
    public void addPurpose(IPurpose p) {
        this.purposes.put(p.getPurposeName(), p);
    }

    @Override
    public void addPurposeColumn(PurposeColumn pc) {
        if (this.purposes.get(pc.getPurposeName()) != null) {
            this.purposes.get(pc.getPurposeName()).addPurposeColumn(pc);
        }
    }

    @Override
    public void addTable(ITable table) {
        this.tables.put(table.getTableName(), table);
    }

    @Override
    public void addColumn(TableColumn column) {
        ITable table = this.getTable(column.getTableName());
        if (table != null) {
            table.addColumn(column);
            this.addTable(table);
        }
    }

    @Override
    public Document findConcepts(String concept) {
        Document ret = new Document();
        for (String pname : this.purposes.keySet()) {
            IPurpose p = this.purposes.get(pname);
            Document pcDoc = new Document();
            ret.append(p.getPurposeName(), pcDoc);
            for (PurposeColumn pc : p.getPurposeColumns()) {
                if (concept != null && !pc.getColumn().equalsIgnoreCase(concept)) continue;
                pcDoc.append(pc.getColumn(), pc.getMatchClass());
            }
        }
        return ret;
    }

    @Override
    public Document findConceptsForProcType(String procType) {
        Document ret = new Document();
        for (String pname : this.purposes.keySet()) {
            IPurpose p = this.purposes.get(pname);
            Document pcDoc = new Document();
            ret.append(p.getPurposeName(), pcDoc);
            for (PurposeColumn pc : p.getPurposeColumns()) {
                if (procType != null && !pc.getMatchClass().equalsIgnoreCase(procType)) continue;
                pcDoc.append(pc.getColumn(), pc.getMatchClass());
            }
        }
        return ret;
    }

    @Override
    public IPurpose getPurpose(String purposeName) {
        return this.purposes.get(purposeName);
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    @Override
    public TableColumn getColumn(String tablename, String columnName) {
        ITable table = this.getTable(tablename);
        if (table != null) {
            return table.getColumn(columnName);
        }
        return null;
    }

    @Override
    public void addIndex(IIndex index) {
        this.indexes.put(index.getIndexName(), index);
    }

    @Override
    public IIndex getIndex(String indexname) {
        return this.indexes.get(indexname);
    }

    @Override
    public void addRule(IRule rule) {
        if (this.rules.size() == 0) {
            this.getRules(null);
        }
        int foundpos = -1;
        for (int pos = 0; pos < this.rules.size(); ++pos) {
            IRule exrule = this.rules.get(pos);
            if (!exrule.getHashKey().equalsIgnoreCase(rule.getHashKey())) continue;
            foundpos = pos;
            break;
        }
        if (foundpos == -1) {
            this.rules.add(rule);
        } else {
            this.rules.set(foundpos, rule);
        }
    }

    @Override
    public Collection<MatchProcDefinitionInterface> getMatchProcs(String domainName, String instance, String groupName) {
        ArrayList<MatchProcDefinitionInterface> mpds = new ArrayList<MatchProcDefinitionInterface>();
        IIndex indexNode = this.getIndex(domainName);
        String purposeName = indexNode.getPurposeName();
        IPurpose purposeNode = this.getPurpose(purposeName);
        if (purposeNode != null) {
            for (PurposeColumn pc : purposeNode.getPurposeColumns()) {
                MatchProcDefinition mpd = new MatchProcDefinition();
                mpd.setPurposeName(purposeName);
                mpd.setClassName(pc.getMatchClass());
                mpd.setDomainName(domainName);
                mpd.setProcName(purposeName + "_" + pc.getColumn());
                mpd.setRuleSet(RuleFactory.getInstance(pc.getMatchClass()));
                mpd.setGroupName(groupName);
                mpd.setMinWidth(pc.getMinWidth());
                mpd.setMaxWidth(pc.getMaxWidth());
                mpd.setIsMandatory(pc.isMandatory());
                mpd.setInstance(instance);
                mpds.add(mpd);
            }
        }
        return mpds;
    }

    @Override
    public Map<String, Document> getMatchTypes() {
        HashMap<String, Document> retval = new HashMap<String, Document>();
        retval.put("MatchAddress", new Document("BaseClass", "MatchAddress").append("Description", "Address"));
        retval.put("MatchFormula", new Document("BaseClass", "MatchFormula").append("Description", "Formula"));
        retval.put("MatchAge", new Document("BaseClass", "MatchAge").append("Description", "Person Age"));
        retval.put("MatchAgeRange", new Document("BaseClass", "MatchAgeRange").append("Description", "Age Range"));
        retval.put("MatchBeatCode", new Document("BaseClass", "MatchBeatCode").append("Description", "UK Police Beat Code"));
        retval.put("MatchChinesePersonName", new Document("BaseClass", "MatchChinesePersonName").append("Description", "Chinese First Name"));
        retval.put("MatchCode", new Document("BaseClass", "MatchCode").append("Description", "Code"));
        retval.put("MatchCountry", new Document("BaseClass", "MatchCountry").append("Description", "Country"));
        retval.put("MatchColor", new Document("BaseClass", "MatchColor").append("Description", "Color"));
        retval.put("MatchCompanyName", new Document("BaseClass", "MatchCompanyName").append("Description", "Company Name"));
        retval.put("MatchEditDistanceDate", new Document("BaseClass", "MatchEditDistanceDate").append("Description", "Fuzzy Date"));
        retval.put("MatchEditDistanceString", new Document("BaseClass", "MatchEditDistanceString").append("Description", "Fuzzy String"));
        retval.put("MatchEmail", new Document("BaseClass", "MatchEmail").append("Description", "Email Address"));
        retval.put("MatchEndAddress", new Document("BaseClass", "MatchEndAddress").append("Description", "End Address"));
        retval.put("MatchHeight", new Document("BaseClass", "MatchHeight").append("Description", "Height"));
        retval.put("MatchPersonName", new Document("BaseClass", "MatchPersonName").append("Description", "Person Name"));
        retval.put("MatchPersonNameSyllables", new Document("BaseClass", "MatchPersonNameSyllables").append("Description", "Person Name Using Syllable Coding"));
        retval.put("MatchPhonetic", new Document("BaseClass", "MatchPhonetic").append("Description", "Phonetic String"));
        retval.put("MatchPostCode", new Document("BaseClass", "MatchPostCode").append("Description", "Postal Code"));
        retval.put("MatchSortedEditDistanceString", new Document("BaseClass", "MatchSortedEditDistanceString").append("Description", "Sorted Fuzzy String"));
        retval.put("MatchString", new Document("BaseClass", "MatchString").append("Description", "Simple String"));
        retval.put("MatchText", new Document("BaseClass", "MatchText").append("Description", "Text"));
        retval.put("MatchColumn", new Document("BaseClass", "MatchColumn").append("Description", "Column To Concept"));
        retval.put("MatchTicker", new Document("BaseClass", "MatchTicker").append("Description", "Stock Ticker"));
        return retval;
    }

    @Override
    public void addMatchTypes(Document mt) {
    }

    @Override
    public void clearPurposeColumnMaps(String purposeName) {
        HashMap<String, List<PurposeColumnMap>> newpcms = new HashMap<String, List<PurposeColumnMap>>();
        for (String key : this.pcms.keySet()) {
            if (key.startsWith(purposeName + ":")) continue;
            newpcms.put(key, this.pcms.get(key));
        }
        this.pcms = newpcms;
    }

    @Override
    public void addPurposeColumnMap(PurposeColumnMap pcm) {
        String key = pcm.getPurposeName() + ":" + pcm.getPurposeColumn() + ":" + pcm.getTableName();
        if (!this.pcms.containsKey(key)) {
            this.pcms.put(key, new ArrayList());
        }
        this.pcms.get(key).add(pcm);
    }

    @Override
    public List<PurposeColumnMap> getPurposeColumnMaps(PurposeColumn pc) {
        return this.getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), null);
    }

    @Override
    public List<PurposeColumnMap> getPurposeColumnMaps(String purposeName, String purposeColumnName, String tableName) {
        ArrayList<PurposeColumnMap> purposeColumnMaps;
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (this.pcms.containsKey(purposeName + ":" + purposeColumnName + ":" + tableName)) {
                                return this.pcms.get(purposeName + ":" + purposeColumnName + ":" + tableName);
                            }
                            purposeColumnMaps = new ArrayList<PurposeColumnMap>();
                            if (purposeColumnName != null || purposeName != null || tableName != null) break block6;
                            for (String k : this.pcms.keySet()) {
                                purposeColumnMaps.addAll((Collection<PurposeColumnMap>)this.pcms.get(k));
                            }
                            break block7;
                        }
                        if (purposeColumnName != null || purposeName != null) break block8;
                        for (String k : this.pcms.keySet()) {
                            if (!k.endsWith(":" + tableName)) continue;
                            purposeColumnMaps.addAll((Collection<PurposeColumnMap>)this.pcms.get(k));
                        }
                        break block7;
                    }
                    if (purposeColumnName != null || tableName != null) break block9;
                    for (String k : this.pcms.keySet()) {
                        if (!k.startsWith(purposeName + ":")) continue;
                        purposeColumnMaps.addAll((Collection<PurposeColumnMap>)this.pcms.get(k));
                    }
                    break block7;
                }
                if (tableName != null) break block10;
                for (String k : this.pcms.keySet()) {
                    if (!k.startsWith(purposeName + ":" + purposeColumnName)) continue;
                    purposeColumnMaps.addAll((Collection<PurposeColumnMap>)this.pcms.get(k));
                }
                break block7;
            }
            if (purposeColumnName != null) break block7;
            for (String k : this.pcms.keySet()) {
                if (!k.startsWith(purposeName + ":") || !k.endsWith(":" + tableName)) continue;
                purposeColumnMaps.addAll((Collection<PurposeColumnMap>)this.pcms.get(k));
            }
        }
        return purposeColumnMaps;
    }

    @Override
    public List<PurposeColumn> getPurposeColumns(String purposeName, String tableName) {
        List<PurposeColumn> ret = new ArrayList<PurposeColumn>();
        if (tableName == null) {
            IPurpose p = this.getPurpose(purposeName);
            if (p != null) {
                ret = p.getPurposeColumns();
            }
        } else {
            IPurpose p = this.getPurpose(purposeName);
            if (p != null) {
                for (PurposeColumn pc : p.getPurposeColumns()) {
                    if (this.getPurposeColumnMaps(pc.getPurposeName(), pc.getColumn(), tableName).size() <= 0) continue;
                    ret.add(pc);
                }
            }
        }
        return ret;
    }

    @Override
    public void deleteColumn(ITableColumn col) {
        ITable table = this.getTable(col.getTableName());
        if (table != null) {
            table.removeColumn(col.getColName());
            this.addTable(table);
        }
    }

    @Override
    public String getName() {
        return this.projectName;
    }

    @Override
    public void deletePurpose(String id) {
        this.purposes.remove(id);
    }

    @Override
    public void deletePurposeColumn(String purposeName, String purposeColumnName) {
        IPurpose p = this.purposes.get(purposeName);
        if (p != null) {
            p.deletePurposeColumn(purposeColumnName);
        }
    }

    @Override
    public void deleteTable(String tablename) {
        this.tables.remove(tablename);
    }

    @Override
    public void clearRules() {
        this.rules.clear();
    }

    @Override
    public void clearIndexes() {
        this.indexes.clear();
    }

    @Override
    public List<PurposeColumnMap> getPurposeColumnMaps(String optPurposeName) {
        PurposeColumn pc = new PurposeColumn();
        pc.setPurposeName(optPurposeName);
        return this.getPurposeColumnMaps(pc);
    }

    @Override
    public List<String> getTableColumnMaps(String purposeName, String tableName) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PurposeColumnMap pcm : this.getPurposeColumnMaps(purposeName, null, tableName)) {
            ret.add(pcm.getTableColumn());
        }
        return ret;
    }

    @Override
    public List<IPurpose> getPurposes(String tableName) {
        ArrayList<IPurpose> ret = new ArrayList<IPurpose>();
        for (PurposeColumnMap pcm : this.getTablePurposeColumnMaps(tableName)) {
            ret.add(this.getPurpose(pcm.getPurposeName()));
        }
        return ret;
    }

    @Override
    public List<PurposeColumnMap> getTablePurposeColumnMaps(String tableName) {
        return this.getPurposeColumnMaps(null, null, tableName);
    }

    @Override
    public List<ITable> getTargetTables() {
        ArrayList<ITable> targetTables = new ArrayList<ITable>();
        for (ITable t : this.getTables()) {
            if (!t.isTarget()) continue;
            targetTables.add(t);
        }
        return targetTables;
    }

    @Override
    public void deletePurposeColumnMap(PurposeColumnMap pcm) {
        String key = pcm.getPurposeName() + ":" + pcm.getPurposeColumn() + ":" + pcm.getTableName();
        if (!this.pcms.containsKey(key)) {
            this.pcms.remove(key);
        }
    }

    @Override
    public void deleteMatchRule(long order) {
        IRule found = null;
        for (IRule r : this.rules) {
            if ((long)r.getOrder() != order) continue;
            found = r;
        }
        if (found != null) {
            this.rules.remove(found);
        }
    }

    @Override
    public void deleteIndex(String def) {
        this.indexes.remove(def);
    }
}

