/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.metadata;

import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Table
implements Serializable,
ITable {
    private ConcurrentHashMap<String, Object> defaultVals;
    private boolean useInPaths;
    private String tableName;
    private int lowThreshold;
    private int keyThreshold;
    private double maxProbs = 0.05;
    private boolean document = false;
    private boolean history;
    private String _keyField;
    private Map<String, TableColumn> columnMap;
    private List<TableColumn> columns;
    private List<String> tags;
    private String icon;
    private List<String> labelFields;
    private String systemField;
    private String sensitivityField;
    private boolean internal;
    public String dateFormat;
    private String displayName;
    private String lastUpdatedCol;
    private String baseType = "NODES";
    private String schemaName;
    private String transmitFormat;
    private String transmitDestination;
    private boolean target;
    private String targetAuthToken;
    private boolean relTable = false;
    private boolean restrictedRelationships = true;
    private String _eidField;

    public Table() {
        this.defaultVals = new ConcurrentHashMap();
        this.columns = new ArrayList<TableColumn>();
        this.columnMap = new HashMap<String, TableColumn>();
    }

    public Table(String name, ISchemaMeta schemaDoc) {
        this.setTableName(name);
        this.columns = new ArrayList<TableColumn>();
        this.columnMap = new HashMap<String, TableColumn>();
        this.init();
    }

    @Override
    public void init() {
        for (TableColumn tableColumn : this.columns) {
            tableColumn.setTableName(this.getTableName());
            this.columnMap.put(tableColumn.getColName(), tableColumn);
        }
        this.defaultVals = new ConcurrentHashMap();
        for (ITableColumn iTableColumn : this.getColumns()) {
            if (iTableColumn.getDefaultValue() == null || iTableColumn.getDefaultValue().equalsIgnoreCase("NULL")) continue;
            this.defaultVals.put(iTableColumn.getColName(), iTableColumn.getDefaultValue());
        }
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public TableColumn getColumn(String colname) {
        return this.columnMap.get(colname.replaceAll("\\[[0-9]*\\]", ""));
    }

    @Override
    public void setMaxProb(double val) {
        this.maxProbs = val;
    }

    @Override
    public String getSensitivityField() {
        if (this.sensitivityField == null) {
            List<TableColumn> cols = this.getColumns();
            for (TableColumn col : cols) {
                if (!col.isSensitivityField()) continue;
                this.sensitivityField = col.getColName();
                break;
            }
        }
        return this.sensitivityField;
    }

    @Override
    public String getSystemField() {
        if (this.systemField == null) {
            List<TableColumn> cols = this.getColumns();
            for (TableColumn col : cols) {
                if (!col.isSystem()) continue;
                this.systemField = col.getColName();
                break;
            }
            if (this.systemField == null) {
                this.systemField = "systemName";
            }
        }
        return this.systemField;
    }

    @Override
    public String getKeyField() {
        if (this._keyField == null) {
            List<TableColumn> cols = this.getColumns();
            for (TableColumn col : cols) {
                if (!col.isPrimaryKey()) continue;
                this._keyField = col.getColName();
                break;
            }
        }
        return this._keyField;
    }

    @Override
    public List<TableColumn> getColumns() {
        if (this.columnMap.size() == 0 && this.columns.size() != 0) {
            return this.columns;
        }
        return new ArrayList<TableColumn>(this.columnMap.values());
    }

    @Override
    public void setColumns(List<TableColumn> cols) {
        for (ITableColumn iTableColumn : cols) {
            iTableColumn.setTableName(this.tableName);
            this.columnMap.put(iTableColumn.getColName(), (TableColumn)iTableColumn);
        }
    }

    @Override
    public void setCandThreshold(int lowThreshold) {
        this.lowThreshold = lowThreshold;
    }

    @Override
    public int getCandThreshold() {
        return this.lowThreshold;
    }

    @Override
    public void setUseInPaths(boolean boolean1) {
        this.useInPaths = boolean1;
    }

    @Override
    public Boolean getUseInPaths() {
        return this.useInPaths;
    }

    @Override
    public int getKeyThreshold() {
        return this.keyThreshold;
    }

    @Override
    public void setKeyThreshold(int val) {
        this.keyThreshold = val;
    }

    @Override
    public double getMaxProb() {
        return this.maxProbs;
    }

    @Override
    public boolean isDocument() {
        return this.document;
    }

    @Override
    public void setDocument(boolean isDoc) {
        this.document = isDoc;
    }

    @Override
    public boolean isHistory() {
        return this.history;
    }

    @Override
    public void setHistory(boolean ish) {
        this.history = ish;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tagsin) {
        this.tags = tagsin;
    }

    @Override
    public void setIcon(String iconName) {
        this.icon = iconName;
    }

    @Override
    public String getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return "";
    }

    @Override
    public ConcurrentHashMap<String, Object> createDefaults() {
        return this.defaultVals;
    }

    @Override
    public List<String> findLabelFields() {
        if (this.labelFields == null) {
            HashMap<Integer, String> cols = new HashMap<Integer, String>();
            List<TableColumn> fqr = this.getColumns();
            if (fqr.size() > 0) {
                for (TableColumn def : fqr) {
                    if (def.getLabelPos() <= 0) continue;
                    cols.put(def.getLabelPos(), def.getColName());
                }
            }
            ArrayList<String> res = new ArrayList<String>();
            for (int i = 1; i <= cols.size(); ++i) {
                res.add(i - 1, (String)cols.get(new Integer(i)));
            }
            this.labelFields = res;
        }
        return this.labelFields;
    }

    @Override
    public void addColumn(TableColumn col) {
        this.columnMap.put(col.getColName(), col);
    }

    @Override
    public void removeColumn(String name) {
        this.columnMap.remove(name);
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public void setInternal(boolean intFlag) {
        this.internal = intFlag;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public DateTimeFormatter createDateFormatter() {
        if (this.dateFormat == null || this.dateFormat.equalsIgnoreCase("NULL")) {
            return DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault());
        }
        return DateTimeFormatter.ofPattern(this.dateFormat).withZone(ZoneId.systemDefault());
    }

    @Override
    public void setDateFormat(String dateFormat) {
        if (dateFormat != null && !dateFormat.equalsIgnoreCase("NULL")) {
            this.dateFormat = dateFormat;
        }
    }

    @Override
    public void setTableDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getTableDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.tableName;
    }

    @Override
    public String getLastUpdatedCol() {
        if (this.lastUpdatedCol == null) {
            List<TableColumn> cols = this.getColumns();
            for (ITableColumn iTableColumn : cols) {
                if (!iTableColumn.isLastUpdated()) continue;
                this.lastUpdatedCol = iTableColumn.getColName();
                break;
            }
        }
        return this.lastUpdatedCol;
    }

    @Override
    public String getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    @Override
    public ArrayList<String> getSequenceFields() {
        ArrayList<String> seqf = new ArrayList<String>();
        for (ITableColumn iTableColumn : this.columns) {
            if (!iTableColumn.isSequence()) continue;
            seqf.add(iTableColumn.getColName());
        }
        return seqf;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getTransmitFormat() {
        return this.transmitFormat;
    }

    @Override
    public void setTransmitFormat(String tmf) {
        this.transmitFormat = tmf;
    }

    @Override
    public String getTransmitDestination() {
        return this.transmitDestination;
    }

    @Override
    public void setTransmitDestination(String td) {
        this.transmitDestination = td;
    }

    @Override
    public boolean isTarget() {
        return this.target;
    }

    @Override
    public void setTarget(boolean ist) {
        this.target = ist;
    }

    @Override
    public String getTargetAuthToken() {
        return this.targetAuthToken;
    }

    @Override
    public void setTargetAuthToken(String targetAuthToken) {
        this.targetAuthToken = targetAuthToken;
    }

    @Override
    public boolean isRelTable() {
        return this.relTable;
    }

    @Override
    public void setRelTable(boolean tf) {
        this.relTable = tf;
    }

    @Override
    public void setRestrictedRelationships(boolean set) {
        this.restrictedRelationships = set;
    }

    @Override
    public boolean getRestrictedRelationships() {
        return this.restrictedRelationships;
    }

    @Override
    public String getEIDField() {
        if (this._eidField == null) {
            List<TableColumn> cols = this.getColumns();
            for (TableColumn col : cols) {
                if (!col.isEID()) continue;
                this._eidField = col.getColName();
                break;
            }
        }
        return this._keyField;
    }

    @Override
    public Document toDocument() {
        Document ret = new Document();
        ret.append("columns", this.columns);
        ret.append("internal", this.internal);
        ret.append("document", this.document);
        ret.append("baseType", this.baseType);
        ret.append("schemaName", "p6");
        ret.append("target", this.target);
        ret.append("relTable", this.relTable);
        ret.append("restrictedRelationships", this.restrictedRelationships);
        ret.append("defaultVals", this.defaultVals);
        ret.append("useInPaths", this.useInPaths);
        ret.append("tableName", this.tableName);
        ret.append("lowThreshold", this.lowThreshold);
        ret.append("keyThreshold", this.keyThreshold);
        ret.append("maxProbs", this.maxProbs);
        ret.append("history", this.history);
        return ret;
    }

    @Override
    public List<String> getLabelFields() {
        return this.labelFields;
    }
}

