/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.processing;

public class GradientGenerator {
    public static final int MIDDLELOW = 1;
    public static final int ADDRESS = 2;
    public static final int LEFTHIGH = 3;
    public static final int RIGHTHIGH = 4;
    public static int MIDDLEHIGH = 5;
    public static int LINEAR = 0;

    public static double[] generate(int minwords, int maxwords, double startw, double endw, double resw, int gradient) {
        return GradientGenerator.generate(minwords, maxwords, startw, endw, resw, gradient, false);
    }

    public static int getGradient(String type) {
        if (type == null) {
            return LINEAR;
        }
        if (type.equalsIgnoreCase("LINEAR")) {
            return LINEAR;
        }
        if (type.equalsIgnoreCase("ADDRESS")) {
            return 2;
        }
        if (type.equalsIgnoreCase("LEFTHIGH")) {
            return 3;
        }
        if (type.equalsIgnoreCase("RIGHTHIGH")) {
            return 4;
        }
        if (type.equalsIgnoreCase("MIDDLEHIGH")) {
            return MIDDLEHIGH;
        }
        if (type.equalsIgnoreCase("MIDDLELOW")) {
            return 1;
        }
        return LINEAR;
    }

    public static double[] generate(int minwords, int maxwords, double startw, double endw, double resw, int gradient, boolean asContent) {
        double[] weights;
        block13: {
            int i;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            int i2;
                            block12: {
                                int i3;
                                weights = new double[maxwords];
                                if (minwords == 0) {
                                    return null;
                                }
                                minwords = (minwords + maxwords) / 2;
                                if (gradient != LINEAR) break block12;
                                double incw = (startw - endw) / (double)minwords;
                                if (incw == 0.0) {
                                    incw = startw / (double)minwords;
                                }
                                for (i3 = 0; i3 < minwords; ++i3) {
                                    weights[i3] = incw;
                                }
                                incw = maxwords - minwords > 0 ? resw / (double)(maxwords - minwords) : resw;
                                for (i3 = minwords; i3 < maxwords; ++i3) {
                                    weights[i3] = incw;
                                }
                                break block13;
                            }
                            if (gradient != 3) break block14;
                            double incw = (startw - endw) / (double)(minwords - 1);
                            double lastweight = 0.0;
                            for (i2 = 0; i2 < minwords; ++i2) {
                                weights[i2] = startw;
                                lastweight = startw;
                                startw -= incw;
                            }
                            incw = (resw - lastweight) / (double)(maxwords - minwords);
                            for (i2 = minwords; i2 < maxwords; ++i2) {
                                weights[i2] = lastweight;
                                lastweight += incw;
                            }
                            break block13;
                        }
                        if (gradient != 4) break block15;
                        double incw = (startw - endw) / (double)(minwords - 1);
                        for (int i4 = 0; i4 < minwords; ++i4) {
                            weights[i4] = startw;
                            startw -= incw;
                        }
                        break block13;
                    }
                    if (gradient != MIDDLEHIGH) break block16;
                    double middle1 = Math.floor((minwords - 1) / 2);
                    int middle2 = (int)middle1;
                    if (middle1 < (double)(minwords - 1) / 2.0) {
                        ++middle2;
                    }
                    for (int i5 = 0; i5 <= maxwords; ++i5) {
                        weights[i5] = endw;
                    }
                    weights[middle2] = startw;
                    break block13;
                }
                if (gradient != 1) break block17;
                for (int i6 = 1; i6 < maxwords; ++i6) {
                    weights[i6] = endw;
                }
                weights[0] = startw;
                weights[maxwords - 1] = startw;
                break block13;
            }
            if (gradient != 2) break block13;
            int numendtokens = Math.min(minwords, 5);
            startw /= (double)numendtokens;
            resw /= (double)(maxwords - numendtokens);
            for (i = 0; i < numendtokens; ++i) {
                weights[i] = startw;
            }
            for (i = numendtokens; i < maxwords; ++i) {
                weights[i] = resw;
            }
        }
        return weights;
    }

    public static void main(String[] args) {
        double[] weights = GradientGenerator.generate(4, 5, 2.0, 1.0, 0.2, 0);
        double t = 0.0;
        for (double grad : weights) {
            System.out.println(grad);
            t += grad;
        }
        System.out.println(t);
    }

    public static double sum(double[] gradients) {
        double sum = 0.0;
        if (gradients == null) {
            System.out.println("Gradients are null");
        }
        for (double i : gradients) {
            sum += i;
        }
        return sum;
    }
}

