/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.storage;

import com.entitystream.identiza.entity.resolve.storage.Context;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ContextMap
implements Serializable {
    private HashSet<Context> items;
    private String name;
    private boolean internal;
    private ArrayList<Map<String, Object>> values;
    SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z '('z')'");

    public ContextMap(String relname, boolean internal, Map<String, Object> values) {
        this.name = relname;
        this.internal = internal;
        this.items = new HashSet();
        this.values = new ArrayList();
        this.values.add(values);
    }

    public ContextMap(Map<String, Object> values) {
        this.values = new ArrayList();
        this.values.add(values);
    }

    public ContextMap(String relname, ArrayList<Map<String, Object>> strContextMap) {
        this.values = strContextMap;
        this.name = relname;
    }

    public String serialize() {
        String res = this.name + ":::" + this.internal + "::";
        for (Context ctx : this.items) {
            res = res + ctx.toString() + "\n";
        }
        return res;
    }

    public String valuesToJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.values != null) {
            for (int index = 0; index < this.values.size(); ++index) {
                sb.append("{\"index\":\"" + index + "\"");
                for (String key : this.values.get(index).keySet()) {
                    if (this.values.get(index).get(key) instanceof String) {
                        sb.append(", \"" + key + "\": \"" + this.values.get(index).get(key).toString().replaceAll("\n", "") + "\"");
                        continue;
                    }
                    if (this.values.get(index).get(key) instanceof Date) {
                        sb.append(", \"" + key + "\": \"" + this.sdf.format((Date)this.values.get(index).get(key)) + "\"");
                        continue;
                    }
                    if (!(this.values.get(index).get(key) instanceof Number) && !(this.values.get(index).get(key) instanceof Boolean)) continue;
                    sb.append(", \"" + key + "\": " + this.values.get(index).get(key) + "");
                }
                sb.append("}");
                if (index >= this.values.size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean addItems(Context item) {
        boolean found = false;
        for (Context context : this.items) {
            if (!context.equals(item)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.items.add(item);
        }
        return !found;
    }

    public HashSet<Context> getItems() {
        return this.items;
    }

    public void setRelName(String name) {
        this.name = name;
    }

    public String getRelName() {
        return this.name;
    }

    public boolean hasItems() {
        return this.items != null;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public static HashMap<String, Object> createNewMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public void pushProperties(Map<String, Object> props) {
        if (!this.values.contains(props)) {
            this.values.add(props);
        }
    }

    public Map<String, Object> getProperties(int index) {
        return this.values.get(index);
    }
}

