/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.storage;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.IRelationship;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchCriteria;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.storage.ContextMap;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.RuleFactory;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class Record
implements Serializable,
Comparable,
RecordInterface {
    private String pkey = null;
    private String keyField = null;
    private String tableName;
    private String systemName = null;
    private List<String> labelFields;
    private Logger logger = Logger.getLogger("com.identiza");
    private boolean isNew = true;
    private HashMap<String, List<Standardized>> standards = new HashMap();
    private String project;
    private String groupName;
    private String nodeName = "";
    private List<TableColumn> cols;
    private volatile boolean valid = true;
    private volatile boolean persisted = false;
    private volatile INode baseNode = null;
    private volatile boolean loaded = false;
    private MatchSchemaInterface matchSchema;
    private MatchTableInterface matchTable = null;
    private String systemField = null;
    private int linkcount = 0;
    private int taskcount = -1;
    private ArrayList<Object> hist = null;
    private String updatedBy = "";
    private String sensitivityValue = null;
    private String sensitivityField = null;
    private boolean isInternal;
    private String EIDField = "EID";

    @Override
    public INode getBaseNode() {
        if (this.baseNode == null) {
            this.load();
        }
        return this.baseNode;
    }

    @Override
    public String getPkey() {
        return this.pkey;
    }

    @Override
    public void neverLoad() throws Exception {
        this.loaded = true;
        this.valid = true;
        if (this.baseNode == null) {
            this.baseNode = new Node(new Document());
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setPkey(String pkey) {
        try {
            this.pkey = pkey;
            if (this.pkey == null || this.pkey.length() == 0) {
                this.pkey = "" + this.getSchema().getDb().getNextId(this.getKeyField());
            }
            if (this.getBaseNode() != null) {
                this.getBaseNode().setProperty(this.getKeyField(), this.pkey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public RecordInterface assignNode(INode n) throws Exception {
        this.baseNode = n;
        if (n.hasProperty("Table")) {
            this.tableName = (String)n.getProperty("Table");
        }
        if (this.tableName != null && this.tableName.length() > 0) {
            ITable table = this.matchSchema.getTable(this.tableName);
            if (table != null) {
                this.isInternal = table.isInternal();
                this.EIDField = "EID";
                if (n.hasProperty(table.getKeyField())) {
                    this.pkey = n.getProperty(table.getKeyField()) instanceof String ? (String)n.getProperty(table.getKeyField()) : n.getProperty(table.getKeyField()).toString();
                }
                this.cols = table.getColumns();
                this.keyField = table.getKeyField();
                this.labelFields = table.findLabelFields();
                this.systemField = table.getSystemField();
            }
            this.loaded = false;
            this.valid = true;
        } else {
            this.valid = false;
        }
        if (n.hasProperty(this.getKeyField())) {
            this.pkey = (String)n.getProperty(this.getKeyField());
        }
        if (this.pkey == null || this.pkey.length() == 0) {
            this.pkey = n.getId();
        }
        if (this.getBaseNode() != null && this.getKeyField() != null && this.pkey != null) {
            this.getBaseNode().setProperty(this.getKeyField(), this.pkey);
        }
        this.loaded = true;
        return this;
    }

    @Override
    public RecordInterface assignTable(MatchTableInterface table) throws Exception {
        this.matchTable = table;
        if (table == null) {
            this.valid = false;
            return this;
        }
        this.cols = table.getColumns();
        this.isNew = true;
        this.isInternal = table.isInternal();
        this.EIDField = table.getEIDField();
        this.tableName = table.getTableName();
        if (this.tableName != null && this.tableName.length() > 0) {
            this.keyField = table.getKeyField();
            this.systemField = this.getMatchTable().getSystemField();
            this.labelFields = table.getLabelFields();
            this.loaded = false;
            this.valid = true;
        } else {
            this.valid = false;
        }
        this.neverLoad();
        return this;
    }

    @Override
    public String getKeyField() {
        return this.keyField;
    }

    public Record(MatchSchemaInterface matchSchema1) throws Exception {
        if (matchSchema1 != null) {
            this.nodeName = matchSchema1.getNodeName();
            this.groupName = matchSchema1.getGroupName();
            this.project = matchSchema1.getProjectName();
            this.matchSchema = matchSchema1;
        }
        this.neverLoad();
        this.valid = false;
    }

    private Record(MatchSchemaInterface matchSchema, MatchTableInterface table, Node node) throws Exception {
        if (matchSchema != null) {
            this.nodeName = matchSchema.getNodeName();
            this.groupName = matchSchema.getGroupName();
            this.project = matchSchema.getProjectName();
            this.matchSchema = matchSchema;
        }
        this.matchTable = table;
        this.cols = table.getColumns();
        this.baseNode = node;
        this.isNew = true;
        this.isInternal = table.isInternal();
        this.EIDField = table.getEIDField();
        this.tableName = table.getTableName();
        if (this.tableName != null && this.tableName.length() > 0) {
            if (node.hasProperty(table.getKeyField())) {
                this.pkey = (String)node.getProperty(table.getKeyField());
            }
            this.keyField = table.getKeyField();
            this.systemField = this.getMatchTable().getSystemField();
            this.labelFields = table.getLabelFields();
            this.loaded = false;
            this.valid = true;
        } else {
            this.valid = false;
        }
        if (this.pkey == null || this.pkey.length() == 0) {
            this.pkey = "" + this.getSchema().getDb().getNextId(this.getKeyField());
        }
        if (this.getBaseNode() != null) {
            this.getBaseNode().setProperty(this.getKeyField(), this.pkey);
        }
    }

    public Record(MatchSchemaInterface matchSchema, INode node) throws Exception {
        if (matchSchema != null) {
            this.nodeName = matchSchema.getNodeName();
            this.groupName = matchSchema.getGroupName();
            this.project = matchSchema.getProjectName();
            this.matchSchema = matchSchema;
        }
        this.baseNode = node;
        this.isNew = true;
        if (node.hasProperty("Table")) {
            this.tableName = (String)node.getProperty("Table");
        }
        if (this.tableName != null && this.tableName.length() > 0) {
            ITable table = matchSchema.getTable(this.tableName);
            if (table != null) {
                this.isInternal = table.isInternal();
                this.EIDField = "EID";
                if (node.hasProperty(table.getKeyField())) {
                    this.pkey = node.getProperty(table.getKeyField()) instanceof String ? (String)node.getProperty(table.getKeyField()) : node.getProperty(table.getKeyField()).toString();
                }
                this.cols = table.getColumns();
                this.keyField = table.getKeyField();
                this.labelFields = table.findLabelFields();
                this.systemField = table.getSystemField();
            }
            this.loaded = false;
            this.valid = true;
        } else {
            this.valid = false;
        }
        if (this.pkey == null || this.pkey.length() == 0) {
            this.pkey = "" + this.getSchema().getDb().getNextId(this.getKeyField());
        }
        if (this.getBaseNode() != null) {
            this.getBaseNode().setProperty(this.getKeyField(), this.pkey);
        }
    }

    private Record(MatchSchemaInterface matchSchema, MatchTableInterface mtable) throws Exception {
        this.nodeName = matchSchema.getNodeName();
        this.groupName = matchSchema.getGroupName();
        this.project = matchSchema.getProjectName();
        this.matchSchema = matchSchema;
        this.matchTable = mtable;
        this.isInternal = mtable.isInternal();
        this.EIDField = mtable.getEIDField();
        this.cols = mtable.getColumns();
        this.tableName = mtable.getTableName();
        this.labelFields = mtable.getLabelFields();
        this.keyField = mtable.getKeyField();
        this.persisted = false;
        this.isNew = true;
        this.loaded = true;
        this.valid = true;
        this.neverLoad();
    }

    private Record(Record original) {
        this.persisted = false;
        this.isNew = true;
        this.loaded = true;
        this.valid = true;
        try {
            this.neverLoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.EIDField = original.getEIDField();
        this.baseNode = original.baseNode;
        this.cols = original.cols;
        this.groupName = original.groupName;
        this.isNew = false;
        this.isInternal = original.isInternal;
        this.labelFields = original.labelFields;
        this.matchSchema = original.matchSchema;
        this.matchTable = original.matchTable;
        this.nodeName = original.nodeName;
        this.hist = null;
        this.pkey = original.pkey;
        this.project = original.project;
        this.standards = original.standards;
        this.systemField = original.systemField;
        this.systemName = original.systemName;
        this.tableName = original.tableName;
        this.updatedBy = original.updatedBy;
    }

    @Override
    public String getEIDField() {
        return this.EIDField;
    }

    public MatchTableInterface getMatchTable() {
        try {
            if (this.matchTable == null) {
                this.matchTable = this.getSchema().getMatchTable(this.tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.matchTable;
    }

    public Record(String tableName, String pkey, MatchSchemaInterface matchSchema) throws Exception {
        this.nodeName = matchSchema.getNodeName();
        this.groupName = matchSchema.getGroupName();
        this.project = matchSchema.getProjectName();
        this.matchSchema = matchSchema;
        this.tableName = tableName;
        this.persisted = false;
        this.isNew = true;
        if (this.getMatchTable() != null) {
            if (this.getMatchTable().getSystemField() != null) {
                this.systemField = this.getMatchTable().getSystemField();
            }
            this.EIDField = this.getMatchTable().getEIDField();
            this.cols = this.getMatchTable().getColumns();
            if (this.getMatchTable().getKeyField() != null) {
                this.labelFields = this.getMatchTable().getLabelFields();
                this.keyField = this.getMatchTable().getKeyField();
                this.isInternal = this.getMatchTable().isInternal();
            }
        }
        if (pkey == null || pkey.length() == 0) {
            pkey = "" + this.getSchema().getDb().getNextId(this.getKeyField());
        }
        this.pkey = pkey;
        if (this.getBaseNode() != null) {
            this.getBaseNode().setProperty(this.getKeyField(), pkey);
        }
        this.loaded = false;
    }

    public Record(MatchCriteria matchcrits, MatchSchemaInterface matchSchema) throws Exception {
        this.nodeName = matchSchema.getNodeName();
        this.groupName = matchSchema.getGroupName();
        this.project = matchSchema.getProjectName();
        this.matchSchema = matchSchema;
        this.systemField = this.getMatchTable().getSystemField();
        this.EIDField = this.getMatchTable().getEIDField();
        this.persisted = false;
        this.isNew = true;
        this.tableName = matchcrits.getTableName();
        if (this.tableName != null) {
            this.pkey = matchcrits.getValue(this.getMatchTable().getKeyField());
            this.isInternal = this.getMatchTable().isInternal();
            this.cols = this.getMatchTable().getColumns();
            this.labelFields = this.getMatchTable().getLabelFields();
            this.keyField = this.getMatchTable().getKeyField();
        }
        this.baseNode = new Node(this.getMatchTable().getMetaTable(), matchcrits.getValues());
        if (this.pkey == null || this.pkey.length() == 0) {
            this.pkey = "" + this.getSchema().getDb().getNextId(this.getKeyField());
        }
        if (this.getBaseNode() != null) {
            this.getBaseNode().setProperty(this.getKeyField(), this.pkey);
        }
        this.loaded = false;
    }

    public Record(ITable table, Map<Object, Object> newvals, MatchSchemaInterface schema) throws Exception {
        this.persisted = false;
        this.isNew = false;
        this.tableName = table.getTableName();
        this.keyField = table.getKeyField();
        this.isInternal = table.isInternal();
        this.systemField = this.getMatchTable().getSystemField();
        this.matchSchema = schema;
        this.cols = table.getColumns();
        this.EIDField = this.getMatchTable().getEIDField();
        this.baseNode = new Node(table, newvals);
        if (this.pkey == null || this.pkey.length() == 0) {
            this.pkey = "" + this.getSchema().getDb().getNextId(this.getKeyField());
        }
        if (this.getBaseNode() != null) {
            this.getBaseNode().setProperty(this.getKeyField(), this.pkey);
        }
        this.labelFields = table.findLabelFields();
        this.loaded = true;
    }

    @Override
    public void load() {
        if (!this.loaded) {
            try {
                if (this.valid) {
                    if (this.baseNode == null || this.baseNode.getId() == null) {
                        Document node = this.getSchema().getDb().getSingleNode(this.tableName, this.keyField, this.getPkey());
                        this.baseNode = new Node(this.getSchema().getDb(), node);
                    }
                    if (this.baseNode != null && this.baseNode.getId() != null) {
                        this.persisted = true;
                        this.isNew = false;
                        this.loaded = true;
                        this.hist = (ArrayList)this.getBaseNode().getProperty("history");
                        this.setValue("lastUpdated", Document.fromISO8601UTC(this.getBaseNode().getProperty("lastUpdated")));
                        this.setValue("action", (String)this.getBaseNode().getProperty("action"));
                        this.updatedBy = (String)this.getBaseNode().getProperty("updatedBy");
                        if (this.getBaseNode().getProperty(this.keyField) == null) {
                            this.getBaseNode().setProperty(this.keyField, this.pkey);
                        }
                        this.pkey = (String)this.getBaseNode().getProperty(this.keyField);
                        this.systemName = (String)this.getBaseNode().getProperty(this.systemField);
                        if (this.systemName == null) {
                            this.systemName = this.tableName;
                        }
                        this.baseNode.setDB(this.matchSchema.getDb());
                    } else {
                        this.persisted = false;
                        this.isNew = true;
                        this.loaded = true;
                    }
                }
            }
            catch (Exception e) {
                this.logger.severe("Could not load record : " + e.getMessage());
                e.printStackTrace();
                this.loaded = false;
            }
        }
    }

    @Override
    public ConcurrentHashMap<INode, ContextMap> getRelatedNodes(String reltype, String direction, Date when) throws Exception {
        ConcurrentHashMap<INode, ContextMap> res = new ConcurrentHashMap<INode, ContextMap>();
        this.load();
        if (this.baseNode != null) {
            Iterator<IRelationship> it = null;
            it = reltype != null && direction != null ? this.baseNode.getRelationships(reltype, direction, when) : (reltype != null ? this.baseNode.getRelationships(reltype, when) : this.baseNode.getRelationships(when));
            while (it.hasNext()) {
                INode otherNode;
                IRelationship rel = it.next();
                String relname = rel.getType();
                if (relname == null || (reltype == null || !reltype.equalsIgnoreCase("ANTI-MATCH")) && relname.equalsIgnoreCase("ANTI-MATCH")) continue;
                Document props = rel.getProperties();
                props.put("$id", rel.getId());
                ContextMap contextMap = null;
                if (props != null && props.containsKey("history")) {
                    ArrayList strContextMap = (ArrayList)props.get("history");
                    contextMap = new ContextMap(relname, strContextMap);
                } else {
                    contextMap = new ContextMap(props);
                    contextMap.setRelName(relname);
                }
                if ((otherNode = rel.getOtherNode(this.baseNode)) == null) continue;
                res.put(otherNode, contextMap);
            }
        }
        return res;
    }

    public HashMap<String, String> getRelatedRecords(String relTypeName, Date when) throws Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        Iterator<IRelationship> it = this.baseNode.getRelationships(relTypeName, when);
        while (it.hasNext()) {
            String keyfield;
            IRelationship rel = it.next();
            Map<String, Object> otherVals = rel.getOtherNode(this.baseNode).getPropertyValues();
            if (!otherVals.containsKey("Table") || otherVals.get(keyfield = this.getSchema().getTable(otherVals.get("Table").toString()).getKeyField()) == null) continue;
            String _pkey = otherVals.get(keyfield).toString();
            String relname = rel.getType();
            res.put(_pkey, relname);
        }
        return res;
    }

    public List<RecordInterface> getRelatedRecords(String relTypeName, String direction, Date when) throws Exception {
        ArrayList<RecordInterface> res = new ArrayList<RecordInterface>();
        Iterator<IRelationship> it = this.baseNode.getRelationships(relTypeName, direction, when);
        while (it.hasNext()) {
            IRelationship rel = it.next();
            INode otherNode = rel.getOtherNode(this.baseNode);
            res.add(new Record(this.getSchema(), otherNode));
        }
        return res;
    }

    private MatchSchemaInterface getSchema() throws Exception {
        return this.matchSchema;
    }

    @Override
    public ArrayList<String> getFieldNames() throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        if (this.cols != null) {
            for (ITableColumn iTableColumn : this.cols) {
                res.add(iTableColumn.getColName());
            }
        }
        return res;
    }

    @Override
    public void setValue(String colname, Object value) {
        try {
            if (colname != null && colname.equals("updatedBy")) {
                this.updatedBy = value.toString();
            }
            if (colname != null && value != null) {
                this.getBaseNode().setProperty(colname, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveNoIndexes(String username) throws Exception {
        String action = "updat";
        this.setLastUpdated(new Date());
        if (this.getLastUpdated() == null) {
            this.setLastUpdated(new Date());
        }
        if (this.getAction() == null) {
            this.setAction("NEW");
        }
        try {
            this.baseNode = new Node(this.getSchema().getDb(), this.getSchema().getDb().addInternalNode(this.keyField, this.getPkey(), this.getBaseNode().getDocument(), this.getTableName(), false, this.isHistory(), username));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.persisted = true;
        this.isNew = false;
        this.loaded = true;
    }

    @Override
    public RecordInterface save(boolean hasKeyChanged, String username) throws Exception {
        try {
            String action = "updat";
            StringBuilder error = new StringBuilder();
            for (ITableColumn iTableColumn : this.cols) {
                Object fallback;
                String lu = iTableColumn.getLookup();
                if (lu != null && lu.length() != 0) {
                    RuleSet rules = RuleFactory.getInstance(iTableColumn.getLookup());
                    StringBuilder valtolookup = new StringBuilder();
                    if (iTableColumn.getLookupColumns() != null) {
                        for (String column : iTableColumn.getLookupColumns().split(",")) {
                            valtolookup.append(this.getBaseNode().getProperty(column.trim()));
                            valtolookup.append(" ");
                        }
                    } else {
                        valtolookup.append(this.getBaseNode().getProperty(iTableColumn.getColName()));
                    }
                    String wordSearch = valtolookup.toString().trim();
                    WordObject word = rules.getRuleLookup().getWord(wordSearch);
                    String valueForward = wordSearch;
                    if (word != null && valueForward != null) {
                        valueForward = word.getParent();
                    }
                    if (valueForward != null && valueForward.trim().length() > 0) {
                        this.getBaseNode().setProperty(iTableColumn.getColName(), valueForward.trim());
                    }
                }
                if (iTableColumn.getLookupFallback() == null || this.getBaseNode().getProperty(iTableColumn.getColName()) != null || (fallback = this.getBaseNode().getProperty(iTableColumn.getLookupFallback())) == null) continue;
                this.getBaseNode().setProperty(iTableColumn.getColName(), fallback.toString());
            }
            this.setLastUpdated(new Date());
            if (this.getAction() == null) {
                this.setAction("CURRENT");
            }
            this.setUpdatedBy(username);
            this.getBaseNode().getProperty("lastUpdated");
            if (this.getBaseNode().getProperty(this.keyField) == null) {
                this.getBaseNode().setProperty(this.keyField, this.getPkey());
            }
            action = "add";
            String EIDField = this.getMatchTable().getEIDField();
            String string = this.getValue(EIDField);
            if (string == null) {
                long eidl = this.getSchema().getDb().getNextId(EIDField);
                this.getBaseNode().setProperty(EIDField, eidl);
                String string2 = "" + eidl;
            }
            this.baseNode = new Node(this.getSchema().getDb(), this.getSchema().getDb().addInternalNode(this.keyField, this.getPkey(), this.getBaseNode().getDocument(), this.getTableName(), hasKeyChanged, this.isHistory(), username));
            this.persisted = true;
            this.isNew = false;
            this.loaded = true;
            this.getSchema().addMessages("" + (this.tableName + this.pkey).hashCode(), "{image: \"fa fa-edit\", actionName: \"Edit\", action: \"doEditNode('" + this.tableName + ':' + this.pkey + "');\"}", this.tableName + " Updated", username + " recently updated " + this.display(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public void setAction(String action) throws Exception {
        this.getBaseNode().setProperty("action", action);
    }

    @Override
    public String getValue(String colname) throws Exception {
        if (!this.loaded) {
            this.load();
        }
        try {
            if (colname != null) {
                if (this.getBaseNode().getProperty(colname) != null) {
                    return Document.objectToString(this.getBaseNode().getProperty(colname));
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IdentizaException(e.getMessage());
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public Map<String, Object> toHashMap() throws Exception {
        if (!this.loaded) {
            this.load();
        }
        return this.getBaseNode().getPropertyValues();
    }

    @Override
    public String display() throws Exception {
        return Record.buildLabel(this.baseNode.getDocument(), this.labelFields);
    }

    public String displayAll() throws Exception {
        String val;
        String res = "";
        int l = -1;
        for (String label : this.labelFields) {
            val = Document.objectToString(this.getBaseNode().getProperty(label));
            if (val == null || val.equals("null") || val.length() <= 0) continue;
            res = res + val;
            if (++l >= this.labelFields.size() - 1) continue;
            res = res + ", ";
        }
        res = res + ":";
        for (String value : this.getMatchTable().getFields()) {
            if (!(this.getBaseNode().getProperty(value) instanceof String) || (val = (String)this.getBaseNode().getProperty(value)) == null || val.equals("null") || val.length() <= 0) continue;
            res = res + value + ":" + val + ',';
        }
        return res.substring(0, res.length() - 1).trim();
    }

    @Override
    public void setLabelFields(List<String> labelFields) {
        this.labelFields = labelFields;
    }

    @Override
    public List<String> getLabelFields() {
        return this.labelFields;
    }

    public void putRecord(boolean keychanged, String username) throws Exception {
        this.getSchema().getMatchTable(this.tableName).putRecord(this, keychanged, false, username);
    }

    @Override
    public void addRelatedRec(RecordInterface targetRec, String reasonVerb, Date dateOf, String actionThatCausedThis, String user) throws Exception {
        this.addRelatedRec(targetRec, reasonVerb, dateOf, new Document(), actionThatCausedThis, user);
    }

    @Override
    public void addRelatedRec(RecordInterface targetRec, String reasonVerb, Date dateOf, Document values, String actionThatCausedThis, String user) throws Exception {
        if (reasonVerb == null || reasonVerb.length() == 0) {
            reasonVerb = targetRec.getTableName().equalsIgnoreCase(this.getTableName()) ? "Link" : "External Link";
        }
        this.logger.fine("Relating " + this.display() + " to " + targetRec.display() + " with a verb " + reasonVerb);
        if (!targetRec.equals(this) && this.getBaseNode() != null) {
            Iterator<IRelationship> rels = this.getBaseNode().getRelationships(reasonVerb, "BOTH", null);
            boolean found = false;
            IRelationship rel = null;
            while (rels.hasNext()) {
                rel = rels.next();
                INode on = rel.getOtherNode(this.getBaseNode());
                if (on == null || on.getId() != targetRec.getBaseNode().getId()) continue;
                found = true;
                break;
            }
            if (!found) {
                rel = this.getBaseNode().createRelationshipTo(targetRec.getBaseNode(), reasonVerb, dateOf, values);
                boolean changed = false;
                if (this.getMatchTable().isInternal() && !targetRec.isInternal()) {
                    changed = this.applyInheritanceFrom(targetRec);
                    if (changed) {
                        this.saveNoIndexes(user);
                    }
                } else if (targetRec.isInternal() && !this.getMatchTable().isInternal() && (changed = targetRec.applyInheritanceFrom(this))) {
                    targetRec.saveNoIndexes(user);
                }
            } else {
                if (!values.containsKey("status")) {
                    values.put("status", "ACTIVE");
                }
                rel.setLastUpdate(new Date());
                rel.setProperties(values);
            }
        }
    }

    @Override
    public boolean applyInheritanceFrom(RecordInterface targetRec) {
        return Node.applyInheritanceFrom(this.getBaseNode(), targetRec.getBaseNode(), new HashSet<IPurpose>(this.getMatchTable().getPurposesForTable()), this.matchSchema.getSchDoc());
    }

    public boolean equals(RecordInterface that) {
        if (this != null && that != null && this.getBaseNode() != null && that.getBaseNode() != null) {
            return this.getBaseNode().getId() == that.getBaseNode().getId();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.baseNode.getDocument().toJson();
    }

    public boolean isRelatedTo(RecordInterface record) throws Exception {
        boolean found = false;
        Iterator<IRelationship> rels = this.getBaseNode().getRelationships(new Date());
        IRelationship rel = null;
        while (rels.hasNext()) {
            rel = rels.next();
            if (rel.getEndNode().getId() != record.getBaseNode().getId()) continue;
            found = true;
            break;
        }
        return found;
    }

    public boolean isRelatedTo(RecordInterface record, String reltype, Date when) throws Exception {
        boolean found = false;
        Iterator<IRelationship> rels = this.getBaseNode().getRelationships(reltype, "BOTH", new Date());
        IRelationship rel = null;
        while (rels.hasNext()) {
            rel = rels.next();
            if (rel.getEndNode().getId() != record.getBaseNode().getId()) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public IRelationship getRelatedTo(RecordInterface otherRec, String relTypeName, Date when) throws Exception {
        if (relTypeName != null) {
            Iterator<IRelationship> rels = this.getBaseNode().getRelationships(relTypeName, when);
            IRelationship rel = null;
            while (rels.hasNext()) {
                rel = rels.next();
                if (rel.getOtherNode(this.getBaseNode()).getId() != otherRec.getBaseNode().getId()) continue;
                return rel;
            }
        }
        return null;
    }

    @Override
    public boolean setValues(Document vals) {
        this.baseNode.setProperties(vals);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RecordInterface> getHistoryRecords() {
        ArrayList<RecordInterface> hrecs = new ArrayList<RecordInterface>();
        if (this.baseNode != null && this.hist != null) {
            ArrayList<Object> arrayList = this.hist;
            synchronized (arrayList) {
                try {
                    for (Object hrec : this.hist) {
                        Document histr = (Document)hrec;
                        if (histr.getString("_id") == null) continue;
                        Record rec = new Record(this.getSchema(), this.getMatchTable());
                        rec.setBaseNode(this.baseNode);
                        rec.setPkey(histr.get(this.keyField).toString());
                        rec.setValues(histr);
                        hrecs.add(rec);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(hrecs);
        return hrecs;
    }

    @Override
    public void addHistoryRecord(INode newValues, String action, String username) throws Exception {
        Document newDoc = new Document();
        newDoc.putAll((Map)newValues.getDocument());
        Document currentDoc = new Document();
        currentDoc.putAll((Map)this.baseNode.getDocument());
        currentDoc.remove("tokens");
        currentDoc.remove("standardised");
        ArrayList<Document> histValues = (ArrayList<Document>)currentDoc.get("history");
        if (histValues == null) {
            histValues = new ArrayList<Document>();
        } else {
            currentDoc.remove("history");
        }
        currentDoc.append("action", action);
        currentDoc.append("updatedBy", username);
        histValues.add(0, currentDoc);
        if (newDoc.containsKey("history")) {
            histValues.addAll((List)newDoc.get("history"));
            newDoc.remove("history");
        }
        newDoc.append("history", histValues);
        newDoc.put("action", "CURRENT");
        newDoc.put("updatedBy", username);
        this.getBaseNode().setProperties(newDoc);
    }

    @Override
    public ConcurrentHashMap<String, Object> getValues() throws Exception {
        ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
        if (this.getBaseNode().getPropertyValues() != null) {
            ret.putAll(this.getBaseNode().getPropertyValues());
        }
        return ret;
    }

    @Override
    public INode setBaseNode(INode baseNode2) {
        this.baseNode = baseNode2;
        return this.baseNode;
    }

    @Override
    public boolean isComplete() throws Exception {
        if (this.getBaseNode() != null) {
            return this.getBaseNode().hasProperty("Table");
        }
        return false;
    }

    @Override
    public Date getLastUpdated() {
        try {
            if (this.getBaseNode() != null) {
                Object o = this.getBaseNode().getProperty("lastUpdated");
                if (o != null) {
                    return (Date)o;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setLastUpdated(Date date) throws Exception {
        this.getBaseNode().setProperty("lastUpdated", date);
    }

    @Override
    public String getAction() throws Exception {
        if (this.getBaseNode() != null) {
            return (String)this.getBaseNode().getProperty("action");
        }
        return null;
    }

    @Override
    public List<Standardized> getStandardised(String purposeColumnName, MatchProcInterface proc, List<PurposeColumnMap> map, WordList anon) throws Exception {
        List<Standardized> standardsarray = null;
        try {
            if (this.standards.get(purposeColumnName) == null || this.standards.get(purposeColumnName).size() == 0) {
                Document stds;
                List stdvals;
                if (this.baseNode != null && this.baseNode.hasProperty("standardized") && (stdvals = (List)(stds = this.baseNode.getDocument().getAsDocument("standardized")).get(purposeColumnName)) != null) {
                    standardsarray = INode.deserialise(stdvals, proc.getStandardClass());
                }
                if (standardsarray == null || standardsarray.size() > 0 && ((Standardized)standardsarray.get(0)).getComparitorWords().length == 0) {
                    boolean needtorebuild = false;
                    for (PurposeColumnMap mapitem : map) {
                        if (!mapitem.getTableName().equalsIgnoreCase(this.getTableName())) continue;
                        needtorebuild = true;
                        break;
                    }
                    if (needtorebuild) {
                        standardsarray = this.standardise(purposeColumnName, proc, map, anon);
                        if (this.baseNode != null) {
                            if (this.baseNode.getDocument().getAsDocument("standardized") == null) {
                                this.baseNode.getDocument().append("standardized", new Document());
                            }
                            this.baseNode.getDocument().getAsDocument("standardized").append(purposeColumnName, INode.serialize(standardsarray));
                        }
                    }
                }
                this.standards.put(purposeColumnName, standardsarray);
            } else {
                standardsarray = this.standards.get(purposeColumnName);
            }
        }
        catch (IdentizaException e) {
            e.printStackTrace();
        }
        return standardsarray;
    }

    @Override
    public List<Standardized> standardise(String purposeName, MatchProcInterface proc, List<PurposeColumnMap> pcm, WordList anon) throws Exception {
        return Record.standardise(this, this.getSchema(), purposeName, proc, pcm, anon);
    }

    public static List<Standardized> standardise(RecordInterface rec, MatchSchemaInterface schema, String purposeName, MatchProcInterface proc, List<PurposeColumnMap> pcm, WordList anon) throws Exception {
        ArrayList<Standardized> standardsarray = null;
        try {
            standardsarray = new ArrayList<Standardized>();
            for (RecordInterface record : rec.getAllRecords()) {
                Object[] objects = INode.getWords(record.getBaseNode(), pcm, anon, new Date());
                ArrayList baseTokensALL = (ArrayList)objects[0];
                String originalText = (String)objects[1];
                for (ArrayList baseTokens : baseTokensALL) {
                    Standardized stdItem = proc.standardise(originalText, baseTokens.toArray(new String[baseTokens.size()]));
                    if (stdItem.getCalculatedWords() == null) continue;
                    standardsarray.add(stdItem);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return standardsarray;
    }

    public Collection<RecordInterface> getAllRecords() {
        ArrayList<RecordInterface> recs = new ArrayList<RecordInterface>();
        recs.add(this);
        recs.addAll(this.getHistoryRecords());
        return recs;
    }

    public static Integer calcMergeCount(Object o, int mergeIncrement) {
        Integer mc = null;
        try {
            mc = o == null ? Integer.valueOf(0) : (o instanceof Integer ? (Integer)o : Integer.valueOf(Integer.parseInt((String)o)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mc == null) {
            return mergeIncrement;
        }
        return mc + mergeIncrement;
    }

    public void incrementMergeCount(int mergeIncrement) throws NumberFormatException, Exception {
        Object o = this.baseNode.getProperty("MergeCount");
        this.baseNode.setProperty("MergeCount", Record.calcMergeCount(o, mergeIncrement));
    }

    @Override
    public MatchRecordInterface calculateScore(RecordInterface comparitor, boolean forSearch, boolean googleSearch, boolean asContent, boolean matchScoring) throws Exception {
        return this.getSchema().calculateScore(this, comparitor, forSearch, googleSearch, asContent, matchScoring);
    }

    @Override
    public boolean isHistory() {
        if (this.getMatchTable() != null) {
            return this.getMatchTable().isHistory();
        }
        return false;
    }

    @Override
    public String getIcon() {
        String iconValue = null;
        if (this.getMatchTable() != null) {
            String iconField = this.getMatchTable().getIconField();
            try {
                if (iconField != null) {
                    iconValue = this.getValue(iconField);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iconField == null || iconValue == null) {
                iconValue = this.getMatchTable().getDefaultIcon();
            }
        }
        return iconValue;
    }

    @Override
    public String getSystemName() throws Exception {
        if (this.systemName == null && this.getMatchTable() != null) {
            if (this.systemField == null) {
                this.systemField = this.getMatchTable().getSystemField();
            }
            if (this.systemField != null) {
                this.systemName = (String)this.getBaseNode().getProperty(this.systemField);
            }
            if (this.systemName == null) {
                this.systemName = this.tableName;
            }
        }
        return this.systemName;
    }

    @Override
    public String getSensitivityValue() throws Exception {
        if (this.sensitivityField == null) {
            if (this.sensitivityField == null) {
                this.sensitivityField = this.getMatchTable().getSensitivityField();
            }
            if (this.sensitivityField != null) {
                this.sensitivityValue = (String)this.getBaseNode().getProperty(this.sensitivityField);
            }
        }
        return this.sensitivityValue;
    }

    @Override
    public void setSystemName(String systemName) throws Exception {
        this.systemName = systemName;
        if (this.systemField == null) {
            this.systemField = this.getMatchTable().getSystemField();
        }
        this.getBaseNode().setProperty(this.systemField, systemName);
    }

    @Override
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Override
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public int compareTo(Object o) {
        RecordInterface other = (RecordInterface)o;
        if (other.getLastUpdated() != null && this.getLastUpdated() != null) {
            return other.getLastUpdated().compareTo(this.getLastUpdated());
        }
        return 0;
    }

    @Override
    public boolean isSensitive() throws Exception {
        String v = this.getSensitivityValue();
        if (v == null) {
            return false;
        }
        if (v.equalsIgnoreCase("false")) {
            return false;
        }
        if (v.length() == 0) {
            return false;
        }
        return !v.equalsIgnoreCase("null");
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public RecordInterface getDocument() {
        return null;
    }

    @Override
    public List<Document> getXref() {
        return null;
    }

    public static RecordInterface build(MatchSchemaInterface matchSchema2) throws Exception {
        return new Record(matchSchema2);
    }

    public static String buildLabel(Document record, List<String> labelFields) {
        String res = "";
        int l = -1;
        if (labelFields != null) {
            for (String label : labelFields) {
                String val;
                if (record.getProjection(label) == null || (val = Document.objectToString(record.getProjection(label))) == null || val.equals("null") || val.length() <= 0) continue;
                res = res + val;
                if (++l >= labelFields.size() - 1) continue;
                res = res + ", ";
            }
        }
        if ((res = res.trim()).endsWith(",")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }
}

