/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.storage;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.IRelationship;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.storage.ContextMap;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.monster.db.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface RecordInterface
extends Comparable {
    public INode getBaseNode();

    public String getPkey();

    public void neverLoad() throws Exception;

    public String getTableName();

    public void setPkey(String var1);

    public String getEIDField();

    public ArrayList<String> getFieldNames() throws Exception;

    public void setValue(String var1, Object var2);

    public String getValue(String var1) throws Exception;

    public Map<String, Object> toHashMap() throws Exception;

    public String display() throws Exception;

    public void setLabelFields(List<String> var1);

    public List<String> getLabelFields();

    public boolean applyInheritanceFrom(RecordInterface var1);

    public String toString();

    public boolean setValues(Document var1);

    public Collection<RecordInterface> getHistoryRecords();

    public void addHistoryRecord(INode var1, String var2, String var3) throws Exception;

    public ConcurrentHashMap<String, Object> getValues() throws Exception;

    public INode setBaseNode(INode var1);

    public Date getLastUpdated();

    public void setLastUpdated(Date var1) throws Exception;

    public List<Standardized> getStandardised(String var1, MatchProcInterface var2, List<PurposeColumnMap> var3, WordList var4) throws Exception;

    public List<Standardized> standardise(String var1, MatchProcInterface var2, List<PurposeColumnMap> var3, WordList var4) throws Exception;

    public Iterable<RecordInterface> getAllRecords();

    public MatchRecordInterface calculateScore(RecordInterface var1, boolean var2, boolean var3, boolean var4, boolean var5) throws Exception;

    public String getIcon();

    public String getSystemName() throws Exception;

    public void setSystemName(String var1) throws Exception;

    public void setUpdatedBy(String var1);

    public String getUpdatedBy();

    public RecordInterface getDocument();

    public static RecordInterface build(MatchSchemaInterface matchSchema) throws Exception {
        return new Record(matchSchema);
    }

    public RecordInterface assignNode(INode var1) throws Exception;

    public RecordInterface assignTable(MatchTableInterface var1) throws Exception;

    public boolean isValid();

    public void load();

    public ConcurrentHashMap<INode, ContextMap> getRelatedNodes(String var1, String var2, Date var3) throws Exception;

    public IRelationship getRelatedTo(RecordInterface var1, String var2, Date var3) throws Exception;

    public List<Document> getXref();

    public boolean isInternal();

    public String getSensitivityValue() throws Exception;

    public String getAction() throws Exception;

    public String getKeyField();

    public boolean isHistory();

    public RecordInterface save(boolean var1, String var2) throws Exception;

    public boolean isComplete() throws Exception;

    public boolean isSensitive() throws Exception;

    public void addRelatedRec(RecordInterface var1, String var2, Date var3, Document var4, String var5, String var6) throws Exception;

    public void saveNoIndexes(String var1) throws Exception;

    public void addRelatedRec(RecordInterface var1, String var2, Date var3, String var4, String var5) throws Exception;
}

