/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.storage;

import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.storage.ContextMap;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class Result
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7728756772762055259L;
    String pkey;
    String tablename;
    String label;
    boolean isInternal = true;
    Document values;
    double score = 0.0;
    private List<Document> xref;
    private Date lastUpdated;
    private String action;
    private String icon;
    private String id;
    private String lastUpdater;
    private List<Map<String, Object>> history;
    private String sensitivityValue;
    private Map<Result, ContextMap> children;
    private Document document;
    private List<Document> histDoc = new ArrayList<Document>();
    private long eid;

    public Result(String pkey, MatchRecordInterface matchRecord, Record rec, boolean isDirect) throws Exception {
        rec.load();
        this.setPkey(pkey);
        this.setTable(rec.getTableName());
        this.setScore(matchRecord.getScore());
        this.setValues(rec.toHashMap());
        this.setLabel(rec.display());
        this.setXREF(rec.getXref());
        this.setLastUpdated(rec.getLastUpdated());
        this.setUpdatedBy(rec.getUpdatedBy());
        this.setAction(rec.getAction());
        this.icon = rec.getIcon();
        this.isInternal = rec.isInternal();
        this.eid = rec.getBaseNode().getDocument().getLong("EID");
        this.setSensitivityValue(rec.getSensitivityValue());
        this.history = new ArrayList<Map<String, Object>>();
        for (RecordInterface rh : rec.getAllRecords()) {
            Map<String, Object> hm = rh.toHashMap();
            hm.put("label", rec.display());
            this.history.add(hm);
        }
    }

    public int hashCode() {
        return (this.getTable() + ":" + this.getPkey()).hashCode();
    }

    public String toString() {
        return this.getTable() + ":" + this.getPkey();
    }

    public boolean equals(Object other) {
        return other.toString().equalsIgnoreCase(this.toString());
    }

    private void setAction(String action2) {
        this.action = action2;
    }

    public Result(String pkey, MatchRecordInterface matchRecord, RecordInterface recordInterface) throws Exception {
        recordInterface.load();
        if (recordInterface.isValid()) {
            this.setPkey(pkey);
            this.setTable(recordInterface.getTableName());
            this.setScore(matchRecord.getScore());
            this.setValues(recordInterface.toHashMap());
            this.setDocument(recordInterface.getBaseNode().getDocument());
            this.setLabel(recordInterface.display());
            this.isInternal = recordInterface.isInternal();
            this.setXREF(recordInterface.getXref());
            this.setLastUpdated(recordInterface.getLastUpdated());
            this.setAction(recordInterface.getAction());
            this.setUpdatedBy(recordInterface.getUpdatedBy());
            this.icon = recordInterface.getIcon();
            this.eid = recordInterface.getBaseNode().getDocument().getLong("EID");
            this.setSensitivityValue(recordInterface.getSensitivityValue());
            this.history = new ArrayList<Map<String, Object>>();
            for (RecordInterface rh : recordInterface.getAllRecords()) {
                this.history.add(rh.toHashMap());
            }
        }
    }

    public void setXREF(List<Document> xref) {
        this.xref = xref;
    }

    public List<Document> getXREF() {
        return this.xref;
    }

    public Result(Document record, String key, String label, String icon) {
        this.values = record;
        this.document = record;
        this.setPkey(key);
        this.setNodeID(record.getString("_id"));
        this.setTable(this.values.getString("Table"));
        this.setLabel(label);
        this.setIcon(icon);
        this.setLastUpdated(this.values.getDate("lastUpdated"));
        this.setUpdatedBy(this.values.getString("updatedBy"));
        this.eid = record.getLong("EID");
    }

    public Result(RecordInterface record) throws Exception {
        if (record != null && record.isValid()) {
            record.load();
            this.setPkey(record.getPkey());
            this.setTable(record.getTableName());
            this.setScore(100.0);
            Document doc = new Document(record.getBaseNode().getDocument());
            doc.remove("standardized");
            doc.remove("tokens");
            this.setDocument(doc);
            this.setValues(record.getValues());
            this.setLabel(record.display());
            this.setXREF(record.getXref());
            this.setLastUpdated(record.getLastUpdated());
            this.setUpdatedBy(record.getUpdatedBy());
            this.setAction(record.getAction());
            this.isInternal = record.isInternal();
            this.setSensitivityValue(record.getSensitivityValue());
            if (record != null) {
                this.eid = record.getBaseNode().getDocument().getLong("EID");
                this.icon = record.getIcon();
                if (record.getBaseNode() != null) {
                    this.id = record.getBaseNode().getId();
                }
                this.history = new ArrayList<Map<String, Object>>();
                for (RecordInterface rh : record.getAllRecords()) {
                    Document doc2 = new Document(rh.getBaseNode().getDocument());
                    doc2.remove("standardized");
                    doc2.remove("tokens");
                    this.history.add(rh.toHashMap());
                    this.histDoc.add(doc2);
                }
            }
        }
    }

    private void setSensitivityValue(String sensitivityValue) {
        this.sensitivityValue = sensitivityValue;
    }

    public String getSensitivityValue() {
        return this.sensitivityValue;
    }

    public Result(MatchSchemaInterface schema, Node node) throws Exception {
        this(RecordInterface.build(schema).assignNode(node));
    }

    public Result() {
        this.values = new Document();
    }

    public String getPkey() {
        return this.pkey;
    }

    public void setPkey(String pkey) {
        this.pkey = pkey;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = new Document(values);
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setTable(String tableName) {
        this.tablename = tableName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTable() {
        return this.tablename;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date date) {
        this.lastUpdated = date;
    }

    public String getAction() {
        return this.action;
    }

    public int compareTo(Object arg0) {
        if (((Result)arg0).score < this.score) {
            return -1;
        }
        if (((Result)arg0).score > this.score) {
            return 1;
        }
        return 0;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String toJSON(boolean isHistory) {
        return this.toJSON(null, isHistory);
    }

    public Document toDocument(ContextMap ctx) {
        Document ret = new Document(this.document);
        ret.append("label", this.getLabel());
        ret.append("id", this.getPkey());
        if (ctx != null) {
            ret.append("context", Document.parse("{list:" + ctx.valuesToJSONString() + "}").get("list"));
        }
        if (this.children != null && this.children.size() > 0) {
            ArrayList<Document> childrenList = new ArrayList<Document>();
            ret.append("children", childrenList);
            for (Result rel : this.children.keySet()) {
                if (rel.id == this.id) continue;
                Document childNode = new Document();
                ctx = this.children.get(rel);
                childNode.append("node", rel.toDocument(ctx));
                childrenList.add(childNode);
            }
        }
        return ret;
    }

    public Document toDocument() {
        Document result = new Document();
        if (this.getPkey() != null) {
            result.append("node", this.getPkey());
        }
        if (this.getLabel() != null) {
            result.append("label", this.getLabel());
        }
        if (this.getIcon() != null) {
            result.append("icon", this.getIcon());
        }
        result.append("values", this.values);
        return result;
    }

    public String toJSON(ContextMap map, boolean isHistory) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        result.append("{");
        if (this.values != null) {
            for (Object key : this.values.keySet()) {
                if (((String)key).equalsIgnoreCase("TaskIds")) continue;
                String value = Document.objectToString(this.values.get(key));
                if (value == null) {
                    value = "";
                }
                if (!first) {
                    result.append(",");
                }
                first = false;
                result.append("\"" + key + "\": \"" + value + "\"");
            }
            if (!first) {
                result.append(",");
            }
            result.append("\"Label\": \"" + this.getLabel() + "\"");
            result.append(",\"Score\": \"" + this.getScore() + "\"");
            result.append(",\"Icon\": \"" + this.getIcon() + "\"");
            result.append(",\"id\": \"" + this.getPkey() + "\"");
            result.append(",\"_id\": \"" + this.getID() + "\"");
            if (!this.values.containsKey("Table")) {
                result.append(",\"Table\": \"" + this.getTable() + "\"");
            }
            if (map != null) {
                result.append(",");
                result.append(map.valuesToJSONString());
            }
            result.append(", \n\"children\": [");
            if (this.children != null && this.children.size() > 0) {
                boolean cfirst = true;
                for (Result rel : this.children.keySet()) {
                    ContextMap ctx = this.children.get(rel);
                    if (!cfirst) {
                        result.append(",");
                    }
                    if (rel.id != this.id) {
                        result.append("\n" + rel.toTreeString(ctx));
                    }
                    cfirst = false;
                }
            }
            result.append("]");
        }
        result.append("}");
        return result.toString();
    }

    public void setNodeID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getUpdatedBy() {
        return this.lastUpdater;
    }

    public void setUpdatedBy(String updatedBy) {
        this.lastUpdater = updatedBy;
    }

    public List<Map<String, Object>> getHistoryValues() {
        return this.history;
    }

    public String getJsonValues() {
        return null;
    }

    public Map<Result, ContextMap> getChildren() {
        return this.children;
    }

    public void setChildren(Map<Result, ContextMap> children) {
        this.children = children;
    }

    public String toTreeString(ContextMap ctxm) {
        String ret = "";
        ret = this.icon != null ? ret + "{\"id\": \"" + this.getPkey() + "\", \"name\": \"" + this.label + "\", \"type\": \"\", \"data\": {\"entity\": \"" + this.tablename + "\", \"icon\": \"" + this.icon + "\", \"$datatype\": \"star\", \"sensitivityValue\": \"" + this.sensitivityValue + "\"}" : ret + "{\"id\": \"" + this.getPkey() + "\", \"name\": \"" + this.label + "\", \"type\": \"\", \"data\": {\"entity\": \"" + this.tablename + "\", \"$datatype\": \"star\", \"sensitivityValue\": \"" + this.sensitivityValue + "\"}";
        if (ctxm != null) {
            ret = ret + ", \"contextMap\": " + ctxm.valuesToJSONString();
        }
        ret = ret + ", \"values\": [";
        if (this.values != null && this.values.size() != 0) {
            for (Object e : this.values.keySet()) {
                ret = ret + "{\"key\": \"" + e + "\", \"value\": \"" + StringEscapeUtils.escapeJava((String)this.values.get(e).toString()) + "\"},";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        ret = ret + "], \n\"children\": [";
        if (this.children != null && this.children.size() > 0) {
            for (Result result : this.children.keySet()) {
                ContextMap ctx = this.children.get(result);
                if (result.id == this.id) continue;
                ret = ret + "\n" + result.toTreeString(ctx) + ",";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        ret = ret + "]";
        ret = ret + ", \n\"history\": [";
        if (this.history != null && this.history.size() != 0) {
            for (Map map : this.history) {
                ret = ret + "{";
                for (String key : map.keySet()) {
                    ret = ret + "\"" + key + "\": \"" + StringEscapeUtils.escapeJava((String)map.get(key).toString()) + "\",";
                }
                ret = ret.substring(0, ret.length() - 1) + "},";
            }
            ret = ret.substring(0, ret.length() - 1);
        }
        ret = ret + "]}";
        return ret;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public long getRecordEID() {
        return this.eid;
    }
}

