/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.storage;

import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.match.MatchSchemaInterface;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.Result;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.monster.db.Document;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Task
implements Serializable,
Comparable<Task> {
    private static final long serialVersionUID = 1L;
    private String name;
    private Result[] nodes;
    private String table;
    private String id;
    private String type = "Duplicate";
    private String resolvedBy;
    private Document workflow;
    private List<String> actions;
    private Date created;
    private Date due;
    private boolean resolved;
    private String comment;
    private double score;
    private String ruleid;
    private int taskcount;
    private String action;
    private List resolutions;
    private int step;
    private String documentType;

    public Task() {
    }

    public Task(String object) {
        this.id = object;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getStatus() {
        Date today = new Date();
        if (this.resolved) {
            return "Resolved";
        }
        if (this.due != null) {
            if (this.due.after(today)) {
                return "Overdue";
            }
            return "On Time";
        }
        return "Unknown";
    }

    public void setNodes(Result[] nodes) {
        this.nodes = nodes;
    }

    public Result[] getNodes() {
        return this.nodes;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setResolvedBy(String object) {
        this.resolvedBy = object;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getRule() {
        return this.ruleid;
    }

    public void setRule(String ruleid) {
        this.ruleid = ruleid;
    }

    @Override
    public int compareTo(Task arg0) {
        if (arg0.getScore() < this.getScore()) {
            return -1;
        }
        if (arg0.getScore() > this.getScore()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Task) {
            return this.id == ((Task)arg0).getId();
        }
        return true;
    }

    public void setCount(int taskcount) {
        this.taskcount = taskcount;
    }

    public int getTaskCount() {
        return this.taskcount;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAction() {
        return this.action;
    }

    public static Task build(MatchSchemaInterface schema, Document aTaskNode) {
        if (aTaskNode == null) {
            return null;
        }
        DateFormat df = DateFormat.getDateInstance();
        Task intTask = new Task(aTaskNode.getString("_id"));
        if (aTaskNode.get("Task") != null) {
            intTask.setCount(1);
            intTask.setName((String)aTaskNode.get("Task"));
            if (aTaskNode.containsKey("Comment")) {
                intTask.setComment((String)aTaskNode.get("Comment"));
            }
            try {
                if (aTaskNode.containsKey("Created")) {
                    if (aTaskNode.get("Created") instanceof Date) {
                        intTask.setCreated((Date)aTaskNode.get("Created"));
                    } else {
                        intTask.setCreated(df.parse((String)aTaskNode.get("Created")));
                    }
                }
                if (aTaskNode.containsKey("Due")) {
                    if (aTaskNode.get("Due") instanceof Date) {
                        intTask.setDue((Date)aTaskNode.get("Due"));
                    } else {
                        intTask.setDue(df.parse((String)aTaskNode.get("Due")));
                    }
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (aTaskNode.containsKey("Resolved")) {
                if (aTaskNode.get("Resolved") instanceof String) {
                    intTask.setResolved(Boolean.parseBoolean((String)aTaskNode.get("Resolved")));
                } else {
                    intTask.setResolved((Boolean)aTaskNode.get("Resolved"));
                }
            }
            if (aTaskNode.containsKey("ResolvedBy") && aTaskNode.get("ResolvedBy") instanceof String) {
                intTask.setResolvedBy(aTaskNode.getString("ResolvedBy"));
            }
            if (aTaskNode.containsKey("Tablename")) {
                intTask.setTable((String)aTaskNode.get("Tablename"));
            }
            if (aTaskNode.containsKey("Score")) {
                Object score = aTaskNode.get("Score");
                if (score instanceof Number) {
                    intTask.setScore(((Number)score).doubleValue());
                } else {
                    intTask.setScore(Double.parseDouble((String)score));
                }
            }
            if (aTaskNode.containsKey("Rule")) {
                try {
                    intTask.setRule(aTaskNode.getString("Rule"));
                }
                catch (NumberFormatException score) {
                    // empty catch block
                }
            }
            if (aTaskNode.containsKey("Type")) {
                intTask.setType((String)aTaskNode.get("Type"));
            }
            if (aTaskNode.containsKey("DocumentType")) {
                intTask.setDocumentType((String)aTaskNode.get("DocumentType"));
            }
            if (aTaskNode.containsKey("Workflow")) {
                intTask.setWorkflow(aTaskNode.getAsDocument("Workflow"));
                intTask.setStep(aTaskNode.getInteger("Step"));
                if (aTaskNode.containsKey("Resolutions")) {
                    intTask.setResolutions(aTaskNode.getList("Resolutions"));
                }
            }
            if (aTaskNode.containsKey("Action")) {
                intTask.setAction(aTaskNode.getString("Action"));
            }
            if (aTaskNode.containsKey("Actions")) {
                intTask.setActions(aTaskNode.getList("Actions"));
            }
            if (aTaskNode.containsKey("Nodes")) {
                try {
                    ArrayList nodeList = (ArrayList)aTaskNode.get("Nodes");
                    Result[] nodes = new Result[nodeList.size()];
                    int count = -1;
                    for (Object node : nodeList) {
                        if (node instanceof String) {
                            RecordInterface rec = Record.build(schema).assignNode(new Node(schema.getDb(), (String)node));
                            if (rec == null) continue;
                            nodes[++count] = new Result(rec);
                            continue;
                        }
                        if (!(node instanceof Document)) continue;
                        nodes[++count] = new Result();
                        nodes[count].setValues((Document)node);
                    }
                    intTask.setNodes(nodes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return intTask;
    }

    private void setDocumentType(String string) {
        this.documentType = string;
    }

    private void setResolutions(List list) {
        this.resolutions = list;
    }

    private void setStep(int step) {
        this.step = step;
    }

    public String getResolvedBy() {
        return this.resolvedBy;
    }

    public Document getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Document workflow) {
        this.workflow = workflow;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public Document toDocument() {
        Document result = new Document();
        result.append("id", this.getId()).append("type", this.getType()).append("action", this.getAction()).append("task", WordList.cleanLeaveSpaces(this.getName())).append("status", this.getStatus()).append("due", this.getDue()).append("created", this.getCreated()).append("comment", this.getComment()).append("resolvedBy", this.getResolvedBy());
        if (this.getRule() != null) {
            result.append("score", this.getScore());
            result.append("ruleid", this.getRule());
        }
        if (this.getTable() != null) {
            result.append("table", this.getTable());
        }
        if (this.getDocumentType() != null) {
            result.append("DocumentType", this.getDocumentType());
        }
        if (this.getActions() != null) {
            result.append("Actions", this.getActions());
        }
        if (this.getWorkflow() != null) {
            result.append("Workflow", this.getWorkflow());
            result.append("Step", this.getStep());
            if (this.getResolutions() != null) {
                result.append("Resolutions", this.getResolutions());
            }
        }
        return result;
    }

    private Object getResolutions() {
        return this.resolutions;
    }

    private int getStep() {
        return this.step;
    }
}

