/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardAddress;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class MatchAddress
extends MatchBase
implements Serializable {
    Logger logger = Logger.getLogger("com.identiza");

    public MatchAddress(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchAddress(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "ADDRESS");
    }

    public MatchAddress(String name) {
        super(name);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardAddress(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        HashSet<String> keys = new HashSet<String>();
        String fullValue = "";
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        for (int j = 0; j < ((String[])value).length; ++j) {
            if (value[j] == null) continue;
            fullValue = fullValue + " " + value[j];
        }
        fullValue = fullValue.trim();
        String[] words = WordList.split(fullValue);
        String[] pobox = new String[]{"BOX", "POBOX", "PO", "PBOX"};
        String[] streetnames = new String[]{"ALLEY", "ALY", "APR", "APPROACH", "AUTOBAHN", "AUTO-ESTRADA", "AUTOROUTE", "AUTOSTRADA", "AUTOSTRASSE", "AVE", "AVENUE", "BAY", "BLVD", "BOULEVARD", "BYP", "BYPASS", "BYWAY", "CANYON", "CAUSEWAY", "CIR", "CIRC", "CIRCLE", "CIRCUS", "CLOSE", "COURT", "COVE", "CRES", "CRESCENT", "CROFT", "CSWY", "CT", "CULS-DE-SAC ", "CV", "CYN", "DELL", "DR", "DRIVE", "ESP", "ESPLANADE", "EXPRESSWAY", "EXPY", "FREEWAY", "FRONTAGE", "FWY", "GARDENS", "GARTH", "GATE", "GDNS", "GRADE", "GREEN", "GRN", "GROVE", "GRV", "HEIGHTS", "HIGHLANDS", "HIGHWAY", "HILL", "HL", "HTS", "HWY", "KEY", "KNL", "KNOLL", "LANE", "LAWN", "LN", "LOOP", "MANOR", "MEWS", "MNR", "MOTORWAY", "MOUNT", "MT", "MTRWY", "MWAY", "NENE", "NOOK", "OVAL", "PARADE", "PARK", "PARKWAY", "PASSAGE", "PATHWAY", "PDE", "PIKE", "PKWY", "PL", "PLACE", "PLAZA", "PLZ", "PROM", "PROMENADE", "PSGE", "PTHWY", "QUADRANT", "QUAY", "RD", "RISE", "ROAD", "ROW", "SPUR", "SQ", "SQUARE", "ST", "STRA", "STRAVENUE", "STREET", "TCE", "TER", "TERRACE", "TPK", "TRACE", "TRAIL", "TRCE", "TRL", "TURNPIKE", "VALE", "VIEW", "VW", "WALK", "WAY"};
        int poboxpos = EditDistance.findToken(words, pobox);
        int streetTypePos = EditDistance.findToken(words, streetnames);
        int flatpos = EditDistance.findToken(words, new String[]{"FLAT", "FL", "UNIT", "U", "APT", "APARTMENT", "SHOP", "BUILDING", "BLDG", "SUITE", "SUITES", "/"});
        String city = "";
        if (poboxpos > -1) {
            for (int i = poboxpos + 1; i < words.length; ++i) {
                if (!"0123456789".contains("" + words[i].charAt(0))) continue;
                if (words.length > i + 1) {
                    for (int ii = streetTypePos + 1; ii < words.length; ++ii) {
                        city = city + this.getKey(words[ii]) + ":";
                    }
                }
                if (city.length() > 0) {
                    city = city.substring(0, city.length() - 1);
                }
                keys.addAll(this.allCombs("PO" + words[i] + city, this.partialKeys, false, this.minWidth, this.maxWidth));
                break;
            }
        } else if (streetTypePos > -1) {
            String streetnumber = "";
            int streetnumberpos = -1;
            String unitnumber = "";
            if (flatpos > -1 && words.length > flatpos + 1) {
                unitnumber = words[flatpos + 1];
            } else {
                flatpos = -2;
            }
            for (int i = flatpos + 2; i < streetTypePos; ++i) {
                if (!"0123456789".contains("" + words[i].charAt(0))) continue;
                streetnumberpos = i;
                if (words[i].contains("\\") || words[i].contains("/")) {
                    String[] numberparts = words[i].split("\\|/");
                    streetnumber = numberparts[0];
                    unitnumber = numberparts[1];
                    break;
                }
                streetnumber = words[i];
                break;
            }
            String street = "";
            if (words.length > streetnumberpos) {
                for (int i = streetnumberpos + 1; i < streetTypePos; ++i) {
                    street = street + this.getKey(words[i]) + ":";
                }
            }
            if (street.length() > 0) {
                street = street.substring(0, street.length() - 1);
            }
            if (words.length > streetTypePos) {
                for (int ii = streetTypePos + 1; ii < words.length; ++ii) {
                    city = city + this.getKey(words[ii]);
                }
            }
            if (streetnumber.contains("-")) {
                String[] numbers = streetnumber.split("-");
                if (numbers.length > 1) {
                    try {
                        int startNum = EditDistance.niceParseInt(numbers[0]);
                        int endNum = EditDistance.niceParseInt(numbers[numbers.length - 1]);
                        for (int i = startNum; i <= endNum; ++i) {
                            keys.add(i + street + city);
                        }
                    }
                    catch (NumberFormatException startNum) {}
                } else {
                    keys.add(streetnumber + street + city);
                }
            } else {
                keys.add(streetnumber + street + city);
            }
            if (unitnumber.length() > 0) {
                keys.add(unitnumber + street + city);
            }
        } else {
            int streetnumberpos = -1;
            String unitnumber = "";
            String streetnumber = "";
            if (flatpos > -1 && words.length > flatpos + 1) {
                unitnumber = words[flatpos + 1];
            } else {
                flatpos = -2;
            }
            if (streetTypePos == -1) {
                streetTypePos = words.length;
            }
            for (int i = flatpos + 2; i < streetTypePos; ++i) {
                if (!"0123456789".contains("" + words[i].trim().charAt(0))) continue;
                streetnumberpos = i;
                if (words[i].contains("\\") || words[i].contains("/")) {
                    String[] numberparts = words[i].split("\\|/");
                    streetnumber = numberparts[0];
                    unitnumber = numberparts[1];
                    break;
                }
                streetnumber = words[i];
                break;
            }
            String streetAndCity = "";
            if (words.length > streetnumberpos) {
                for (int i = streetnumberpos + 1; i < words.length; ++i) {
                    streetAndCity = streetAndCity + this.getKey(words[i]) + ":";
                }
            }
            if (streetAndCity.length() > 0) {
                streetAndCity = streetAndCity.substring(0, streetAndCity.length() - 1);
            }
            if (streetnumber.contains("-")) {
                String[] numbers = streetnumber.split("-");
                if (numbers.length > 1) {
                    int startNum = EditDistance.niceParseInt(numbers[0]);
                    int endNum = EditDistance.niceParseInt(numbers[numbers.length - 1]);
                    for (int i = startNum; i <= endNum; ++i) {
                        keys.add(i + streetAndCity);
                    }
                } else {
                    keys.add(streetnumber + streetAndCity);
                }
            } else {
                keys.add(streetnumber + streetAndCity);
            }
            if (unitnumber.length() > 0) {
                keys.add(unitnumber + streetAndCity);
            }
        }
        return keys;
    }

    @Override
    public String getKey(String word) {
        if ("0123456789".contains(word.substring(0, 1))) {
            return word;
        }
        if (!word.equals("null") && word.length() > 3 && this.getKeyAnon() == null || this.getKeyAnon() != null && this.getKeyAnon().isUsefulForComparison(word, 2)) {
            return NYSIIS.encode(word.toUpperCase().trim().replaceAll("[^A-Z0-9]", ""));
        }
        return "";
    }

    public static void main(String[] args) {
        MatchAddress ma = new MatchAddress("");
        ma.minWidth = 2;
        ma.maxWidth = 2;
        System.out.println(ma.getKeys("Unit 20 1 Daly St DARWIN NT 800", false));
        System.out.println(ma.getKeys("Unit 20 1 Daly St DARWIN NT 800", false));
    }
}

