/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.entity.resolve.types.StandardPhonetic;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;

public class MatchBase
implements MatchProcInterface,
Serializable {
    protected RuleSet ruleSet;
    protected boolean partialKeys = true;
    protected String type = "MatchBase";
    protected int gradient;
    protected boolean isMandatory;
    protected String ruleFunction;
    protected int maxScore = 100;
    protected Logger logger = Logger.getLogger("com.identiza");
    protected int minWidth;
    protected int maxWidth;

    public MatchBase(String ruleFunction, int _minwidth, int _maxwidth) throws Exception {
        this.ruleFunction = ruleFunction;
        this.minWidth = _minwidth;
        this.maxWidth = _maxwidth;
    }

    public MatchBase(String ruleFunction) {
        this.ruleFunction = ruleFunction;
    }

    public MatchBase(String ruleFunction, int minwidth, int maxwidth, String type) throws Exception {
        this.type = type;
        this.ruleFunction = ruleFunction;
        this.minWidth = minwidth;
        this.maxWidth = maxwidth;
    }

    protected ArrayList<String> compressInitials(String[] in) {
        String accumulate = "";
        ArrayList<String> out = new ArrayList<String>();
        for (String word : in) {
            if (word.trim().length() == 1) {
                accumulate = accumulate + word.trim();
                continue;
            }
            if (accumulate.length() > 0) {
                out.add(accumulate);
                accumulate = "";
            }
            out.add(word);
        }
        if (accumulate.length() > 0) {
            out.add(accumulate);
            accumulate = "";
        }
        return out;
    }

    @Override
    public void init(String ruleFunction) {
        this.ruleFunction = ruleFunction;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void setRuleFunction(String ruleFunction) {
        this.ruleFunction = ruleFunction;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setRuleSet(RuleSet ruleset) {
        this.ruleSet = ruleset;
    }

    @Override
    public WordList getKeyCv() {
        return this.ruleSet.getKeyControlledVocabulary();
    }

    @Override
    public WordList getKeyAnon() {
        return this.ruleSet.getKeyAnon();
    }

    @Override
    public WordList getRuleAnon() {
        return this.ruleSet.getRuleAnon();
    }

    @Override
    public WordList getRuleCv() {
        return this.ruleSet.getRuleControlledVocabulary();
    }

    public WordList getKeyLookup() {
        return this.ruleSet.getKeyLookup();
    }

    public WordList getRuleLookup() {
        return this.ruleSet.getRuleLookup();
    }

    protected HashSet<String> getAlternateWords(String word, WordList anon, WordList controlVocabulary) {
        WordObject wordlist;
        String kkey;
        HashSet<String> alternates = new HashSet<String>();
        String key = this.getKey(word);
        if (key.length() > 0) {
            alternates.add(key);
        }
        if ((anon == null || anon.isUseful(word)) && controlVocabulary != null && (kkey = controlVocabulary.generateKey(word)) != null && (wordlist = controlVocabulary.getWord(kkey)) != null) {
            ArrayList<String> parents = wordlist.getSameParents();
            for (String parent : parents) {
                WordObject wo = controlVocabulary.getWord(parent);
                String key2 = this.getKey(wo.getWord());
                if (key2.length() <= 0) continue;
                alternates.add(key2);
            }
        }
        return alternates;
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        return this.getKeys(value, batch, false);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch, boolean isSearch) {
        String[] tempwords = new String[]{};
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashMap alternates = new HashMap();
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            tempwords = WordList.split(value[j]);
            for (int i = 0; i < tempwords.length; ++i) {
                String word = tempwords[i];
                if ((this.ruleSet.getKeyAnon() == null || !this.ruleSet.getKeyAnon().isUsefulForComparison(word, 1)) && (this.ruleSet.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 1))) continue;
                if (!alternates.containsKey(word)) {
                    alternates.put(word, new HashSet());
                }
                ((HashSet)alternates.get(word)).addAll(this.getAlternateWords(word, this.ruleSet.getKeyAnon(), this.ruleSet.getKeyControlledVocabulary()));
            }
        }
        ArrayList<HashSet<String>> temp = new ArrayList<HashSet<String>>();
        for (String origWord : alternates.keySet()) {
            HashSet res = (HashSet)alternates.get(origWord);
            if (res == null || res.size() <= 0) continue;
            temp.add(res);
        }
        if (temp.size() > 0) {
            if (!isSearch) {
                return this.processKey(temp, 0, "", this.partialKeys, isSearch, this.minWidth);
            }
            return this.processKey(temp, 0, "", this.partialKeys, isSearch, tempwords.length);
        }
        return null;
    }

    protected HashSet<String> processKey(ArrayList<HashSet<String>> alternates, int startpos, String keySoFar, boolean partialKeys, boolean isSearch, int searchWidth) {
        HashSet<String> allKeys = new HashSet<String>();
        if (alternates.size() > 0) {
            for (String comb1 : alternates.get(startpos)) {
                String newKey = "";
                newKey = keySoFar.length() > 0 ? keySoFar + ":" + comb1 : comb1;
                if (startpos < alternates.size() - 1) {
                    allKeys.addAll(this.processKey(alternates, startpos + 1, newKey, partialKeys, isSearch, searchWidth));
                    continue;
                }
                if (!isSearch) {
                    allKeys.addAll(this.allCombs(newKey, partialKeys, false, this.minWidth, this.maxWidth));
                    continue;
                }
                allKeys.addAll(this.allCombs(newKey, partialKeys, false, searchWidth, searchWidth));
            }
        }
        return allKeys;
    }

    protected Collection<String> processKeyInOrder(ArrayList<ArrayList<String>> alternates, int startpos, String keySoFar, boolean partialKeys) {
        HashSet<String> allKeys = new HashSet<String>();
        if (alternates.size() > 0) {
            for (String comb1 : alternates.get(startpos)) {
                String newKey = "";
                newKey = keySoFar.length() > 0 ? keySoFar + ":" + comb1 : comb1;
                if (startpos < alternates.size() - 1) {
                    allKeys.addAll(this.processKeyInOrder(alternates, startpos + 1, newKey, partialKeys));
                    continue;
                }
                allKeys.add(newKey);
            }
        }
        return allKeys;
    }

    protected ArrayList<String> allCombs(String key, boolean partial, boolean alwaysUseFirst, int minWidth, int maxWidth) {
        ArrayList<String> ret = new ArrayList<String>();
        if (key.startsWith(":")) {
            key = key.substring(1);
        }
        String[] combs = key.split(":");
        if (alwaysUseFirst && combs[0].length() > 0) {
            ret.add(combs[0]);
        }
        for (int i = 0; i < combs.length; ++i) {
            String newkey = "";
            int _width = 0;
            for (int j = i; j < combs.length + i; ++j) {
                int k = 0;
                k = j < combs.length ? j : j - combs.length;
                newkey = newkey + combs[k];
                if (!partial && j >= combs.length + i || (++_width < minWidth || _width > maxWidth) && combs.length != 1 || newkey.length() <= 0) continue;
                ret.add(newkey);
            }
        }
        if (!this.isMandatory) {
            ret.add("");
        }
        return ret;
    }

    @Override
    public String sha256(String base) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public String getKey(String word) {
        return null;
    }

    @Override
    public boolean isTextIndex() {
        return false;
    }

    @Override
    public void setGradient(int gradientType) {
        this.gradient = gradientType;
    }

    @Override
    public Collection<String> getKeys(HashMap<String, String> value, boolean batch) {
        return null;
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        if (this.ruleSet.getRuleControlledVocabulary() != null && this.ruleSet.getRuleControlledVocabulary().isBadWords(stdBase.getComparitorWords(), stdComp.getComparitorWords())) {
            return 0.0;
        }
        try {
            return stdBase.compare(stdComp, this.ruleSet.getRuleAnon(), this.ruleSet.getRuleControlledVocabulary(), isSearch, asContent);
        }
        catch (Exception e) {
            this.logger.severe("Compare Calculation failed: " + e.toString());
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardPhonetic(originalText, words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public ArrayList<String> getPurposeKeys(String in) {
        if (in != null) {
            return this.compressInitials(WordList.split(in.toUpperCase()));
        }
        return new ArrayList<String>();
    }

    @Override
    public Class<Standardized> getStandardClass() {
        return Standardized.class;
    }
}

