/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardChinesePersonName;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.language.utils.zh.ZHConverter;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class MatchChinesePersonName
extends MatchBase
implements Serializable {
    public MatchChinesePersonName(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchChinesePersonName(String name, int minwidth, int maxwidth, int start, int end, int gradient) throws Exception {
        super(name, minwidth, maxwidth, "MATCHZHPERSONNAME");
        this.maxScore = 90;
    }

    public MatchChinesePersonName(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardChinesePersonName(words, this.getRuleAnon(), this.getRuleCv(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        HashSet<String> keys = new HashSet<String>();
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        String fullValue = "";
        for (int j = 0; j < ((String[])value).length; ++j) {
            if (value[j] == null) continue;
            fullValue = fullValue + " " + value[j];
        }
        fullValue = fullValue.trim();
        fullValue = this.getKeyAnon().removeAnon(fullValue);
        if (fullValue.length() > 0) {
            String surname = "";
            String firstname = "";
            ArrayList<HashSet<String>> surnameAlternates = new ArrayList();
            ArrayList<HashSet<String>> firstnameAlternates = new ArrayList();
            if (Character.UnicodeBlock.of(fullValue.charAt(0)) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
                if (this.getKeyCv() != null) {
                    surname = this.getKeyCv().startsWith(fullValue);
                    if (surname.length() == 0) {
                        surname = "" + fullValue.charAt(0);
                    }
                } else if (fullValue.length() > 0) {
                    surname = "" + fullValue.charAt(0);
                }
                firstname = fullValue.substring(surname.length());
                surnameAlternates = this.convertToPinyin(surname);
                firstnameAlternates = this.convertToPinyin(firstname);
            } else {
                surname = fullValue.substring(0, fullValue.indexOf(" "));
                firstname = fullValue.substring(fullValue.indexOf(" ") + 1);
                surnameAlternates = this.getAlternates(surname);
                firstnameAlternates = this.getAlternates(firstname);
            }
            HashSet<String> surnameKeys = this.processKey(surnameAlternates, 0, "", false, false, this.minWidth);
            HashSet<String> firstnameKeys = this.processKey(firstnameAlternates, 0, "", true, false, this.minWidth);
            for (String surnameKey : surnameKeys) {
                if (firstnameKeys.size() > 0) {
                    for (String firstnameKey : firstnameKeys) {
                        keys.add(surnameKey + firstnameKey);
                    }
                    continue;
                }
                keys.add(surnameKey);
            }
        }
        return keys;
    }

    private ArrayList<HashSet<String>> getAlternates(String latinText) {
        String[] words;
        ArrayList<HashSet<String>> ret = new ArrayList<HashSet<String>>();
        for (String word : words = WordList.split(latinText)) {
            ret.add(this.getAlternateWords(word, this.getKeyAnon(), this.getKeyCv()));
        }
        return ret;
    }

    @Override
    public String getKey(String word) {
        return word.toUpperCase().replaceAll("[0-9]", "").replaceAll("`", "");
    }

    private HashSet<String> toPinyin(String traditionalStr) {
        ZHConverter converter = ZHConverter.getInstance(1);
        String simplifiedStr = converter.convert(traditionalStr);
        HashSet<String> words = new HashSet<String>();
        if (this.getKeyCv() != null) {
            for (int i = 0; i < simplifiedStr.length(); ++i) {
                try {
                    String keyTrad = Integer.toHexString(simplifiedStr.charAt(i)).toUpperCase();
                    String keySimp = Integer.toHexString(traditionalStr.charAt(i)).toUpperCase();
                    WordObject sim = this.getKeyCv().getWord(keySimp);
                    WordObject tra = this.getKeyCv().getWord(keyTrad);
                    if (sim != null) {
                        this.concatentateArray(sim.getSameParents(), words);
                        continue;
                    }
                    if (tra == null) continue;
                    this.concatentateArray(tra.getSameParents(), words);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return words;
    }

    private ArrayList<HashSet<String>> convertToPinyin(String fullValue) {
        ArrayList<HashSet<String>> phoneticText = new ArrayList<HashSet<String>>();
        for (int i = 0; i < fullValue.length(); ++i) {
            HashSet<String> wordL = this.toPinyin("" + fullValue.charAt(i));
            phoneticText.add(wordL);
        }
        return phoneticText;
    }

    private void concatentateArray(ArrayList<String> in, HashSet<String> out) {
        for (String word : in) {
            if (out.contains(word)) continue;
            out.add(this.getKey(word));
        }
    }
}

