/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardCode;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

public class MatchCode
extends MatchBase
implements Serializable {
    Logger logger = Logger.getLogger("com.identiza");

    public MatchCode(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchCode(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "BEATCODE");
    }

    public MatchCode(String name) {
        super(name);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardCode(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public String getKey(String word) {
        try {
            return word.toUpperCase().replaceFirst("^0+(?!$)", "");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        return this.getKeys(value, batch, false);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch, boolean issearch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        StringBuilder sb = new StringBuilder();
        for (String val : (String[])value) {
            sb.append(this.getKey(val));
        }
        return Collections.singleton(sb.toString());
    }

    public static void main(String[] args) {
        MatchCode mc = new MatchCode("");
        System.out.println(mc.getKeys(new String[]{"V", "0088888", "001"}, true, false));
    }
}

