/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardCompanyName;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class MatchCompanyName
extends MatchBase
implements Serializable {
    private static final long serialVersionUID = 9019823593955645630L;

    public MatchCompanyName(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchCompanyName(String name, int minwidth, int maxwidth, int gradient) throws Exception {
        super(name, minwidth, maxwidth, "MATCHCOMPANYNAME");
        this.maxScore = 90;
    }

    public MatchCompanyName(String name) {
        super(name);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return super.calculateComparisonScore(stdBase, stdComp, isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardCompanyName(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        return this.getKeys(value, batch, false);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch, boolean isSearch) {
        int width = 0;
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> ret = new HashSet<String>();
        String fullValue = "";
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            fullValue = fullValue + " " + value[j];
        }
        if ((fullValue = fullValue.trim()).length() > 3) {
            if (fullValue.length() > 255) {
                fullValue = fullValue.substring(0, 254);
            }
            String[] tempword1 = WordList.split(fullValue);
            width = tempword1.length;
            ArrayList<String> tempwords = this.compressInitials(tempword1);
            String initials = "";
            String key = "";
            String mandkey = "";
            for (String oword : tempwords) {
                String enc;
                String word = WordList.clean(oword);
                if (word == null || word.trim().length() <= 0 || this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 0)) continue;
                if (word.length() > 1) {
                    if (!WordList.containsAnyNumbers(oword)) {
                        enc = this.getKey(word);
                        if (enc.length() > 1) {
                            key = key + enc + ":";
                        }
                        initials = initials + word.charAt(0);
                        continue;
                    }
                    enc = WordList.getNumber(oword).toString();
                    if (enc.length() <= 0) continue;
                    if (!enc.equalsIgnoreCase(oword)) {
                        mandkey = mandkey + enc.trim().toUpperCase();
                        continue;
                    }
                    key = key + this.getKey(word);
                    continue;
                }
                enc = WordList.getNumber(oword).toString();
                if (!enc.equalsIgnoreCase(oword)) {
                    mandkey = mandkey + enc.toUpperCase().trim();
                    continue;
                }
                key = key + enc.toUpperCase() + ":";
            }
            if (key.length() + mandkey.length() > 2) {
                int t;
                if (key.startsWith(":")) {
                    key = key.substring(1);
                }
                if (mandkey.startsWith(":")) {
                    mandkey = key.substring(1);
                }
                String[] combs = key.split(":");
                String part = "";
                for (t = 1; t <= this.maxWidth; ++t) {
                    if (t > combs.length) continue;
                    part = part + combs[t - 1];
                    if (t < this.minWidth && (combs.length >= this.minWidth || t != combs.length)) continue;
                    ret.add(part + mandkey);
                }
                if (isSearch) {
                    part = "";
                    for (t = 1; t <= this.maxWidth; ++t) {
                        if (t >= combs.length) continue;
                        part = part + combs[t];
                        if (t < this.minWidth && (combs.length >= this.minWidth || t != combs.length)) continue;
                        ret.add(part + mandkey);
                    }
                }
            }
        } else {
            ret.add(fullValue.toUpperCase());
        }
        if (!this.isMandatory && ret.size() == 0) {
            ret.add("");
        }
        return ret;
    }

    @Override
    public String getKey(String word) {
        return NYSIIS.encode(word.toUpperCase().trim().replaceAll("\\s|\\.,+", ""));
    }

    public static void main(String[] args) {
        MatchCompanyName mcn = new MatchCompanyName("X");
        mcn.minWidth = 1;
        mcn.maxWidth = 3;
        mcn.setRuleSet(RuleSet.emptyRuleSet());
        for (String k : mcn.getKeys("\u0391 \u0395 \u0392 \u0395 \u039a\u039f\u039d\u03a4\u039f\u0392\u0395\u03a1\u039f\u03a3 ", false, false)) {
            System.out.println(k);
        }
        for (String k : mcn.getKeys("\u0391. \u0395. \u0392. \u0395. \u039a\u039f\u039d\u03a4\u039f\u0392\u0395\u03a1\u039f\u03a3 ", false, false)) {
            System.out.println(k);
        }
        for (String k : mcn.getKeys("\u0391.\u0395.\u0392.\u0395. \u039a\u039f\u039d\u03a4\u039f\u0392\u0395\u03a1\u039f\u03a3 ", false, false)) {
            System.out.println(k);
        }
    }
}

