/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardContent;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class MatchContent
extends MatchBase
implements Serializable {
    public MatchContent(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchContent(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "TXTCONTENT");
    }

    public MatchContent(String name) {
        super(name);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        String fullText = "";
        for (int j = 0; j < ((String[])value).length; ++j) {
            if (value[j] == null) continue;
            fullText = fullText + " " + value[j];
        }
        String[] split = WordList.split(fullText.trim());
        HashSet<String> ret = new HashSet<String>();
        StringBuilder retText = new StringBuilder();
        StringBuilder altText = new StringBuilder();
        for (String val : split) {
            val = this.getKey(val);
            if (this.getKeyAnon() != null && !this.getKeyAnon().isUsefulForComparison(val, 3)) continue;
            retText.append(val);
            retText.append(" ");
            HashSet<String> alts = this.getAlternateWords(val, this.getKeyAnon(), this.getKeyCv());
            for (String alt : alts) {
                if (alt.equals(val)) continue;
                altText.append(alt);
                altText.append(" ");
            }
        }
        ret.add(retText.toString().trim() + " " + altText.toString().trim());
        return ret;
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardContent(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public String getKey(String word) {
        return word.toLowerCase().trim().replaceAll("[^a-z0-9]", "");
    }

    @Override
    public boolean isTextIndex() {
        return true;
    }
}

