/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardDate;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;

public class MatchEditDistanceDate
extends MatchBase
implements Serializable {
    EditDistance ed = new EditDistance();
    DateFormat df = DateFormat.getDateInstance();
    Calendar cal = new GregorianCalendar();

    public MatchEditDistanceDate(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchEditDistanceDate(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "EDDISTDATE");
    }

    public MatchEditDistanceDate(String name) {
        super(name);
    }

    public void setName(String name) {
        this.ruleFunction = name;
    }

    private String sortLetters(String unsorted) {
        char[] content = unsorted.toCharArray();
        Arrays.sort(content);
        return new String(content);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardDate(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public String getKey(String word) {
        Date date = null;
        try {
            date = this.df.parse(word);
        }
        catch (Exception e) {
            return "";
        }
        this.cal.setTime(date);
        String year = this.cal.get(1) + "";
        if (year.length() > 2) {
            year = year.substring(year.length() - 2, year.length());
        }
        int month = this.cal.get(2) + 1;
        int day = this.cal.get(5);
        word = day > month ? year + day + month : year + month + day;
        return word;
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> ret = new HashSet<String>();
        for (String v : (String[])value) {
            ret.add(this.getKey(v));
        }
        return ret;
    }

    public static void main(String[] args) {
        MatchEditDistanceDate date = new MatchEditDistanceDate("");
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add("1947/11/04");
        two.add("1947/11/04");
        StandardDate date1 = new StandardDate(one.toArray(new String[one.size()]), null, null, 1, "");
        StandardDate date2 = new StandardDate(two.toArray(new String[two.size()]), null, null, 1, "");
        System.out.println(date.calculateComparisonScore(date1, date2, false, false));
    }
}

