/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardEndAddress;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.identiza.wordlist.WordObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class MatchEndAddress
extends MatchBase
implements Serializable {
    Logger logger = Logger.getLogger("com.identiza");

    public MatchEndAddress(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchEndAddress(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "ADDRESS");
    }

    public MatchEndAddress(String name) {
        super(name);
    }

    @Override
    public String getKey(String word) {
        try {
            if (word != null) {
                String[] words = WordList.split(word);
                StringBuilder sb = new StringBuilder();
                for (String wordo : words) {
                    sb.append(NYSIIS.encode(wordo));
                }
                return sb.toString();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        return this.getKeys(value, batch, false);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch, boolean isSearch) {
        try {
            if (this.getKeyCv() != null) {
                this.getKeyCv().setChildisParent(false);
            }
        }
        catch (IdentizaException e) {
            e.printStackTrace();
        }
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> keys = new HashSet<String>();
        StringBuilder phrase = new StringBuilder("");
        for (int j = 0; j < value.length; ++j) {
            phrase.append(value[j]);
        }
        if (this.getKeyCv() != null) {
            WordObject parents = this.getKeyCv().getWord(phrase.toString());
            if (parents != null) {
                for (String key : parents.getSameParents()) {
                    keys.add(this.getKey(key));
                }
            }
            if (keys.size() == 0) {
                keys.add(this.getKey(phrase.toString()));
            }
        } else {
            keys.add(this.getKey(phrase.toString()));
        }
        return keys;
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardEndAddress(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }
}

