/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardHeight;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import java.io.Serializable;

public class MatchHeight
extends MatchBase
implements Serializable {
    public MatchHeight(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchHeight(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "HEIGHT");
    }

    public MatchHeight(String name) {
        super(name);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardHeight(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    private String padNumber(double num, int noChars) {
        String pad = "";
        for (int i = 0; i < noChars; ++i) {
            pad = pad + "0";
        }
        String intt = pad + new Double(num).intValue();
        return intt.substring(intt.length() - noChars - 1, intt.length() - 1);
    }

    @Override
    public String getKey(String word) {
        try {
            if (word.contains("'") || word.contains("f")) {
                word = word.replaceAll("foot||ft||'", ".").replaceAll("f", ".");
                word = word.replaceAll("\"", "");
                int dotPos = word.indexOf(".");
                double feet = 0.0;
                double inches = 0.0;
                if (dotPos != -1) {
                    feet = Double.parseDouble(word.substring(dotPos - 1));
                    inches = Double.parseDouble(word.substring(dotPos + 1, 999));
                }
                return this.padNumber(2.54 * (inches + feet * 12.0), 5);
            }
            if (word.contains("cm")) {
                return word.substring(0, word.indexOf("cm") - 1);
            }
            if (word.contains("mm")) {
                double height = Double.parseDouble(word.substring(0, word.indexOf("mm") - 1));
                return this.padNumber(height * 10.0, 5);
            }
            if (word.contains("m")) {
                double height = Double.parseDouble(word.substring(0, word.indexOf("m") - 1));
                return this.padNumber(height * 100.0, 5);
            }
            double height = Double.parseDouble(word);
            if (height > 2.0 && height <= 7.0) {
                height *= 39.37;
            } else if (height <= 2.0) {
                height *= 100.0;
            } else if (!(height > 7.0) || !(height <= 200.0)) {
                height /= 10.0;
            }
            height = new Double(height / 10.0).intValue() * 10;
            return this.padNumber(height, 5);
        }
        catch (Exception e) {
            return "";
        }
    }
}

