/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardPersonName;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class MatchPersonName
extends MatchBase
implements Serializable {
    public MatchPersonName(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchPersonName(String name, int minwidth, int maxwidth, int start, int end, int gradient) throws Exception {
        super(name, minwidth, maxwidth, "MATCHPERSONNAME");
        this.maxScore = 90;
    }

    public MatchPersonName(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardPersonName(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch, boolean isSearch) {
        long sttime = System.currentTimeMillis();
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> ret = new HashSet<String>();
        String fullValue = "";
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            String word = value[j].trim();
            if ((this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 1)) && (this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 1))) continue;
            fullValue = fullValue + " " + word;
        }
        fullValue = fullValue.trim();
        HashMap FNalternates = new HashMap();
        if (fullValue.length() != 0) {
            String[] tempwords = WordList.split(fullValue);
            String lastname = "";
            if (tempwords.length > 0) {
                lastname = tempwords[tempwords.length - 1];
            }
            for (int i = 0; i < tempwords.length - 1; ++i) {
                String word = tempwords[i];
                if (!FNalternates.containsKey(word)) {
                    FNalternates.put(word, new HashSet());
                }
                ((HashSet)FNalternates.get(word)).addAll(this.getAlternateWords(word, this.getKeyAnon(), this.getKeyCv()));
            }
            HashSet firstNameKeys = new HashSet();
            int count = 0;
            for (String origWord : FNalternates.keySet()) {
                if (++count > 2) break;
                HashSet res = (HashSet)FNalternates.get(origWord);
                if (res == null || res.size() <= 0) continue;
                firstNameKeys.addAll(res);
            }
            lastname = this.getKey(lastname);
            if (firstNameKeys.size() > 0) {
                for (String firstnameKey : firstNameKeys) {
                    if (firstnameKey == null || firstnameKey.length() <= 0 || lastname == null || lastname.length() <= 0) continue;
                    ret.add(firstnameKey + lastname);
                }
            } else {
                ret.add(lastname);
            }
        }
        if (ret.size() > 50) {
            this.logger.info(fullValue + " returned a lot of keys " + ret.size());
        }
        if (System.currentTimeMillis() - sttime > 1000L) {
            this.logger.info(fullValue + " took a long time to get keys " + (System.currentTimeMillis() - sttime));
        }
        return ret;
    }

    @Override
    public String getKey(String word) {
        return NYSIIS.encode(word.toUpperCase().trim().replaceAll("[^A-Z0-9]", ""));
    }

    public static void main(String[] args) {
        MatchPersonName mcn = new MatchPersonName("X");
        try {
            mcn.minWidth = 1;
            mcn.maxWidth = 3;
            mcn.setRuleSet(RuleSet.emptyRuleSet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add("MISS");
        one.add("JOAN");
        one.add("SMITH");
        two.add("MRS");
        two.add("JOHN");
        two.add("DAVE");
        System.out.println(mcn.getKeys("FREDERICK", false));
    }
}

