/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardPersonName;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.entity.resolve.utils.Syllables;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MatchPersonNameSyllables
extends MatchBase
implements Serializable {
    public MatchPersonNameSyllables(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchPersonNameSyllables(String name, int minwidth, int maxwidth, int start, int end, int gradient) throws Exception {
        super(name, minwidth, maxwidth, "MATCHPERSONNAME");
        this.maxScore = 90;
    }

    public MatchPersonNameSyllables(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getKeyAnon(), this.getKeyCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardPersonName(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        long sttime = System.currentTimeMillis();
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> ret = new HashSet<String>();
        String fullValue = "";
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            String word = value[j].trim();
            if ((this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 1)) && (this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 1))) continue;
            fullValue = fullValue + " " + word;
        }
        if ((fullValue = fullValue.trim()).length() != 0) {
            String[] words = WordList.split(fullValue);
            ArrayList<String> firstNames = new ArrayList<String>();
            String lastName = words[words.length - 1];
            int pos = 0;
            for (String name : words) {
                if (pos < words.length - 1) {
                    firstNames.add(name);
                }
                ++pos;
            }
            String lastNameSy = this.getKey(this.getBitOfWord(Syllables.getSyllablesFromWord(lastName)));
            for (String firstNameWord : firstNames) {
                HashSet<String> fnalts = this.getAlternateWords(firstNameWord, this.getKeyAnon(), this.getKeyCv());
                for (String alt : fnalts) {
                    ret.add(this.getKey(this.getBitOfWord(Syllables.getSyllablesFromWord(alt))) + lastNameSy);
                }
            }
        }
        if (ret.size() > 50) {
            this.logger.info(fullValue + " returned a lot of keys " + ret.size());
        }
        if (System.currentTimeMillis() - sttime > 1000L) {
            this.logger.info(fullValue + " took a long time to get keys " + (System.currentTimeMillis() - sttime));
        }
        return ret;
    }

    private String getBitOfWord(List<String> syllablesFromWord) {
        if (syllablesFromWord.size() > 1) {
            return syllablesFromWord.get(0) + syllablesFromWord.get(1).charAt(0);
        }
        if (syllablesFromWord.size() > 0) {
            return syllablesFromWord.get(0);
        }
        return "";
    }

    @Override
    public String getKey(String word) {
        return NYSIIS.encode(word.toUpperCase().trim().replaceAll("[^A-Z0-9]", ""));
    }

    public static void main(String[] args) {
        MatchPersonNameSyllables mcn = new MatchPersonNameSyllables("X");
        Object anon = null;
        try {
            mcn.minWidth = 2;
            mcn.maxWidth = 3;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add("MISS");
        one.add("JOAN");
        one.add("SMITH");
        two.add("MRS");
        two.add("JOHN");
        two.add("DAVE");
        System.out.println(mcn.getKeys("ROBERT HAYNES", false));
    }
}

