/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import org.apache.commons.lang3.time.DateUtils;

public class MatchPersonNameXDOB
extends MatchBase
implements Serializable {
    Calendar cal = new GregorianCalendar();
    final String[] possibleFormats = new String[]{"dd-MM-yyyy", "dd/MM/yyyy", "dd-MM-yy", "dd/MM/yyyy", "MM-dd-yyyy", "MM/dd/yyyy", "MM-dd-yy", "MM/dd/yyyy", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm zzzz", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSzzzz", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd"};

    public MatchPersonNameXDOB(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchPersonNameXDOB(String name, int minwidth, int maxwidth, int start, int end, int gradient) throws Exception {
        super(name, minwidth, maxwidth, "MATCHPERSONNAMEXDOB");
        this.maxScore = 90;
    }

    public MatchPersonNameXDOB(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        long sttime = System.currentTimeMillis();
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> ret = new HashSet<String>();
        String dob = "";
        String firstname = "";
        String lastname = "";
        StringBuilder nameall = new StringBuilder();
        for (String val : value) {
            if (val == null || val.length() <= 0) continue;
            if ("0123456789".contains(val.subSequence(0, 1))) {
                dob = val;
                continue;
            }
            String word = val.trim();
            if ((this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 1)) && (this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 1))) continue;
            nameall.append(word + " ");
        }
        String fullValue = nameall.toString().trim();
        if (fullValue.length() != 0) {
            String[] tempwords = WordList.split(fullValue);
            if (tempwords.length > 0) {
                lastname = tempwords[tempwords.length - 1];
            }
            if (tempwords.length > 1) {
                firstname = tempwords[0];
            }
        }
        HashSet<String> fnAlts = this.getAlternateWords(firstname, this.getKeyAnon(), this.getKeyCv());
        Date date = null;
        try {
            date = DateUtils.parseDate((String)dob, (String[])this.possibleFormats);
        }
        catch (ParseException val) {
            // empty catch block
        }
        String dm = "0000";
        if (date != null) {
            this.cal.setTime(date);
            String month = String.format("%02d", this.cal.get(2) + 1);
            String day = String.format("%02d", this.cal.get(5));
            dm = day + month;
            try {
                int d = Integer.parseInt(day);
                int m = Integer.parseInt(month);
                if (d > m) {
                    dm = month + day;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int len = this.getMaxWidth() / 10;
        String lastn = this.getKey(lastname);
        for (String firstn : fnAlts) {
            String fb = firstn.substring(0, Math.min(len, firstn.length()));
            String lb = lastn.substring(0, Math.min(len, lastn.length()));
            ret.add(fb + lb + dm);
            ret.add(lb + fb + dm);
            ret.add(fb + lb + "0000");
        }
        if (System.currentTimeMillis() - sttime > 1000L) {
            this.logger.info(fullValue + " took a long time to get keys " + (System.currentTimeMillis() - sttime));
        }
        return ret;
    }

    @Override
    public String getKey(String word) {
        return NYSIIS.encode(word.toUpperCase().trim().replaceAll("[^A-Z0-9]", ""));
    }
}

