/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardPhonetic;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.RuleSet;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class MatchPhonetic
extends MatchBase
implements Serializable {
    public MatchPhonetic(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchPhonetic(String name, int minwidth, int maxwidth, int start, int end, int gradient) throws Exception {
        super(name, minwidth, maxwidth, "PHONETIC");
        this.maxScore = 90;
    }

    public MatchPhonetic(String name) {
        super(name);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardPhonetic(originalText, words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public String getKey(String word) {
        return NYSIIS.encode(word.toUpperCase().trim().replaceAll("[^A-Z0-9]", ""));
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            String[] tempwords = WordList.split(value[j]);
            for (int i = 0; i < tempwords.length; ++i) {
                String word = tempwords[i];
                if ((this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 1)) && (this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 1))) continue;
                sb.append(this.getKey(word));
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(sb.toString());
        return ret;
    }

    public static void main(String[] args) {
        MatchPhonetic mp = new MatchPhonetic("");
        mp.setRuleSet(RuleSet.emptyRuleSet());
        mp.minWidth = 1;
        mp.maxWidth = 1;
        System.out.println(mp.getKeys("GOOGLE", false));
    }
}

