/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardMisskeyCode;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class MatchPostCode
extends MatchBase
implements Serializable {
    Logger logger = Logger.getLogger("com.identiza");

    public MatchPostCode(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
    }

    public MatchPostCode(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "POSTCODE");
    }

    public MatchPostCode(String name) {
        super(name);
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardMisskeyCode(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public String getKey(String word) {
        int diff = this.maxWidth - this.minWidth;
        if (!word.equalsIgnoreCase("NULL")) {
            StringBuilder sb = new StringBuilder(word.toUpperCase().substring(0, word.length() - diff));
            this.replaceChars(sb);
            return sb.toString();
        }
        return "";
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> ret = new HashSet<String>();
        String fullValue = "";
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            fullValue = fullValue + value[j];
        }
        StringBuilder sb = new StringBuilder();
        for (String v : WordList.split(fullValue)) {
            sb.append(v.trim());
        }
        if (this.getKeyAnon() == null || !this.getKeyAnon().inlist(sb.toString())) {
            ret.add(this.getKey(sb.toString()));
        }
        if (!this.isMandatory) {
            ret.add("");
        }
        return ret;
    }

    private void replaceChars(StringBuilder key1) {
        NYSIIS.replaceAll(key1, " ", "");
        NYSIIS.replaceAll(key1, "K", "X");
        NYSIIS.replaceAll(key1, "M", "N");
        NYSIIS.replaceAll(key1, "8", "B");
        NYSIIS.replaceAll(key1, "6", "G");
        NYSIIS.replaceAll(key1, "1", "I");
        NYSIIS.replaceAll(key1, "L", "I");
        NYSIIS.replaceAll(key1, "0", "O");
        NYSIIS.replaceAll(key1, "5", "S");
        NYSIIS.replaceAll(key1, "V", "U");
        NYSIIS.replaceAll(key1, "Y", "U");
        NYSIIS.replaceAll(key1, "2", "Z");
    }

    public static void main(String[] args) {
        MatchPostCode mpc = new MatchPostCode("");
        mpc.maxWidth = 4;
        mpc.minWidth = 4;
        System.out.println(mpc.getKey("NULL"));
        System.out.println(mpc.getKey("Killcare 2250"));
        ArrayList<String> aTokens = new ArrayList<String>();
        aTokens.add("2065");
        ArrayList<String> bTokens = new ArrayList<String>();
        bTokens.add("2065");
        mpc.gradient = 3;
        aTokens = new ArrayList();
        aTokens.add("2257");
        bTokens = new ArrayList();
        bTokens.add("3343");
    }
}

