/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardString;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class MatchString
extends MatchBase
implements Serializable {
    public MatchString(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
        this.partialKeys = false;
    }

    public MatchString(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "MATCHSTR");
        this.partialKeys = false;
    }

    public MatchString(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public String getKey(String word) {
        if (word == null) {
            return "";
        }
        if (this.getKeyCv() != null) {
            word = this.getKeyLookup().getStem(word.toUpperCase().trim());
        }
        return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardString(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            String[] tempwords = WordList.split(value[j]);
            for (int i = 0; i < tempwords.length; ++i) {
                String word = tempwords[i];
                if ((this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 0)) && (this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 0))) continue;
                sb.append(this.getKey(word));
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(sb.toString());
        return ret;
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch, boolean isSearch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        StringBuilder sb = new StringBuilder();
        String[] v = value;
        for (int j = 0; j < v.length; ++j) {
            if (v[j] == null) continue;
            String stem = null;
            if (this.getKeyLookup() != null) {
                stem = this.getKeyLookup().getStem(v[j]);
            }
            if (stem != null && !stem.equalsIgnoreCase(v[j])) {
                sb.append(stem);
                continue;
            }
            String[] tempwords = WordList.split(value[j]);
            for (int i = 0; i < tempwords.length; ++i) {
                String word = tempwords[i];
                if ((this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 0)) && (this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 0))) continue;
                sb.append(this.getKey(word));
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(sb.toString());
        return ret;
    }

    public static void main(String[] args) {
        MatchString date = new MatchString("");
        ArrayList one = new ArrayList();
        ArrayList two = new ArrayList();
        Object cv = null;
        WordList cvl = null;
        System.out.println(cvl.getStem("US"));
        System.out.println(date.getKeys("United States of America", false, false));
    }
}

