/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MatchSuspect
extends MatchBase
implements Serializable {
    public MatchSuspect(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
        this.partialKeys = false;
    }

    public MatchSuspect(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "SUSPECT");
        this.partialKeys = false;
    }

    public MatchSuspect(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashMap alternates = new HashMap();
        int pos = -1;
        for (String stringVal : value) {
            if (stringVal == null) continue;
            boolean prefixedUnder = stringVal.toLowerCase().startsWith("under");
            boolean prefixedOver = stringVal.toLowerCase().startsWith("over");
            boolean isAge = false;
            double lowernumber = 0.0;
            double highernumber = 100.0;
            ++pos;
            if (stringVal.length() > 0 && "0123456789".contains("" + stringVal.trim().substring(0, 1)) || prefixedUnder || prefixedOver) {
                if (prefixedUnder) {
                    lowernumber = 0.0;
                    highernumber = Double.parseDouble(stringVal.substring(6).trim());
                } else if (prefixedOver) {
                    lowernumber = Double.parseDouble(stringVal.substring(5).trim());
                    highernumber = 100.0;
                } else if (stringVal.contains("-") || stringVal.contains(":")) {
                    String[] split = stringVal.split("\\-|:");
                    if (split.length > 0) {
                        try {
                            lowernumber = Double.parseDouble(split[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (split.length > 1) {
                        try {
                            highernumber = Double.parseDouble(split[1]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    try {
                        highernumber = lowernumber = Double.parseDouble(stringVal);
                    }
                    catch (NumberFormatException split) {
                        // empty catch block
                    }
                }
                if ((double)Math.round(lowernumber) != lowernumber || (double)Math.round(highernumber) != highernumber) {
                    lowernumber = Math.round(lowernumber * 100.0);
                    highernumber = Math.round(highernumber * 100.0);
                }
                if (lowernumber != highernumber) {
                    if (!alternates.containsKey("" + pos)) {
                        alternates.put("" + pos, new ArrayList());
                    }
                    int increment = 1;
                    if (highernumber > 25.0) {
                        increment = 5;
                    }
                    int num = (int)Math.round(lowernumber);
                    while ((double)num <= highernumber) {
                        ((ArrayList)alternates.get("" + pos)).add("" + num);
                        num += increment;
                    }
                    continue;
                }
                if (!alternates.containsKey("" + pos)) {
                    alternates.put("" + pos, new ArrayList());
                }
                ((ArrayList)alternates.get("" + pos)).add("" + (int)Math.round(lowernumber));
                continue;
            }
            if (!alternates.containsKey(stringVal)) {
                alternates.put("" + pos, new ArrayList());
            }
            ((ArrayList)alternates.get("" + pos)).addAll(this.getAlternateWords(stringVal, this.getKeyAnon(), this.getKeyCv()));
        }
        ArrayList<ArrayList<String>> temp = new ArrayList<ArrayList<String>>();
        for (int ppos = 0; ppos <= pos; ++ppos) {
            ArrayList res = (ArrayList)alternates.get("" + ppos);
            if (res == null || res.size() <= 0) continue;
            temp.add(res);
        }
        if (temp.size() > 0) {
            return this.processKeyInOrder(temp, 0, "", this.partialKeys);
        }
        return null;
    }

    @Override
    public String getKey(String word) {
        if (word == null || word.length() == 0) {
            word = "UNKNOWN";
        }
        return word.toUpperCase().trim().replaceAll(" ", "");
    }

    public static void main(String[] args) {
        System.out.println("HELO");
        MatchSuspect susp = new MatchSuspect("");
        Collection<String> ret = susp.getKeys(new String[]{"MALE", "", "1.6-2.0", "", "WHITE EUROPEAN"}, false);
        for (String s : ret) {
            System.out.println(s);
        }
    }
}

