/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardString;
import com.entitystream.identiza.entity.resolve.types.StandardText;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.wordlist.WordList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class MatchText
extends MatchBase
implements Serializable {
    public MatchText(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
        this.partialKeys = true;
    }

    public MatchText(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "MATCHSTR");
        this.partialKeys = true;
    }

    public MatchText(String name) {
        super(name);
        this.partialKeys = true;
    }

    @Override
    public String getKey(String word) {
        if (word != null) {
            return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
        }
        return "";
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getRuleAnon(), this.getRuleCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardText(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < value.length; ++j) {
            if (value[j] == null) continue;
            String[] tempwords = WordList.split(value[j]);
            for (int i = 0; i < tempwords.length; ++i) {
                String word = tempwords[i];
                if ((this.getKeyAnon() == null || !this.getKeyAnon().isUsefulForComparison(word, 0)) && (this.getKeyAnon() != null || !WordList.sisUsefulForComparison(word, 0))) continue;
                sb.append(this.getKey(word));
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(sb.toString());
        return ret;
    }

    public static void main(String[] args) {
        MatchText date = new MatchText("");
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        one.add("1985");
        two.add("19850516");
        StandardString date1 = new StandardString(one.toArray(new String[one.size()]), null, null, 0, "");
        StandardString date2 = new StandardString(two.toArray(new String[two.size()]), null, null, 0, "");
        System.out.println(date.calculateComparisonScore(date1, date2, false, false));
    }
}

