/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.StandardTicker;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class MatchTicker
extends MatchBase
implements Serializable {
    public MatchTicker(String name, int minwidth, int maxwidth) throws Exception {
        super(name, minwidth, maxwidth);
        this.partialKeys = false;
    }

    public MatchTicker(String name, int minwidth, int maxwidth, int start, int end, int gradient, String keyField) throws Exception {
        super(name, minwidth, maxwidth, "MATCHSTR");
        this.partialKeys = false;
    }

    public MatchTicker(String name) {
        super(name);
        this.partialKeys = false;
    }

    @Override
    public String getKey(String word) {
        if (word != null) {
            String[] words = word.split("\\.");
            if (words.length > 0) {
                return words[0].toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
            }
            return word.toUpperCase().trim().replaceAll("[^A-Z0-9]", "");
        }
        return "";
    }

    @Override
    public double calculateComparisonScore(Standardized stdBase, Standardized stdComp, boolean isSearch, boolean asContent) {
        return stdBase.compare(stdComp, this.getKeyAnon(), this.getKeyCv(), isSearch, asContent);
    }

    @Override
    public Standardized standardise(String originalText, String[] words) {
        return new StandardTicker(words, this.getRuleAnon(), this.getRuleLookup(), this.gradient, this.ruleFunction);
    }

    @Override
    public Collection<String> getKeys(Object value, boolean batch) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        HashSet<String> sb = new HashSet<String>();
        for (int j = 0; j < value.length; ++j) {
            String[] strings;
            if (value[j] == null) continue;
            for (String string : strings = value[j].split(" ")) {
                sb.add(this.getKey(string));
            }
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(sb.toString());
        return ret;
    }

    public static void main(String[] args) {
        MatchTicker date = new MatchTicker("");
        String[] one = new String[]{"GBP.AX"};
        String[] two = new String[]{"ORCL.AX"};
        System.out.println(date.getKeys(one, false));
    }
}

