/*
 * Decompiled with CFR 0.152.
 */
package com.entitystream.identiza.entity.resolve.types;

import com.entitystream.identiza.entity.resolve.processing.GradientGenerator;
import com.entitystream.identiza.entity.resolve.types.MatchAddress;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.entity.resolve.utils.EditDistance;
import com.entitystream.identiza.entity.resolve.utils.NYSIIS;
import com.entitystream.identiza.wordlist.WordList;
import java.util.ArrayList;

public class StandardAddress
extends StandardizedSerialized {
    private static final long serialVersionUID = -7045577794471196382L;
    int unitNumber = -1;
    int startHouseNumber;
    int endHouseNumber;
    String houseName;
    String poboxNumber;
    String streetName;
    String locality;
    String postCode;
    int gradient;

    public StandardAddress() {
    }

    public StandardAddress(String[] words, WordList anon, WordList cv, int gradient, String ruleFunction) {
        super(words, anon, cv, gradient, ruleFunction);
        this.gradient = gradient;
        String[] pobox = new String[]{"BOX", "POBOX", "PO", "PBOX"};
        String[] streetnames = new String[]{"ALLEY", "ALY", "APR", "APPROACH", "AUTOBAHN", "AUTO-ESTRADA", "AUTOROUTE", "AUTOSTRADA", "AUTOSTRASSE", "AVE", "AVENUE", "BAY", "BLVD", "BOULEVARD", "BYP", "BYPASS", "BYWAY", "CANYON", "CAUSEWAY", "CIR", "CIRC", "CIRCLE", "CIRCUS", "CLOSE", "COURT", "COVE", "CRES", "CRESCENT", "CROFT", "CSWY", "CT", "CULS-DE-SAC ", "CV", "CYN", "DELL", "DR", "DRIVE", "ESP", "ESPLANADE", "EXPRESSWAY", "EXPY", "FREEWAY", "FRONTAGE", "FWY", "GARDENS", "GARTH", "GATE", "GARDENS", "GDNS", "GRADE", "GREEN", "GRN", "GROVE", "GRV", "HEIGHTS", "HIGHLANDS", "HIGHWAY", "HILL", "HL", "HTS", "HWY", "KEY", "KNL", "KNOLL", "LANE", "LAWN", "LN", "LOOP", "MANOR", "MEWS", "MNR", "MOTORWAY", "MOUNT", "MT", "MTRWY", "MWAY", "NENE", "NOOK", "OVAL", "PARADE", "PARK", "PARKWAY", "PASSAGE", "PATHWAY", "PDE", "PIKE", "PKWY", "PL", "PLACE", "PLAZA", "PLZ", "PROM", "PROMENADE", "PSGE", "PTHWY", "QUADRANT", "QUAY", "RD", "RISE", "ROAD", "ROW", "SPUR", "SQ", "SQUARE", "ST", "STRA", "STRAVENUE", "STREET", "TCE", "TER", "TERRACE", "TPK", "TRACE", "TRAIL", "TRCE", "TRL", "TURNPIKE", "VALE", "VIEW", "VW", "WALK", "WAY", "RTT", "ROUNDABOUT", "UTCA", "UT", "KRT", "TER"};
        int poboxpos = EditDistance.findToken(words, pobox);
        int streetTypePos = EditDistance.findToken(words, streetnames);
        int flatpos = EditDistance.findToken(words, new String[]{"FLAT", "FL", "UNIT", "U", "APT", "APARTMENT", "SHOP", "BUILDING", "BLDG", "SUITE", "SUITES", "/"});
        String city = "";
        if (poboxpos > -1) {
            for (int i = poboxpos + 1; i < words.length; ++i) {
                if (!"0123456789".contains("" + words[i].charAt(0))) continue;
                this.poboxNumber = words[i];
                if (words.length > i + 1) {
                    for (int ii = streetTypePos + 1; ii < words.length; ++ii) {
                        city = city + words[ii] + " ";
                    }
                }
                if (city.length() > 0) {
                    city = city.substring(0, city.length() - 1);
                }
                this.locality = city;
                break;
            }
        } else if (streetTypePos > -1) {
            String[] numbers;
            String streetnumber = "";
            int streetnumberpos = -1;
            String unitnumber = "";
            if (flatpos > -1 && words.length > flatpos) {
                if (words[flatpos].equals("/") && flatpos - 1 > -1) {
                    unitnumber = words[flatpos - 1];
                } else if (words.length > flatpos + 1) {
                    unitnumber = words[flatpos + 1];
                }
            } else {
                flatpos = -2;
            }
            for (int i = flatpos + 2; i < streetTypePos; ++i) {
                if (!"0123456789".contains("" + words[i].charAt(0))) continue;
                streetnumberpos = i;
                if (words[i].contains("\\") || words[i].contains("/")) {
                    String[] numberparts = words[i].split("\\|/");
                    if (numberparts.length > 0) {
                        streetnumber = numberparts[0];
                    }
                    if (numberparts.length <= 1) break;
                    unitnumber = numberparts[1];
                    break;
                }
                streetnumber = words[i];
                break;
            }
            this.unitNumber = EditDistance.niceParseInt(unitnumber);
            this.startHouseNumber = EditDistance.niceParseInt(streetnumber);
            this.endHouseNumber = EditDistance.niceParseInt(streetnumber);
            String street = "";
            if (words.length > streetnumberpos) {
                for (int i = streetnumberpos + 1; i < streetTypePos; ++i) {
                    street = street + words[i] + " ";
                }
            }
            if (street.length() > 0) {
                street = street.substring(0, street.length() - 1);
            }
            this.streetName = street;
            String postcode = "";
            if (words.length > streetTypePos) {
                boolean inPC = false;
                for (int ii = streetTypePos + 1; ii < words.length; ++ii) {
                    if (words[ii] == null) continue;
                    if (words[ii].matches(".*\\d.*") || inPC) {
                        postcode = postcode + words[ii];
                        inPC = true;
                        continue;
                    }
                    city = city + words[ii] + " ";
                }
            }
            if (city.length() > 0) {
                city = city.substring(0, city.length() - 1);
            }
            this.locality = city;
            this.postCode = postcode;
            if (streetnumber.contains("-") && (numbers = streetnumber.split("-")).length > 1) {
                try {
                    this.startHouseNumber = EditDistance.niceParseInt(numbers[0]);
                    this.endHouseNumber = EditDistance.niceParseInt(numbers[numbers.length - 1]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            int streetnumberpos = -1;
            String unitnumber = "";
            String streetnumber = "";
            if (flatpos > -1 && words.length > flatpos + 1) {
                unitnumber = words[flatpos + 1];
            } else {
                flatpos = -2;
            }
            if (streetTypePos == -1) {
                streetTypePos = words.length;
            }
            for (int i = flatpos + 2; i < streetTypePos; ++i) {
                if (!"0123456789".contains("" + words[i].trim().charAt(0))) continue;
                streetnumberpos = i;
                if (words[i].contains("\\") || words[i].contains("/")) {
                    String[] numberparts = words[i].split("\\|/");
                    if (numberparts.length > 0) {
                        streetnumber = numberparts[0];
                    }
                    if (numberparts.length <= 1) break;
                    this.unitNumber = EditDistance.niceParseInt(numberparts[1]);
                    break;
                }
                streetnumber = words[i];
                break;
            }
            String streetAndCity = "";
            if (words.length > streetnumberpos) {
                for (int i = streetnumberpos + 1; i < words.length; ++i) {
                    streetAndCity = streetAndCity + words[i] + " ";
                }
            }
            if (streetAndCity.length() > 0) {
                this.locality = streetAndCity.substring(0, streetAndCity.length() - 1);
            }
            if (streetnumber.contains("-")) {
                String[] numbers = streetnumber.split("-");
                if (numbers.length > 1) {
                    this.startHouseNumber = EditDistance.niceParseInt(numbers[0]);
                    this.endHouseNumber = EditDistance.niceParseInt(numbers[numbers.length - 1]);
                }
            } else {
                this.startHouseNumber = EditDistance.niceParseInt(streetnumber);
                this.endHouseNumber = EditDistance.niceParseInt(streetnumber);
            }
        }
    }

    @Override
    public String toString() {
        if (this.poboxNumber != null && this.poboxNumber.length() > 0) {
            return "PO" + this.poboxNumber + "," + this.locality + "," + this.postCode;
        }
        return Math.abs(this.unitNumber) + "/" + Math.abs(this.startHouseNumber) + "-" + Math.abs(this.endHouseNumber) + "," + this.streetName + "," + this.locality + "," + this.postCode;
    }

    private ArrayList<ArrayList<String>> getAlternates() {
        ArrayList<String> item;
        ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>();
        if (this.poboxNumber != null) {
            item = new ArrayList<String>();
            item.add(this.poboxNumber);
            if (this.locality != null) {
                item.add(this.locality);
            }
            if (this.postCode != null) {
                item.add(this.postCode);
            }
            ret.add(item);
        } else if (this.startHouseNumber != -1) {
            for (int i = this.startHouseNumber; i <= this.endHouseNumber; ++i) {
                ArrayList<String> item2 = new ArrayList<String>();
                if (this.unitNumber != -1) {
                    item2.add("" + this.unitNumber);
                }
                item2.add("" + i);
                if (this.streetName != null) {
                    item2.add(this.streetName);
                }
                if (this.locality != null) {
                    item2.add(this.locality);
                }
                if (this.postCode != null) {
                    item2.add(this.postCode);
                }
                ret.add(item2);
            }
        } else {
            ArrayList<String> item3 = new ArrayList<String>();
            if (this.streetName != null) {
                item3.add(this.streetName);
            }
            if (this.locality != null) {
                item3.add(this.locality);
            }
            if (this.postCode != null) {
                item3.add(this.postCode);
            }
            ret.add(item3);
        }
        item = new ArrayList();
        for (String word : this.originalWords) {
            item.add(word);
        }
        ret.add(item);
        return ret;
    }

    @Override
    public double compare(Standardized otherstd, WordList anon, WordList cv, boolean isSearch, boolean asContent) {
        StandardAddress other = (StandardAddress)otherstd;
        ArrayList<ArrayList<String>> thisAlts = this.getAlternates();
        ArrayList<ArrayList<String>> otherAlts = other.getAlternates();
        double hiscore = 0.0;
        for (ArrayList<String> thisAlt : thisAlts) {
            for (ArrayList<String> otherAlt : otherAlts) {
                double[] gradients;
                int min = Math.min(thisAlt.size(), otherAlt.size());
                int max = Math.max(thisAlt.size(), otherAlt.size());
                if (min <= 3 || (gradients = GradientGenerator.generate(min, max, 2.0, 1.0, 0.2, this.gradient)) == null) continue;
                double div = GradientGenerator.sum(gradients);
                double score = 0.0;
                score = EditDistance.getSimpleEditDistanceOfArrayList(thisAlt, otherAlt, anon, cv, gradients);
                hiscore = Math.max((div - score) / div * 100.0, hiscore);
            }
        }
        boolean numberSame = false;
        if (this.startHouseNumber >= other.startHouseNumber && this.startHouseNumber <= other.endHouseNumber || other.startHouseNumber >= this.startHouseNumber && other.startHouseNumber <= this.endHouseNumber) {
            numberSame = true;
        }
        if (this.streetName != null && other.streetName != null) {
            if (NYSIIS.isEncodeEqual(this.streetName, other.streetName)) {
                if (this.unitNumber == other.unitNumber && numberSame) {
                    return hiscore;
                }
                return 0.0;
            }
            return 0.0;
        }
        return hiscore;
    }

    public static void main(String[] args) {
        MatchAddress mcn = new MatchAddress("X");
        mcn.gradient = 2;
        Object anon = null;
        ArrayList<String> one = new ArrayList<String>();
        ArrayList<String> two = new ArrayList<String>();
        for (String v : WordList.split("3-5 PENN STREET, DARWIN, NT. 800")) {
            if (v == null) continue;
            one.add(v);
        }
        System.out.println(mcn.standardise("", one.toArray(new String[one.size()])));
        for (String v : WordList.split("4 PENN STREET DARWIN")) {
            if (v == null) continue;
            two.add(v);
        }
        System.out.println(mcn.standardise("", two.toArray(new String[two.size()])));
        System.out.println(mcn.calculateComparisonScore(new StandardAddress(one.toArray(new String[one.size()]), null, null, 2, ""), new StandardAddress(two.toArray(new String[two.size()]), null, null, 2, ""), false, false));
    }
}

